/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.synthesis;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.org.objectweb.asm.Attribute;
import com.android.tools.r8.org.objectweb.asm.ByteVector;
import com.android.tools.r8.org.objectweb.asm.ClassReader;
import com.android.tools.r8.org.objectweb.asm.ClassWriter;
import com.android.tools.r8.org.objectweb.asm.Label;
import com.android.tools.r8.synthesis.SynthesizingContext;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.synthesis.SyntheticMethodBuilder;
import com.android.tools.r8.synthesis.SyntheticNaming;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;

public class SyntheticMarker {
    private static final String SYNTHETIC_MARKER_ATTRIBUTE_TYPE_NAME = "com.android.tools.r8.SynthesizedClass";
    private static final SyntheticMarker NO_MARKER = new SyntheticMarker(null, null);
    private final SyntheticNaming.SyntheticKind kind;
    private final SynthesizingContext context;

    public static Attribute getMarkerAttributePrototype(SyntheticNaming syntheticNaming) {
        return new MarkerAttribute(null, syntheticNaming);
    }

    public static void writeMarkerAttribute(ClassWriter writer, SyntheticNaming.SyntheticKind kind, SyntheticItems syntheticItems) {
        writer.visitAttribute(new MarkerAttribute(kind, syntheticItems.getNaming()));
    }

    public static SyntheticMarker readMarkerAttribute(Attribute attribute) {
        if (attribute instanceof MarkerAttribute) {
            MarkerAttribute marker = (MarkerAttribute)attribute;
            return new SyntheticMarker(marker.kind, null);
        }
        return null;
    }

    public static void addMarkerToClass(DexProgramClass clazz, SyntheticNaming.SyntheticKind kind, InternalOptions options) {
        assert (!options.isGeneratingClassFiles());
        clazz.setAnnotations(clazz.annotations().getWithAddedOrReplaced(DexAnnotation.createAnnotationSynthesizedClass(kind, options.itemFactory)));
    }

    public static SyntheticMarker stripMarkerFromClass(DexProgramClass clazz, AppView<?> appView) {
        if (clazz.originatesFromClassResource()) {
            SyntheticMarker marker = clazz.stripSyntheticInputMarker();
            if (marker == null) {
                return NO_MARKER;
            }
            assert (marker.getContext() == null);
            DexType contextType = SyntheticMarker.getSyntheticContextType(clazz.type, marker.kind, appView.dexItemFactory());
            SynthesizingContext context = SynthesizingContext.fromSyntheticInputClass(clazz, contextType, appView);
            return new SyntheticMarker(marker.kind, context);
        }
        SyntheticMarker marker = SyntheticMarker.internalStripMarkerFromClass(clazz, appView);
        assert (marker != NO_MARKER || !DexAnnotation.hasSynthesizedClassAnnotation(clazz.annotations(), appView.dexItemFactory(), appView.getSyntheticItems()));
        return marker;
    }

    private static SyntheticMarker internalStripMarkerFromClass(DexProgramClass clazz, AppView<?> appView) {
        if (clazz.superType != appView.dexItemFactory().objectType) {
            return NO_MARKER;
        }
        if (SyntheticMarker.isDefinitelyNotSyntheticProgramClass(clazz)) {
            return NO_MARKER;
        }
        SyntheticNaming.SyntheticKind kind = DexAnnotation.getSynthesizedClassAnnotationInfo(clazz.annotations(), appView.dexItemFactory(), appView.getSyntheticItems());
        if (kind == null) {
            return NO_MARKER;
        }
        assert (clazz.annotations().size() == 1);
        if (kind.isSingleSyntheticMethod()) {
            if (!clazz.interfaces.isEmpty()) {
                return NO_MARKER;
            }
            for (DexEncodedMethod method : clazz.methods()) {
                if (SyntheticMethodBuilder.isValidSingleSyntheticMethod(method)) continue;
                return NO_MARKER;
            }
        }
        clazz.setAnnotations(DexAnnotationSet.empty());
        DexType context = SyntheticMarker.getSyntheticContextType(clazz.type, kind, appView.dexItemFactory());
        return new SyntheticMarker(kind, SynthesizingContext.fromSyntheticInputClass(clazz, context, appView));
    }

    public static boolean isDefinitelyNotSyntheticProgramClass(DexProgramClass clazz) {
        ClassAccessFlags flags = clazz.accessFlags;
        return !flags.isSynthetic() || flags.isEnum();
    }

    private static DexType getSyntheticContextType(DexType type, SyntheticNaming.SyntheticKind kind, DexItemFactory factory) {
        String prefix = SyntheticNaming.getPrefixForExternalSyntheticType(kind, type);
        return factory.createType(DescriptorUtils.getDescriptorFromClassBinaryName(prefix));
    }

    public SyntheticMarker(SyntheticNaming.SyntheticKind kind, SynthesizingContext context) {
        this.kind = kind;
        this.context = context;
    }

    public boolean isSyntheticMethods() {
        return this.kind != null && this.kind.isSingleSyntheticMethod();
    }

    public boolean isSyntheticClass() {
        return this.kind != null && !this.kind.isSingleSyntheticMethod();
    }

    public SyntheticNaming.SyntheticKind getKind() {
        return this.kind;
    }

    public SynthesizingContext getContext() {
        return this.context;
    }

    private static class MarkerAttribute
    extends Attribute {
        private SyntheticNaming.SyntheticKind kind;
        private final SyntheticNaming syntheticNaming;

        public MarkerAttribute(SyntheticNaming.SyntheticKind kind, SyntheticNaming syntheticNaming) {
            super(SyntheticMarker.SYNTHETIC_MARKER_ATTRIBUTE_TYPE_NAME);
            this.kind = kind;
            this.syntheticNaming = syntheticNaming;
        }

        @Override
        protected Attribute read(ClassReader classReader, int offset, int length, char[] charBuffer, int codeAttributeOffset, Label[] labels) {
            short id = classReader.readShort(offset);
            assert (id >= 0);
            SyntheticNaming.SyntheticKind kind = this.syntheticNaming.fromId(id);
            return new MarkerAttribute(kind, this.syntheticNaming);
        }

        @Override
        protected ByteVector write(ClassWriter classWriter, byte[] code, int codeLength, int maxStack, int maxLocals) {
            ByteVector byteVector = new ByteVector();
            assert (0 <= this.kind.getId() && this.kind.getId() <= Short.MAX_VALUE);
            byteVector.putShort(this.kind.getId());
            return byteVector;
        }
    }
}

