/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.synthesis;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.synthesis.Rewritable;
import com.android.tools.r8.synthesis.SynthesizingContext;
import com.android.tools.r8.synthesis.SyntheticMethodDefinition;
import com.android.tools.r8.synthesis.SyntheticNaming;
import com.android.tools.r8.synthesis.SyntheticProgramClassReference;
import com.android.tools.r8.synthesis.SyntheticProgramReference;
import com.android.tools.r8.synthesis.SyntheticReference;
import java.util.function.Consumer;
import java.util.function.Function;

class SyntheticMethodReference
extends SyntheticReference<SyntheticMethodReference, SyntheticMethodDefinition, DexProgramClass>
implements SyntheticProgramReference,
Rewritable<SyntheticMethodReference> {
    final DexMethod method;

    SyntheticMethodReference(SyntheticNaming.SyntheticKind kind, SynthesizingContext context, DexMethod method) {
        super(kind, context);
        this.method = method;
    }

    @Override
    public DexType getHolder() {
        return this.method.holder;
    }

    @Override
    DexMethod getReference() {
        return this.method;
    }

    @Override
    SyntheticMethodDefinition lookupDefinition(Function<DexType, DexClass> definitions) {
        DexClass clazz = definitions.apply(this.method.holder);
        if (clazz == null) {
            return null;
        }
        assert (clazz.isProgramClass());
        ProgramMethod definition = clazz.asProgramClass().lookupProgramMethod(this.method);
        return definition != null ? new SyntheticMethodDefinition(this.getKind(), this.getContext(), definition) : null;
    }

    @Override
    SyntheticMethodReference internalRewrite(SynthesizingContext rewrittenContext, GraphLens.NonIdentityGraphLens lens) {
        DexMethod rewritten = lens.getRenamedMethodSignature(this.method);
        if (this.method.getHolderType() != rewritten.getHolderType() && !lens.isSimpleRenaming(this.method, rewritten)) {
            assert (SyntheticNaming.verifyNotInternalSynthetic(rewritten.holder));
            return null;
        }
        if (rewrittenContext == this.getContext() && rewritten == this.method) {
            return this;
        }
        return new SyntheticMethodReference(this.getKind(), rewrittenContext, rewritten);
    }

    @Override
    public void apply(Consumer<SyntheticMethodReference> onMethod, Consumer<SyntheticProgramClassReference> onClass) {
        onMethod.accept(this);
    }
}

