/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.tracereferences;

import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.tracereferences.Formatter;
import com.android.tools.r8.tracereferences.TraceReferencesConsumer;
import com.android.tools.r8.utils.StringUtils;
import java.util.List;

class KeepRuleFormatter
extends Formatter {
    final boolean allowObfuscation;

    KeepRuleFormatter(boolean allowObfuscation) {
        this.allowObfuscation = allowObfuscation;
    }

    @Override
    protected void printTypeHeader(TraceReferencesConsumer.TracedClass tracedClass) {
        if (tracedClass.isMissingDefinition()) {
            this.appendLine("# Missing class: " + ((ClassReference)tracedClass.getReference()).getTypeName());
            return;
        }
        this.append(this.allowObfuscation ? "-keep,allowobfuscation" : "-keep");
        if (((TraceReferencesConsumer.ClassAccessFlags)tracedClass.getAccessFlags()).isInterface()) {
            this.appendLine(" interface " + ((ClassReference)tracedClass.getReference()).getTypeName() + " {");
        } else if (((TraceReferencesConsumer.ClassAccessFlags)tracedClass.getAccessFlags()).isEnum()) {
            this.appendLine(" enum " + ((ClassReference)tracedClass.getReference()).getTypeName() + " {");
        } else {
            this.appendLine(" class " + ((ClassReference)tracedClass.getReference()).getTypeName() + " {");
        }
    }

    @Override
    protected void printConstructorName(MethodReference method) {
        this.append("<init>");
    }

    @Override
    protected void printField(TraceReferencesConsumer.TracedField field) {
        this.append("  " + ((FieldReference)field.getReference()).getFieldType().getTypeName() + " " + ((FieldReference)field.getReference()).getFieldName() + ";" + System.lineSeparator());
    }

    @Override
    protected void printMethod(TraceReferencesConsumer.TracedMethod tracedMethod) {
        if (((MethodReference)tracedMethod.getReference()).getMethodName().equals("<clinit>")) {
            return;
        }
        this.append("  ");
        if (((TraceReferencesConsumer.MethodAccessFlags)tracedMethod.getAccessFlags()).isPublic()) {
            this.append("public ");
        } else if (((TraceReferencesConsumer.MethodAccessFlags)tracedMethod.getAccessFlags()).isPrivate()) {
            this.append("private ");
        } else if (((TraceReferencesConsumer.MethodAccessFlags)tracedMethod.getAccessFlags()).isProtected()) {
            this.append("protected ");
        }
        if (((TraceReferencesConsumer.MethodAccessFlags)tracedMethod.getAccessFlags()).isStatic()) {
            this.append("static ");
        }
        this.printNameAndReturn((MethodReference)tracedMethod.getReference());
        this.printArguments((MethodReference)tracedMethod.getReference());
        this.appendLine(";");
    }

    @Override
    protected void printPackageNames(List<String> packageNames) {
        if (!packageNames.isEmpty()) {
            this.append("-keeppackagenames " + StringUtils.join(",", packageNames) + System.lineSeparator());
        }
    }

    @Override
    protected void printTypeFooter() {
        this.appendLine("}");
    }
}

