/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.FeatureSplit;
import com.android.tools.r8.features.ClassToFeatureSplitMap;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.synthesis.SyntheticItems;

public class AccessUtils {
    public static boolean isAccessibleInSameContextsAs(DexType newType, DexType oldType, AppView<AppInfoWithLiveness> appView) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        DexType newBaseType = newType.toBaseType(dexItemFactory);
        if (!newBaseType.isClassType()) {
            return true;
        }
        DexClass newBaseClass = appView.definitionFor(newBaseType);
        if (newBaseClass == null) {
            return false;
        }
        DexType oldBaseType = oldType.toBaseType(dexItemFactory);
        if (!newBaseClass.isPublic()) {
            assert (oldBaseType.isClassType());
            DexClass oldBaseClass = appView.definitionFor(oldBaseType);
            if (oldBaseClass == null || oldBaseClass.isPublic() || !newBaseType.isSamePackage(oldBaseType)) {
                return false;
            }
        }
        if (newBaseClass.isProgramClass()) {
            FeatureSplit newFeatureSplit;
            ClassToFeatureSplitMap classToFeatureSplitMap = appView.appInfo().getClassToFeatureSplitMap();
            SyntheticItems syntheticItems = appView.getSyntheticItems();
            if (classToFeatureSplitMap != null && !(newFeatureSplit = classToFeatureSplitMap.getFeatureSplit(newBaseClass.asProgramClass(), syntheticItems)).isBase() && newFeatureSplit != classToFeatureSplitMap.getFeatureSplit(oldBaseType, syntheticItems)) {
                return false;
            }
        }
        return true;
    }
}

