/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.utils.DexVersion;
import com.android.tools.r8.utils.structural.Ordered;
import java.util.Arrays;
import java.util.List;

public final class AndroidApiLevel
extends Enum<AndroidApiLevel>
implements Ordered<AndroidApiLevel> {
    public static final /* enum */ AndroidApiLevel B = new AndroidApiLevel(1);
    public static final /* enum */ AndroidApiLevel B_1_1 = new AndroidApiLevel(2);
    public static final /* enum */ AndroidApiLevel C = new AndroidApiLevel(3);
    public static final /* enum */ AndroidApiLevel D = new AndroidApiLevel(4);
    public static final /* enum */ AndroidApiLevel E = new AndroidApiLevel(5);
    public static final /* enum */ AndroidApiLevel E_0_1 = new AndroidApiLevel(6);
    public static final /* enum */ AndroidApiLevel E_MR1 = new AndroidApiLevel(7);
    public static final /* enum */ AndroidApiLevel F = new AndroidApiLevel(8);
    public static final /* enum */ AndroidApiLevel G = new AndroidApiLevel(9);
    public static final /* enum */ AndroidApiLevel G_MR1 = new AndroidApiLevel(10);
    public static final /* enum */ AndroidApiLevel H = new AndroidApiLevel(11);
    public static final /* enum */ AndroidApiLevel H_MR1 = new AndroidApiLevel(12);
    public static final /* enum */ AndroidApiLevel H_MR2 = new AndroidApiLevel(13);
    public static final /* enum */ AndroidApiLevel I = new AndroidApiLevel(14);
    public static final /* enum */ AndroidApiLevel I_MR1 = new AndroidApiLevel(15);
    public static final /* enum */ AndroidApiLevel J = new AndroidApiLevel(16);
    public static final /* enum */ AndroidApiLevel J_MR1 = new AndroidApiLevel(17);
    public static final /* enum */ AndroidApiLevel J_MR2 = new AndroidApiLevel(18);
    public static final /* enum */ AndroidApiLevel K = new AndroidApiLevel(19);
    public static final /* enum */ AndroidApiLevel K_WATCH = new AndroidApiLevel(20);
    public static final /* enum */ AndroidApiLevel L = new AndroidApiLevel(21);
    public static final /* enum */ AndroidApiLevel L_MR1 = new AndroidApiLevel(22);
    public static final /* enum */ AndroidApiLevel M = new AndroidApiLevel(23);
    public static final /* enum */ AndroidApiLevel N = new AndroidApiLevel(24);
    public static final /* enum */ AndroidApiLevel N_MR1 = new AndroidApiLevel(25);
    public static final /* enum */ AndroidApiLevel O = new AndroidApiLevel(26);
    public static final /* enum */ AndroidApiLevel O_MR1 = new AndroidApiLevel(27);
    public static final /* enum */ AndroidApiLevel P = new AndroidApiLevel(28);
    public static final /* enum */ AndroidApiLevel Q = new AndroidApiLevel(29);
    public static final /* enum */ AndroidApiLevel R = new AndroidApiLevel(30);
    public static final /* enum */ AndroidApiLevel S = new AndroidApiLevel(31);
    public static final /* enum */ AndroidApiLevel Sv2 = new AndroidApiLevel(32);
    public static final /* enum */ AndroidApiLevel T = new AndroidApiLevel(33);
    public static final /* enum */ AndroidApiLevel ANDROID_PLATFORM = new AndroidApiLevel(10000);
    public static final AndroidApiLevel LATEST;
    private static final /* synthetic */ AndroidApiLevel[] $VALUES;
    private final int level;

    public static AndroidApiLevel[] values() {
        return (AndroidApiLevel[])$VALUES.clone();
    }

    public static AndroidApiLevel valueOf(String name) {
        return Enum.valueOf(AndroidApiLevel.class, name);
    }

    private AndroidApiLevel(int level) {
        this.level = level;
    }

    public static AndroidApiLevel getDefault() {
        return B;
    }

    public static List<AndroidApiLevel> getAndroidApiLevelsSorted() {
        return Arrays.asList(AndroidApiLevel.values());
    }

    public static AndroidApiLevel getMinAndroidApiLevel(DexVersion dexVersion) {
        switch (dexVersion) {
            case V35: {
                return B;
            }
            case V37: {
                return N;
            }
            case V38: {
                return O;
            }
            case V39: {
                return P;
            }
        }
        throw new Unreachable();
    }

    public static AndroidApiLevel getAndroidApiLevel(int apiLevel) {
        assert (apiLevel > 0);
        assert (T == LATEST);
        assert (ANDROID_PLATFORM.isGreaterThan(LATEST));
        switch (apiLevel) {
            case 1: {
                return B;
            }
            case 2: {
                return B_1_1;
            }
            case 3: {
                return C;
            }
            case 4: {
                return D;
            }
            case 5: {
                return E;
            }
            case 6: {
                return E_0_1;
            }
            case 7: {
                return E_MR1;
            }
            case 8: {
                return F;
            }
            case 9: {
                return G;
            }
            case 10: {
                return G_MR1;
            }
            case 11: {
                return H;
            }
            case 12: {
                return H_MR1;
            }
            case 13: {
                return H_MR2;
            }
            case 14: {
                return I;
            }
            case 15: {
                return I_MR1;
            }
            case 16: {
                return J;
            }
            case 17: {
                return J_MR1;
            }
            case 18: {
                return J_MR2;
            }
            case 19: {
                return K;
            }
            case 20: {
                return K_WATCH;
            }
            case 21: {
                return L;
            }
            case 22: {
                return L_MR1;
            }
            case 23: {
                return M;
            }
            case 24: {
                return N;
            }
            case 25: {
                return N_MR1;
            }
            case 26: {
                return O;
            }
            case 27: {
                return O_MR1;
            }
            case 28: {
                return P;
            }
            case 29: {
                return Q;
            }
            case 30: {
                return R;
            }
            case 31: {
                return S;
            }
            case 32: {
                return Sv2;
            }
            case 33: {
                return T;
            }
            case 10000: {
                return ANDROID_PLATFORM;
            }
        }
        return LATEST;
    }

    static {
        $VALUES = new AndroidApiLevel[]{B, B_1_1, C, D, E, E_0_1, E_MR1, F, G, G_MR1, H, H_MR1, H_MR2, I, I_MR1, J, J_MR1, J_MR2, K, K_WATCH, L, L_MR1, M, N, N_MR1, O, O_MR1, P, Q, R, S, Sv2, T, ANDROID_PLATFORM};
        LATEST = T;
    }

    public int getLevel() {
        return this.level;
    }

    public String getName() {
        return "Android " + this.name();
    }

    public AndroidApiLevel max(AndroidApiLevel other) {
        return Ordered.max(this, other);
    }

    public DexVersion getDexVersion() {
        return DexVersion.getDexVersion(this);
    }
}

