/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.androidapi.AndroidApiLevelCompute;
import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.LibraryMethod;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.optimize.inliner.NopWhyAreYouNotInliningReporter;
import com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import com.android.tools.r8.utils.InternalOptions;

public class AndroidApiLevelUtils {
    public static boolean isApiSafeForInlining(ProgramMethod caller, ProgramMethod inlinee, InternalOptions options) {
        return AndroidApiLevelUtils.isApiSafeForInlining(caller, inlinee, options, NopWhyAreYouNotInliningReporter.getInstance());
    }

    public static boolean isApiSafeForInlining(ProgramMethod caller, ProgramMethod inlinee, InternalOptions options, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        if (!options.apiModelingOptions().enableApiCallerIdentification) {
            return true;
        }
        if (caller.getHolderType() == inlinee.getHolderType()) {
            return true;
        }
        ComputedApiLevel callerApiLevelForCode = ((DexEncodedMethod)caller.getDefinition()).getApiLevelForCode();
        if (callerApiLevelForCode.isUnknownApiLevel()) {
            whyAreYouNotInliningReporter.reportCallerHasUnknownApiLevel();
            return false;
        }
        ComputedApiLevel inlineeApiLevelForCode = ((DexEncodedMethod)inlinee.getDefinition()).getApiLevelForCode();
        if (!((DexEncodedMethod)caller.getDefinition()).getApiLevelForCode().isGreaterThanOrEqualTo(inlineeApiLevelForCode)) {
            whyAreYouNotInliningReporter.reportInlineeHigherApiCall(callerApiLevelForCode, inlineeApiLevelForCode);
            return false;
        }
        return true;
    }

    public static ComputedApiLevel getApiReferenceLevelForMerging(AppView<?> appView, AndroidApiLevelCompute apiLevelCompute, DexProgramClass clazz) {
        return AndroidApiLevelUtils.getMembersApiReferenceLevelForMerging(clazz, apiLevelCompute.computeApiLevelForDefinition(clazz.allImmediateSupertypes(), apiLevelCompute.getPlatformApiLevelOrUnknown(appView)));
    }

    private static ComputedApiLevel getMembersApiReferenceLevelForMerging(DexProgramClass clazz, ComputedApiLevel memberLevel) {
        for (DexEncodedMethod method : clazz.methods()) {
            if (method.hasCode()) {
                memberLevel = memberLevel.max(method.getApiLevelForCode());
            }
            if (!memberLevel.isUnknownApiLevel()) continue;
            return memberLevel;
        }
        return memberLevel;
    }

    public static boolean isApiSafeForMemberRebinding(LibraryMethod method, AndroidApiLevelCompute androidApiLevelCompute, InternalOptions options) {
        ComputedApiLevel apiLevel = androidApiLevelCompute.computeApiLevelForLibraryReference(method.getReference(), ComputedApiLevel.unknown());
        if (apiLevel.isUnknownApiLevel()) {
            return false;
        }
        assert (options.apiModelingOptions().enableApiCallerIdentification);
        return apiLevel.asKnownApiLevel().getApiLevel().isLessThanOrEqualTo(options.getMinApiLevel());
    }
}

