/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.BaseCompilerCommand;
import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResourceConsumer;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class AndroidAppConsumers {
    private final AndroidApp.Builder builder = AndroidApp.builder();
    private boolean closed = false;
    private ProgramConsumer programConsumer = null;
    private StringConsumer proguardMapConsumer = null;

    public AndroidAppConsumers() {
    }

    public AndroidAppConsumers(BaseCompilerCommand.Builder builder) {
        builder.setProgramConsumer(this.wrapProgramConsumer(builder.getProgramConsumer()));
    }

    public AndroidAppConsumers(InternalOptions options) {
        options.programConsumer = this.wrapProgramConsumer(options.programConsumer);
        options.proguardMapConsumer = this.wrapProguardMapConsumer(options.proguardMapConsumer);
    }

    public ProgramConsumer wrapProgramConsumer(ProgramConsumer consumer) {
        assert (this.programConsumer == null);
        if (consumer instanceof ClassFileConsumer) {
            this.wrapClassFileConsumer((ClassFileConsumer)consumer);
        } else if (consumer instanceof DexIndexedConsumer) {
            this.wrapDexIndexedConsumer((DexIndexedConsumer)consumer);
        } else if (consumer instanceof DexFilePerClassFileConsumer) {
            this.wrapDexFilePerClassFileConsumer((DexFilePerClassFileConsumer)consumer);
        } else {
            assert (consumer == null);
            this.wrapDexIndexedConsumer(null);
        }
        assert (this.programConsumer != null);
        return this.programConsumer;
    }

    public StringConsumer wrapProguardMapConsumer(StringConsumer consumer) {
        assert (this.proguardMapConsumer == null);
        if (consumer != null) {
            this.proguardMapConsumer = new StringConsumer.ForwardingConsumer(consumer){
                StringBuilder stringBuilder;
                {
                    this.stringBuilder = null;
                }

                @Override
                public void accept(String string, DiagnosticsHandler handler) {
                    super.accept(string, handler);
                    if (this.stringBuilder == null) {
                        this.stringBuilder = new StringBuilder();
                    }
                    this.stringBuilder.append(string);
                }

                @Override
                public void finished(DiagnosticsHandler handler) {
                    super.finished(handler);
                    if (this.stringBuilder != null) {
                        AndroidAppConsumers.this.builder.setProguardMapOutputData(this.stringBuilder.toString());
                    }
                }
            };
        }
        return this.proguardMapConsumer;
    }

    public DexIndexedConsumer wrapDexIndexedConsumer(final DexIndexedConsumer consumer) {
        assert (this.programConsumer == null);
        DexIndexedConsumer.ForwardingConsumer wrapped = new DexIndexedConsumer.ForwardingConsumer(consumer){
            private Int2ReferenceSortedMap<DescriptorsWithContents> files;
            {
                super(consumer2);
                this.files = new Int2ReferenceAVLTreeMap<DescriptorsWithContents>();
            }

            @Override
            public void accept(int fileIndex, ByteDataView data2, Set<String> descriptors, DiagnosticsHandler handler) {
                super.accept(fileIndex, data2, descriptors, handler);
                this.addDexFile(fileIndex, data2.copyByteData(), descriptors);
            }

            @Override
            public void finished(DiagnosticsHandler handler) {
                super.finished(handler);
                if (!AndroidAppConsumers.this.closed) {
                    AndroidAppConsumers.this.closed = true;
                    this.files.forEach((v, d) -> AndroidAppConsumers.this.builder.addDexProgramData(d.contents, d.descriptors));
                    this.files = null;
                } else assert (this.getDataResourceConsumer() != null);
            }

            @Override
            public DataResourceConsumer getDataResourceConsumer() {
                final DataResourceConsumer dataResourceConsumer = consumer != null ? consumer.getDataResourceConsumer() : null;
                return new DataResourceConsumer(){

                    @Override
                    public void accept(DataDirectoryResource directory, DiagnosticsHandler diagnosticsHandler) {
                        if (dataResourceConsumer != null) {
                            dataResourceConsumer.accept(directory, diagnosticsHandler);
                        }
                    }

                    @Override
                    public void accept(DataEntryResource file, DiagnosticsHandler diagnosticsHandler) {
                        try {
                            byte[] bytes = ByteStreams.toByteArray(file.getByteStream());
                            DataEntryResource copy = DataEntryResource.fromBytes(bytes, file.getName(), file.getOrigin());
                            AndroidAppConsumers.this.builder.addDataResource(copy);
                            if (dataResourceConsumer != null) {
                                dataResourceConsumer.accept(copy, diagnosticsHandler);
                            }
                        }
                        catch (ResourceException | IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public void finished(DiagnosticsHandler handler) {
                        if (dataResourceConsumer != null) {
                            dataResourceConsumer.finished(handler);
                        }
                    }
                };
            }

            synchronized void addDexFile(int fileIndex, byte[] data2, Set<String> descriptors) {
                this.files.put(fileIndex, new DescriptorsWithContents(descriptors, data2));
            }
        };
        this.programConsumer = wrapped;
        return wrapped;
    }

    public DexFilePerClassFileConsumer wrapDexFilePerClassFileConsumer(final DexFilePerClassFileConsumer consumer) {
        assert (this.programConsumer == null);
        DexFilePerClassFileConsumer.ForwardingConsumer wrapped = new DexFilePerClassFileConsumer.ForwardingConsumer(consumer){
            private TreeMap<String, DescriptorsWithContents> files;
            {
                super(consumer2);
                this.files = new TreeMap();
            }

            @Override
            public void accept(String primaryClassDescriptor, ByteDataView data2, Set<String> descriptors, DiagnosticsHandler handler) {
                super.accept(primaryClassDescriptor, data2, descriptors, handler);
                this.addDexFile(primaryClassDescriptor, data2.copyByteData(), descriptors);
            }

            synchronized void addDexFile(String primaryClassDescriptor, byte[] data2, Set<String> descriptors) {
                this.files.put(primaryClassDescriptor, new DescriptorsWithContents(descriptors, data2));
            }

            @Override
            public void finished(DiagnosticsHandler handler) {
                super.finished(handler);
                if (!AndroidAppConsumers.this.closed) {
                    AndroidAppConsumers.this.closed = true;
                    this.files.forEach((v, d) -> AndroidAppConsumers.this.builder.addDexProgramData(d.contents, d.descriptors, (String)v));
                    this.files = null;
                } else assert (this.getDataResourceConsumer() != null);
            }

            @Override
            public DataResourceConsumer getDataResourceConsumer() {
                final DataResourceConsumer dataResourceConsumer = consumer != null ? consumer.getDataResourceConsumer() : null;
                return new DataResourceConsumer(){

                    @Override
                    public void accept(DataDirectoryResource directory, DiagnosticsHandler diagnosticsHandler) {
                        if (dataResourceConsumer != null) {
                            dataResourceConsumer.accept(directory, diagnosticsHandler);
                        }
                    }

                    @Override
                    public void accept(DataEntryResource file, DiagnosticsHandler diagnosticsHandler) {
                        try {
                            byte[] bytes = ByteStreams.toByteArray(file.getByteStream());
                            DataEntryResource copy = DataEntryResource.fromBytes(bytes, file.getName(), file.getOrigin());
                            AndroidAppConsumers.this.builder.addDataResource(copy);
                            if (dataResourceConsumer != null) {
                                dataResourceConsumer.accept(copy, diagnosticsHandler);
                            }
                        }
                        catch (ResourceException | IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public void finished(DiagnosticsHandler handler) {
                        if (dataResourceConsumer != null) {
                            dataResourceConsumer.finished(handler);
                        }
                    }
                };
            }
        };
        this.programConsumer = wrapped;
        return wrapped;
    }

    public ClassFileConsumer wrapClassFileConsumer(final ClassFileConsumer consumer) {
        assert (this.programConsumer == null);
        ClassFileConsumer.ForwardingConsumer wrapped = new ClassFileConsumer.ForwardingConsumer(consumer){
            private List<DescriptorsWithContents> files;
            {
                super(consumer2);
                this.files = new ArrayList<DescriptorsWithContents>();
            }

            @Override
            public void accept(ByteDataView data2, String descriptor, DiagnosticsHandler handler) {
                super.accept(data2, descriptor, handler);
                this.addClassFile(data2.copyByteData(), descriptor);
            }

            synchronized void addClassFile(byte[] data2, String descriptor) {
                this.files.add(new DescriptorsWithContents(Collections.singleton(descriptor), data2));
            }

            @Override
            public void finished(DiagnosticsHandler handler) {
                super.finished(handler);
                if (!AndroidAppConsumers.this.closed) {
                    AndroidAppConsumers.this.closed = true;
                    this.files.forEach(d -> AndroidAppConsumers.this.builder.addClassProgramData(d.contents, Origin.unknown(), d.descriptors));
                    this.files = null;
                } else assert (this.getDataResourceConsumer() != null);
            }

            @Override
            public DataResourceConsumer getDataResourceConsumer() {
                final DataResourceConsumer dataResourceConsumer = consumer != null ? consumer.getDataResourceConsumer() : null;
                return new DataResourceConsumer(){

                    @Override
                    public void accept(DataDirectoryResource directory, DiagnosticsHandler diagnosticsHandler) {
                        if (dataResourceConsumer != null) {
                            dataResourceConsumer.accept(directory, diagnosticsHandler);
                        }
                    }

                    @Override
                    public void accept(DataEntryResource file, DiagnosticsHandler diagnosticsHandler) {
                        try {
                            byte[] bytes = ByteStreams.toByteArray(file.getByteStream());
                            DataEntryResource copy = DataEntryResource.fromBytes(bytes, file.getName(), file.getOrigin());
                            AndroidAppConsumers.this.builder.addDataResource(copy);
                            if (dataResourceConsumer != null) {
                                dataResourceConsumer.accept(copy, diagnosticsHandler);
                            }
                        }
                        catch (ResourceException | IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public void finished(DiagnosticsHandler handler) {
                        if (dataResourceConsumer != null) {
                            dataResourceConsumer.finished(handler);
                        }
                    }
                };
            }
        };
        this.programConsumer = wrapped;
        return wrapped;
    }

    public AndroidApp build() {
        assert (this.closed);
        return this.builder.build();
    }

    private static class DescriptorsWithContents {
        final Set<String> descriptors;
        final byte[] contents;

        private DescriptorsWithContents(Set<String> descriptors, byte[] contents) {
            this.descriptors = descriptors;
            this.contents = contents;
        }
    }
}

