/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.OutputBuilder;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ZipUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ArchiveBuilder
implements OutputBuilder {
    private final Path archive;
    private final Origin origin;
    private ZipOutputStream stream = null;
    private boolean closed = false;
    private int openCount = 0;
    private int classesFileIndex = 0;
    private Map<Integer, DelayedData> delayedClassesDexFiles = new HashMap<Integer, DelayedData>();
    private SortedSet<DelayedData> delayedWrites = new TreeSet<DelayedData>();

    public ArchiveBuilder(Path archive) {
        this.archive = archive;
        this.origin = new PathOrigin(archive);
    }

    private void writeDelayed(DiagnosticsHandler handler) {
        assert (this.delayedClassesDexFiles.isEmpty());
        for (DelayedData data2 : this.delayedWrites) {
            if (data2.isDirectory) {
                assert (data2.content == null);
                this.writeDirectoryNow(data2.name, handler);
                continue;
            }
            assert (data2.content != null);
            this.writeFileNow(data2.name, data2.content, handler);
        }
    }

    private ZipOutputStream getStreamRaw() throws IOException {
        if (this.stream != null) {
            return this.stream;
        }
        this.stream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(this.archive, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING)));
        return this.stream;
    }

    private synchronized ZipOutputStream getStream() throws IOException {
        assert (!this.closed);
        return this.getStreamRaw();
    }

    private void handleIOException(IOException e, DiagnosticsHandler handler) {
        ExceptionDiagnostic diagnostic = new ExceptionDiagnostic(e, this.origin);
        if (e instanceof ZipException && e.getMessage().startsWith("duplicate entry")) {
            handler.warning(diagnostic);
        } else {
            handler.error(diagnostic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDirectoryNow(String name, DiagnosticsHandler handler) {
        if (name.charAt(name.length() - 1) != '/') {
            name = name + '/';
        }
        ZipEntry entry = new ZipEntry(name);
        entry.setTime(0L);
        ArchiveBuilder archiveBuilder = this;
        synchronized (archiveBuilder) {
            try {
                ZipOutputStream zip2 = this.getStream();
                zip2.putNextEntry(entry);
                zip2.closeEntry();
            }
            catch (IOException e) {
                this.handleIOException(e, handler);
            }
        }
    }

    private void writeFileNow(String name, ByteDataView content, DiagnosticsHandler handler) {
        try {
            ZipUtils.writeToZipStream(this.getStream(), name, content, 8);
        }
        catch (IOException e) {
            this.handleIOException(e, handler);
        }
    }

    private void writeNextIfAvailable(DiagnosticsHandler handler) {
        DelayedData data2 = this.delayedClassesDexFiles.remove(this.classesFileIndex);
        while (data2 != null) {
            this.writeFileNow(data2.name, data2.content, handler);
            ++this.classesFileIndex;
            data2 = this.delayedClassesDexFiles.remove(this.classesFileIndex);
        }
    }

    @Override
    public synchronized void open() {
        assert (!this.closed);
        ++this.openCount;
    }

    @Override
    public synchronized void close(DiagnosticsHandler handler) {
        assert (!this.closed);
        --this.openCount;
        if (this.openCount == 0) {
            this.writeDelayed(handler);
            this.closed = true;
            try {
                this.getStreamRaw().close();
                this.stream = null;
            }
            catch (IOException e) {
                handler.error(new ExceptionDiagnostic(e, this.origin));
            }
        }
    }

    @Override
    public synchronized void addDirectory(String name, DiagnosticsHandler handler) {
        this.delayedWrites.add(DelayedData.createDirectory(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFile(String name, DataEntryResource content, DiagnosticsHandler handler) {
        block17: {
            try {
                InputStream in;
                block18: {
                    in = content.getByteStream();
                    Throwable throwable = null;
                    try {
                        ByteDataView view = ByteDataView.of(ByteStreams.toByteArray(in));
                        ArchiveBuilder archiveBuilder = this;
                        synchronized (archiveBuilder) {
                            this.delayedWrites.add(DelayedData.createFile(name, view));
                        }
                        if (in == null) break block17;
                        if (throwable == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (in != null) {
                                if (throwable != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    in.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    try {
                        in.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    break block17;
                }
                in.close();
            }
            catch (IOException e) {
                this.handleIOException(e, handler);
            }
            catch (ResourceException e) {
                handler.error(new StringDiagnostic("Failed to open input: " + e.getMessage(), content.getOrigin()));
            }
        }
    }

    @Override
    public synchronized void addFile(String name, ByteDataView content, DiagnosticsHandler handler) {
        this.delayedWrites.add(DelayedData.createFile(name, ByteDataView.of(content.copyByteData())));
    }

    @Override
    public synchronized void addIndexedClassFile(int index, String name, ByteDataView content, DiagnosticsHandler handler) {
        if (index == this.classesFileIndex) {
            this.writeFileNow(name, content, handler);
            ++this.classesFileIndex;
            this.writeNextIfAvailable(handler);
        } else {
            this.delayedClassesDexFiles.put(index, new DelayedData(name, ByteDataView.of(content.copyByteData()), false));
        }
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Path getPath() {
        return this.archive;
    }

    private static class DelayedData
    implements Comparable<DelayedData> {
        public final String name;
        public final ByteDataView content;
        public final boolean isDirectory;

        public static DelayedData createFile(String name, ByteDataView content) {
            return new DelayedData(name, content, false);
        }

        public static DelayedData createDirectory(String name) {
            return new DelayedData(name, null, true);
        }

        private DelayedData(String name, ByteDataView content, boolean isDirectory) {
            this.name = name;
            this.content = content;
            this.isDirectory = isDirectory;
        }

        @Override
        public int compareTo(DelayedData other) {
            if (other == null) {
                return this.name.compareTo(null);
            }
            return this.name.compareTo(other.name);
        }
    }
}

