/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.org.objectweb.asm.ClassReader;
import com.android.tools.r8.org.objectweb.asm.Label;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.ArchiveResourceProvider;
import com.android.tools.r8.utils.StreamUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CfLineToMethodMapper {
    private static final String NAME_DESCRIPTOR_SEPARATOR = ";;";
    private Map<String, Int2ReferenceOpenHashMap<String>> sourceMethodMapping = null;
    private final AndroidApp inputApp;

    public CfLineToMethodMapper(AndroidApp inputApp) {
        this.inputApp = inputApp;
    }

    private void readLineNumbersFromClassFiles() throws ResourceException {
        ClassVisitor classVisitor = new ClassVisitor();
        for (ProgramResourceProvider resourceProvider : this.inputApp.getProgramResourceProviders()) {
            if (resourceProvider instanceof ArchiveResourceProvider) {
                ArchiveResourceProvider provider = (ArchiveResourceProvider)resourceProvider;
                provider.accept(programResource -> {
                    if (programResource.getKind() != ProgramResource.Kind.CF) {
                        return;
                    }
                    try {
                        new ClassReader(StreamUtils.StreamToByteArrayClose(programResource.getByteStream())).accept(classVisitor, 4);
                    }
                    catch (ResourceException | IOException exception) {
                        // empty catch block
                    }
                });
                continue;
            }
            for (ProgramResource programResource2 : resourceProvider.getProgramResources()) {
                if (programResource2.getKind() != ProgramResource.Kind.CF) continue;
                try {
                    new ClassReader(StreamUtils.StreamToByteArrayClose(programResource2.getByteStream())).accept(classVisitor, 4);
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getName(String nameAndDescriptor) {
        int index = nameAndDescriptor.indexOf(NAME_DESCRIPTOR_SEPARATOR);
        assert (index > 0);
        return nameAndDescriptor.substring(0, index);
    }

    public static String getDescriptor(String nameAndDescriptor) {
        int index = nameAndDescriptor.indexOf(NAME_DESCRIPTOR_SEPARATOR);
        assert (index > 0);
        return nameAndDescriptor.substring(index + NAME_DESCRIPTOR_SEPARATOR.length());
    }

    public String lookupNameAndDescriptor(String binaryName, int lineNumber) throws ResourceException {
        Int2ReferenceOpenHashMap<String> lineMappings;
        if (this.sourceMethodMapping == null) {
            this.sourceMethodMapping = new HashMap<String, Int2ReferenceOpenHashMap<String>>();
            this.readLineNumbersFromClassFiles();
        }
        return (lineMappings = this.sourceMethodMapping.get(binaryName)) == null ? null : lineMappings.get(lineNumber);
    }

    private static class MethodLineVisitor
    extends MethodVisitor {
        private final String nameAndDescriptor;
        private final Map<Integer, String> lineMethodMapping;

        private MethodLineVisitor(String nameAndDescriptor, Map<Integer, String> lineMethodMapping) {
            super(589824);
            this.nameAndDescriptor = nameAndDescriptor;
            this.lineMethodMapping = lineMethodMapping;
        }

        @Override
        public void visitLineNumber(int line, Label start) {
            this.lineMethodMapping.put(line, this.nameAndDescriptor);
        }
    }

    private class ClassVisitor
    extends com.android.tools.r8.org.objectweb.asm.ClassVisitor {
        private Int2ReferenceOpenHashMap<String> currentLineNumberMapping;

        private ClassVisitor() {
            super(589824);
            this.currentLineNumberMapping = null;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.currentLineNumberMapping = CfLineToMethodMapper.this.sourceMethodMapping.computeIfAbsent(name, ignored -> new Int2ReferenceOpenHashMap());
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            return new MethodLineVisitor(name + CfLineToMethodMapper.NAME_DESCRIPTOR_SEPARATOR + descriptor, this.currentLineNumberMapping);
        }
    }
}

