/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import java.util.Comparator;

public class ClassReferenceUtils {
    private static final Comparator<ClassReference> COMPARATOR = Comparator.comparing(ClassReference::getDescriptor);

    public static int compare(ClassReference classReference, ClassReference other) {
        return ClassReferenceUtils.getClassReferenceComparator().compare(classReference, other);
    }

    public static int compare(ClassReference classReference, FieldReference other) {
        int comparisonResult = ClassReferenceUtils.getClassReferenceComparator().compare(classReference, other.getHolderClass());
        return comparisonResult != 0 ? comparisonResult : -1;
    }

    public static int compare(ClassReference classReference, MethodReference other) {
        int comparisonResult = ClassReferenceUtils.getClassReferenceComparator().compare(classReference, other.getHolderClass());
        return comparisonResult != 0 ? comparisonResult : -1;
    }

    public static Comparator<ClassReference> getClassReferenceComparator() {
        return COMPARATOR;
    }

    public static DexType toDexType(ClassReference classReference, DexItemFactory dexItemFactory) {
        return dexItemFactory.createType(classReference.getDescriptor());
    }
}

