/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.CompatProguardCommandBuilder;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.R8;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.utils.ArchiveResourceProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CompileDumpCompatR8 {
    private static final List<String> VALID_OPTIONS = Arrays.asList("--classfile", "--compat", "--debug", "--release");
    private static final List<String> VALID_OPTIONS_WITH_SINGLE_OPERAND = Arrays.asList("--output", "--lib", "--classpath", "--min-api", "--main-dex-rules", "--main-dex-list", "--main-dex-list-output", "--pg-conf", "--pg-map-output", "--desugared-lib", "--threads");
    private static final List<String> VALID_OPTIONS_WITH_TWO_OPERANDS = Arrays.asList("--feature-jar");

    private static boolean FileUtils_isArchive(Path path) {
        String name = path.getFileName().toString().toLowerCase();
        return name.endsWith(".apk") || name.endsWith(".jar") || name.endsWith(".zip") || name.endsWith(".aar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args2) throws CompilationFailedException {
        boolean isCompatMode = false;
        OutputMode outputMode = OutputMode.DexIndexed;
        Path outputPath = null;
        Path pgMapOutput = null;
        Path desugaredLibJson = null;
        CompilationMode compilationMode = CompilationMode.RELEASE;
        ArrayList<Path> program = new ArrayList<Path>();
        LinkedHashMap<Path, Path> features = new LinkedHashMap<Path, Path>();
        ArrayList<Path> library = new ArrayList<Path>();
        ArrayList<Path> classpath = new ArrayList<Path>();
        ArrayList<Path> config = new ArrayList<Path>();
        ArrayList<Path> mainDexRulesFiles = new ArrayList<Path>();
        int minApi = 1;
        int threads = -1;
        for (int i = 0; i < args2.length; ++i) {
            String option = args2[i];
            if (VALID_OPTIONS.contains(option)) {
                switch (option) {
                    case "--classfile": {
                        outputMode = OutputMode.ClassFile;
                        break;
                    }
                    case "--compat": {
                        isCompatMode = true;
                        break;
                    }
                    case "--debug": {
                        compilationMode = CompilationMode.DEBUG;
                        break;
                    }
                    case "--release": {
                        compilationMode = CompilationMode.RELEASE;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unimplemented option: " + option);
                    }
                }
                continue;
            }
            if (VALID_OPTIONS_WITH_SINGLE_OPERAND.contains(option)) {
                String operand = args2[++i];
                switch (option) {
                    case "--output": {
                        outputPath = Paths.get(operand, new String[0]);
                        break;
                    }
                    case "--lib": {
                        library.add(Paths.get(operand, new String[0]));
                        break;
                    }
                    case "--classpath": {
                        classpath.add(Paths.get(operand, new String[0]));
                        break;
                    }
                    case "--min-api": {
                        minApi = Integer.parseInt(operand);
                        break;
                    }
                    case "--pg-conf": {
                        config.add(Paths.get(operand, new String[0]));
                        break;
                    }
                    case "--pg-map-output": {
                        pgMapOutput = Paths.get(operand, new String[0]);
                        break;
                    }
                    case "--desugared-lib": {
                        desugaredLibJson = Paths.get(operand, new String[0]);
                        break;
                    }
                    case "--threads": {
                        threads = Integer.parseInt(operand);
                        break;
                    }
                    case "--main-dex-rules": {
                        mainDexRulesFiles.add(Paths.get(operand, new String[0]));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unimplemented option: " + option);
                    }
                }
                continue;
            }
            if (VALID_OPTIONS_WITH_TWO_OPERANDS.contains(option)) {
                String firstOperand = args2[++i];
                String secondOperand = args2[++i];
                switch (option) {
                    case "--feature-jar": {
                        Path featureIn = Paths.get(firstOperand, new String[0]);
                        Path featureOut = Paths.get(secondOperand, new String[0]);
                        if (!CompileDumpCompatR8.FileUtils_isArchive(featureIn)) {
                            throw new IllegalArgumentException("Expected an archive, got `" + featureIn.toString() + "`.");
                        }
                        features.put(featureIn, featureOut);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unimplemented option: " + option);
                    }
                }
                continue;
            }
            program.add(Paths.get(option, new String[0]));
        }
        R8Command.Builder commandBuilder = (R8Command.Builder)((R8Command.Builder)((R8Command.Builder)((R8Command.Builder)new CompatProguardCommandBuilder(isCompatMode).addProgramFiles(program)).addLibraryFiles(library)).addClasspathFiles(classpath)).addProguardConfigurationFiles(config).addMainDexRulesFiles(mainDexRulesFiles).setOutput(outputPath, outputMode).setMode(compilationMode);
        if (desugaredLibJson != null) {
            commandBuilder.addDesugaredLibraryConfiguration(CompileDumpCompatR8.readAllBytesJava7(desugaredLibJson));
        }
        if (outputMode != OutputMode.ClassFile) {
            commandBuilder.setMinApiLevel(minApi);
        }
        features.forEach((in, out) -> commandBuilder.addFeatureSplit(featureBuilder -> featureBuilder.addProgramResourceProvider(ArchiveResourceProvider.fromArchive(in, true)).setProgramConsumer(new DexIndexedConsumer.ArchiveConsumer((Path)out)).build()));
        if (pgMapOutput != null) {
            commandBuilder.setProguardMapOutputPath(pgMapOutput);
        }
        R8Command command = (R8Command)commandBuilder.build();
        if (threads != -1) {
            ExecutorService executor = Executors.newWorkStealingPool(threads);
            try {
                R8.run(command, executor);
            }
            finally {
                executor.shutdown();
            }
        } else {
            R8.run(command);
        }
    }

    private static String readAllBytesJava7(Path filePath) {
        String content = "";
        try {
            content = new String(Files.readAllBytes(filePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }
}

