/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.utils.TraversalContinuation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class DepthFirstSearchWorkListBase<N, T extends DFSNodeImpl<N>> {
    private final ArrayDeque<T> workList = new ArrayDeque();

    abstract T createDfsNode(N var1);

    abstract TraversalContinuation<?> internalOnVisit(T var1);

    abstract TraversalContinuation<?> internalOnJoin(T var1);

    final T internalEnqueueNode(N value) {
        T dfsNode = this.createDfsNode(value);
        if (((DFSNodeImpl)dfsNode).isNotProcessed()) {
            this.workList.addLast(dfsNode);
        }
        return dfsNode;
    }

    @SafeVarargs
    public final TraversalContinuation<?> run(N ... roots) {
        return this.run((Collection<N>)Arrays.asList(roots));
    }

    public final TraversalContinuation<?> run(Collection<N> roots) {
        roots.forEach(this::internalEnqueueNode);
        TraversalContinuation<Object> continuation = TraversalContinuation.doContinue();
        while (!this.workList.isEmpty()) {
            DFSNodeImpl node = (DFSNodeImpl)this.workList.removeLast();
            if (node.isFinished()) continue;
            if (node.isNotProcessed()) {
                this.workList.addLast(node);
                node.setWaiting();
                continuation = this.internalOnVisit(node);
            } else {
                assert (node.seenAndNotProcessed());
                continuation = this.internalOnJoin(node);
                node.setFinished();
            }
            if (!continuation.shouldBreak()) continue;
            return continuation;
        }
        return continuation;
    }

    public static abstract class StatefulDepthFirstSearchWorkList<N, S>
    extends DepthFirstSearchWorkListBase<N, DFSNodeWithStateImpl<N, S>> {
        private final Map<DFSNodeWithStateImpl<N, S>, List<DFSNodeWithState<N, S>>> childStateMap = new IdentityHashMap<DFSNodeWithStateImpl<N, S>, List<DFSNodeWithState<N, S>>>();

        protected abstract TraversalContinuation<?> process(DFSNodeWithState<N, S> var1, Function<N, DFSNodeWithState<N, S>> var2);

        protected abstract TraversalContinuation<?> joiner(DFSNodeWithState<N, S> var1, List<DFSNodeWithState<N, S>> var2);

        @Override
        DFSNodeWithStateImpl<N, S> createDfsNode(N node) {
            return new DFSNodeWithStateImpl(node);
        }

        @Override
        TraversalContinuation<?> internalOnVisit(DFSNodeWithStateImpl<N, S> node) {
            ArrayList childStates = new ArrayList();
            List removedChildStates = this.childStateMap.put(node, childStates);
            assert (removedChildStates == null);
            return this.process(node, successor -> {
                DFSNodeWithStateImpl successorNode = (DFSNodeWithStateImpl)this.internalEnqueueNode(successor);
                childStates.add(successorNode);
                return successorNode;
            });
        }

        @Override
        protected TraversalContinuation<?> internalOnJoin(DFSNodeWithStateImpl<N, S> node) {
            return this.joiner(node, this.childStateMap.computeIfAbsent(node, n -> {
                assert (false) : "Unexpected joining of not visited node";
                return new ArrayList();
            }));
        }
    }

    public static abstract class DepthFirstSearchWorkList<N>
    extends DepthFirstSearchWorkListBase<N, DFSNodeImpl<N>> {
        protected abstract TraversalContinuation<?> process(DFSNode<N> var1, Function<N, DFSNode<N>> var2);

        @Override
        DFSNodeImpl<N> createDfsNode(N node) {
            return new DFSNodeImpl(node);
        }

        @Override
        TraversalContinuation<?> internalOnVisit(DFSNodeImpl<N> node) {
            return this.process(node, this::internalEnqueueNode);
        }

        @Override
        protected TraversalContinuation<?> internalOnJoin(DFSNodeImpl<N> node) {
            return TraversalContinuation.doContinue();
        }
    }

    static class DFSNodeWithStateImpl<N, S>
    extends DFSNodeImpl<N>
    implements DFSNodeWithState<N, S> {
        private S state;

        private DFSNodeWithStateImpl(N node) {
            super(node);
        }

        @Override
        public S getState() {
            return this.state;
        }

        @Override
        public void setState(S state) {
            this.state = state;
        }

        @Override
        public boolean hasState() {
            return this.state != null;
        }
    }

    static class DFSNodeImpl<N>
    implements DFSNode<N> {
        private final N node;
        private ProcessingState processingState = ProcessingState.NOT_PROCESSED;

        private DFSNodeImpl(N node) {
            this.node = node;
        }

        boolean isNotProcessed() {
            return this.processingState == ProcessingState.NOT_PROCESSED;
        }

        boolean isFinished() {
            return this.processingState == ProcessingState.FINISHED;
        }

        void setWaiting() {
            this.processingState = ProcessingState.WAITING;
        }

        void setFinished() {
            assert (this.processingState != ProcessingState.FINISHED);
            this.processingState = ProcessingState.FINISHED;
        }

        @Override
        public N getNode() {
            return this.node;
        }

        @Override
        public boolean seenAndNotProcessed() {
            return this.processingState == ProcessingState.WAITING;
        }
    }

    static enum ProcessingState {
        NOT_PROCESSED,
        WAITING,
        FINISHED;

    }

    public static interface DFSNodeWithState<N, S>
    extends DFSNode<N> {
        public S getState();

        public void setState(S var1);

        public boolean hasState();
    }

    public static interface DFSNode<N> {
        public N getNode();

        public boolean seenAndNotProcessed();
    }
}

