/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.InvalidDescriptorException;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.ClassNameMapper;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;

public class DescriptorUtils {
    public static final char DESCRIPTOR_PACKAGE_SEPARATOR = '/';
    public static final char JAVA_PACKAGE_SEPARATOR = '.';
    public static final char INNER_CLASS_SEPARATOR = '$';
    private static final Map<String, String> typeNameToLetterMap = ImmutableMap.builder().put("void", "V").put("boolean", "Z").put("byte", "B").put("short", "S").put("char", "C").put("int", "I").put("long", "J").put("float", "F").put("double", "D").build();

    private static String internalToDescriptor(String typeName, boolean shorty, boolean ignorePrimitives) {
        String descriptor = null;
        if (!ignorePrimitives) {
            descriptor = typeNameToLetterMap.get(typeName);
        }
        if (descriptor != null) {
            return descriptor;
        }
        if (shorty) {
            return "L";
        }
        if (typeName.endsWith("[]")) {
            return "[" + DescriptorUtils.internalToDescriptor(typeName.substring(0, typeName.length() - 2), shorty, ignorePrimitives);
        }
        return "L" + typeName.replace('.', '/') + ";";
    }

    public static String javaTypeToDescriptor(String typeName) {
        assert (typeName.indexOf(47) == -1);
        return DescriptorUtils.internalToDescriptor(typeName, false, false);
    }

    public static String javaTypeToDescriptorIgnorePrimitives(String typeName) {
        assert (typeName.indexOf(47) == -1);
        return DescriptorUtils.internalToDescriptor(typeName, false, true);
    }

    public static String javaTypeToDescriptorIfValidJavaType(String typeName) {
        if (DescriptorUtils.isValidJavaType(typeName)) {
            return DescriptorUtils.javaTypeToDescriptor(typeName);
        }
        return null;
    }

    public static String toArrayDescriptor(int dimensions, String baseTypeDescriptor) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dimensions; ++i) {
            sb.append('[');
        }
        sb.append(baseTypeDescriptor);
        return sb.toString();
    }

    public static boolean isValidJavaType(String typeName) {
        if (typeName.length() == 0) {
            return false;
        }
        char last = '\u0000';
        for (int i = 0; i < typeName.length(); ++i) {
            char c = typeName.charAt(i);
            if (c == ';' || c == '[' || c == '/') {
                return false;
            }
            if (c == '.' && (i == 0 || last == '.')) {
                return false;
            }
            last = c;
        }
        return true;
    }

    public static String javaTypeToShorty(String typeName) {
        return DescriptorUtils.internalToDescriptor(typeName, true, false);
    }

    public static String descriptorToJavaType(String descriptor) {
        return DescriptorUtils.descriptorToJavaType(descriptor, null);
    }

    public static String descriptorToInternalName(String descriptor) {
        switch (descriptor.charAt(0)) {
            case '[': {
                return descriptor;
            }
            case 'L': {
                return descriptor.substring(1, descriptor.length() - 1);
            }
        }
        throw new Unreachable("Not array or class type");
    }

    public static String descriptorToKotlinClassifier(String descriptor) {
        String classifier = DescriptorUtils.getBinaryNameFromDescriptor(descriptor).replace('$', '.');
        if (descriptor.startsWith("Lj$/")) {
            assert (classifier.startsWith("j./"));
            return "j$/" + classifier.substring(3);
        }
        return classifier;
    }

    public static String descriptorToJavaType(String descriptor, ClassNameMapper classNameMapper) {
        char c = descriptor.charAt(0);
        switch (c) {
            case 'L': {
                assert (descriptor.charAt(descriptor.length() - 1) == ';');
                String clazz = descriptor.substring(1, descriptor.length() - 1).replace('/', '.');
                String originalName = classNameMapper == null ? clazz : classNameMapper.deobfuscateClassName(clazz);
                return originalName;
            }
            case '[': {
                return DescriptorUtils.descriptorToJavaType(descriptor.substring(1), classNameMapper) + "[]";
            }
        }
        return DescriptorUtils.primitiveDescriptorToJavaType(c);
    }

    public static boolean isPrimitiveDescriptor(String descriptor) {
        if (descriptor.length() != 1) {
            return false;
        }
        return DescriptorUtils.isPrimitiveType(descriptor.charAt(0));
    }

    public static boolean isPrimitiveType(char c) {
        return c == 'Z' || c == 'B' || c == 'S' || c == 'C' || c == 'I' || c == 'F' || c == 'J' || c == 'D';
    }

    public static boolean isVoidDescriptor(String descriptor) {
        return descriptor.length() == 1 && DescriptorUtils.isVoidType(descriptor.charAt(0));
    }

    public static boolean isVoidType(char c) {
        return c == 'V';
    }

    public static boolean isArrayDescriptor(String descriptor) {
        if (descriptor.length() < 2) {
            return false;
        }
        if (descriptor.charAt(0) == '[') {
            return DescriptorUtils.isDescriptor(descriptor.substring(1));
        }
        return false;
    }

    public static boolean isDescriptor(String descriptor) {
        return DescriptorUtils.isClassDescriptor(descriptor) || DescriptorUtils.isPrimitiveDescriptor(descriptor) || DescriptorUtils.isArrayDescriptor(descriptor);
    }

    public static String primitiveDescriptorToJavaType(char primitive) {
        switch (primitive) {
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'S': {
                return "short";
            }
            case 'C': {
                return "char";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
        }
        throw new Unreachable("Unknown type " + primitive);
    }

    public static String primitiveDescriptorToBoxedInternalName(char primitive) {
        switch (primitive) {
            case 'V': {
                return "java/lang/Void";
            }
            case 'Z': {
                return "java/lang/Boolean";
            }
            case 'B': {
                return "java/lang/Byte";
            }
            case 'S': {
                return "java/lang/Short";
            }
            case 'C': {
                return "java/lang/Character";
            }
            case 'I': {
                return "java/lang/Integer";
            }
            case 'J': {
                return "java/lang/Long";
            }
            case 'F': {
                return "java/lang/Float";
            }
            case 'D': {
                return "java/lang/Double";
            }
        }
        throw new Unreachable("Unknown type " + primitive);
    }

    public static String getUnqualifiedClassNameFromDescriptor(String classDescriptor) {
        return DescriptorUtils.getUnqualifiedClassNameFromBinaryName(DescriptorUtils.getClassBinaryNameFromDescriptor(classDescriptor));
    }

    public static String getClassNameFromDescriptor(String classDescriptor) {
        return DescriptorUtils.getClassBinaryNameFromDescriptor(classDescriptor).replace('/', '.');
    }

    public static String getSimpleClassNameFromDescriptor(String classDescriptor) {
        return classDescriptor.substring(DescriptorUtils.getSimpleClassNameIndex(classDescriptor), classDescriptor.length() - 1);
    }

    public static String replaceSimpleClassNameInDescriptor(String classDescriptor, String newSimpleName) {
        return "L" + classDescriptor.substring(1, DescriptorUtils.getSimpleClassNameIndex(classDescriptor)) + newSimpleName + ";";
    }

    private static int getSimpleClassNameIndex(String classDescriptor) {
        return Integer.max(classDescriptor.lastIndexOf("/"), 0) + 1;
    }

    public static String getCanonicalNameFromDescriptor(String classDescriptor) {
        return DescriptorUtils.getClassNameFromDescriptor(classDescriptor).replace('$', '.');
    }

    public static String getClassBinaryName(Class<?> clazz) {
        return DescriptorUtils.getBinaryNameFromJavaType(clazz.getTypeName());
    }

    public static String getPackageNameFromDescriptor(String descriptor) {
        return DescriptorUtils.getPackageNameFromBinaryName(DescriptorUtils.getClassBinaryNameFromDescriptor(descriptor));
    }

    public static String getClassBinaryNameFromDescriptor(String classDescriptor) {
        assert (DescriptorUtils.isClassDescriptor(classDescriptor)) : "Invalid class descriptor " + classDescriptor;
        return classDescriptor.substring(1, classDescriptor.length() - 1);
    }

    public static String getPackageBinaryNameFromJavaType(String packageName) {
        return packageName.replace('.', '/');
    }

    public static String getBinaryNameFromJavaType(String className) {
        return className.replace('.', '/');
    }

    public static String getJavaTypeFromBinaryName(String className) {
        return className.replace('/', '.');
    }

    public static String getBinaryNameFromDescriptor(String classDescriptor) {
        assert (DescriptorUtils.isClassDescriptor(classDescriptor));
        return classDescriptor.substring(1, classDescriptor.length() - 1);
    }

    public static String getDescriptorFromClassBinaryName(String typeBinaryName) {
        assert (typeBinaryName != null);
        return 'L' + typeBinaryName + ';';
    }

    public static String getDescriptorFromKotlinClassifier(String className) {
        assert (className != null);
        assert (!className.contains("[")) : className;
        return 'L' + className.replace('.', '$') + ';';
    }

    public static String getUnqualifiedClassNameFromBinaryName(String classBinaryName) {
        int simpleNameIndex = classBinaryName.lastIndexOf(47);
        return simpleNameIndex < 0 ? classBinaryName : classBinaryName.substring(simpleNameIndex + 1);
    }

    public static String computeInnerClassSeparator(DexType outerClass, DexType innerClass, DexString innerName) {
        assert (innerClass != null);
        if (outerClass == null || innerName == null) {
            return String.valueOf('$');
        }
        return DescriptorUtils.computeInnerClassSeparator(outerClass.getInternalName(), innerClass.getInternalName(), innerName.toString());
    }

    public static String computeInnerClassSeparator(String outerDescriptor, String innerDescriptor, String innerName) {
        assert (innerName != null && !innerName.isEmpty());
        if (outerDescriptor.length() + innerName.length() > innerDescriptor.length()) {
            return null;
        }
        String separator = innerDescriptor.substring(outerDescriptor.length(), innerDescriptor.length() - innerName.length());
        if (!separator.startsWith(String.valueOf('$'))) {
            return null;
        }
        return separator;
    }

    public static boolean isClassDescriptor(String descriptor) {
        char ch;
        char[] buffer = descriptor.toCharArray();
        int length = buffer.length;
        if (length < 3 || buffer[0] != 'L') {
            return false;
        }
        int pos = 1;
        do {
            if (pos >= length) {
                return false;
            }
            if (DescriptorUtils.isInvalidChar(ch = buffer[pos++]) || ch == '/' || ch == ';') {
                return false;
            }
            do {
                if (pos >= length) {
                    return false;
                }
                if (!DescriptorUtils.isInvalidChar(ch = buffer[pos++])) continue;
                return false;
            } while (ch != '/' && ch != ';');
        } while (ch != ';');
        return pos == length;
    }

    public static String getPackageNameFromBinaryName(String classBinaryName) {
        int nameIndex = classBinaryName.lastIndexOf(47);
        return nameIndex < 0 ? "" : classBinaryName.substring(0, nameIndex).replace('/', '.');
    }

    private static boolean isInvalidChar(char ch) {
        switch (ch) {
            case '.': 
            case '[': {
                return true;
            }
        }
        return false;
    }

    public static String guessTypeDescriptor(Path name) {
        String fileName = name.toString();
        if (File.separatorChar != '/') {
            fileName = fileName.replace(File.separatorChar, '/');
        }
        return DescriptorUtils.guessTypeDescriptor(fileName);
    }

    public static String guessTypeDescriptor(String name) {
        assert (name != null);
        assert (name.endsWith(".class")) : "Name " + name + " must have " + ".class" + " suffix";
        String descriptor = name.substring(0, name.length() - ".class".length());
        if (descriptor.indexOf(46) != -1) {
            throw new CompilationError("Unexpected class file name: " + name);
        }
        return 'L' + descriptor + ';';
    }

    public static boolean isValidBinaryName(String binaryName) {
        return DescriptorUtils.isValidJavaType(binaryName.replace('/', '.'));
    }

    public static String getInnerClassName(String outerDescriptor, String innerDescriptor) {
        if (innerDescriptor.length() <= outerDescriptor.length()) {
            return null;
        }
        String prefix = outerDescriptor.substring(0, outerDescriptor.length() - 1) + '$';
        if (innerDescriptor.startsWith(prefix)) {
            return innerDescriptor.substring(prefix.length(), innerDescriptor.length() - 1);
        }
        return null;
    }

    public static ModuleAndDescriptor guessJrtModuleAndTypeDescriptor(String name) {
        assert (name != null);
        assert (name.endsWith(".class")) : "Name " + name + " must have " + ".class" + " suffix";
        assert (name.startsWith("/modules")) : "Name " + name + " must have " + "/modules" + " prefix";
        assert (name.charAt("/modules".length()) == '/');
        int moduleNameEnd = name.indexOf(47, "/modules".length() + 1);
        String module = name.substring("/modules".length() + 1, moduleNameEnd);
        String descriptor = name.substring(moduleNameEnd + 1, name.length() - ".class".length());
        if (descriptor.indexOf(46) != -1) {
            throw new CompilationError("Unexpected class file name: " + name);
        }
        return new ModuleAndDescriptor(module, 'L' + descriptor + ';');
    }

    public static String getPathFromDescriptor(String descriptor) {
        assert (descriptor.startsWith("L"));
        assert (descriptor.endsWith(";"));
        return descriptor.substring(1, descriptor.length() - 1) + ".class";
    }

    public static String getPathFromJavaType(Class<?> clazz) {
        return DescriptorUtils.getPathFromJavaType(clazz.getTypeName());
    }

    public static String getPathFromJavaType(String typeName) {
        assert (DescriptorUtils.isValidJavaType(typeName));
        return typeName.replace('.', '/') + ".class";
    }

    public static String getClassFileName(String classDescriptor) {
        assert (classDescriptor != null && DescriptorUtils.isClassDescriptor(classDescriptor));
        return DescriptorUtils.getClassBinaryNameFromDescriptor(classDescriptor) + ".class";
    }

    public static String getReturnTypeDescriptor(String methodDescriptor) {
        assert (methodDescriptor.indexOf(41) != -1);
        return methodDescriptor.substring(methodDescriptor.indexOf(41) + 1);
    }

    public static String getShortyDescriptor(String descriptor) {
        if (descriptor.length() == 1) {
            return descriptor;
        }
        assert (descriptor.charAt(0) == 'L' || descriptor.charAt(0) == '[');
        return "L";
    }

    public static String[] getArgumentTypeDescriptors(String methodDescriptor) {
        char c;
        String[] argDescriptors = new String[DescriptorUtils.getArgumentCount(methodDescriptor)];
        int charIdx = 1;
        int argIdx = 0;
        while ((c = methodDescriptor.charAt(charIdx)) != ')') {
            switch (c) {
                case 'V': {
                    throw new InvalidDescriptorException(methodDescriptor);
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    argDescriptors[argIdx++] = Character.toString(c);
                    break;
                }
                case '[': {
                    int startType = charIdx;
                    while (methodDescriptor.charAt(++charIdx) == '[') {
                    }
                    if (methodDescriptor.charAt(charIdx) == 'L') {
                        while (methodDescriptor.charAt(++charIdx) != ';') {
                        }
                    }
                    argDescriptors[argIdx++] = methodDescriptor.substring(startType, charIdx + 1);
                    break;
                }
                case 'L': {
                    int startType = charIdx;
                    while (methodDescriptor.charAt(++charIdx) != ';') {
                    }
                    argDescriptors[argIdx++] = methodDescriptor.substring(startType, charIdx + 1);
                    break;
                }
                default: {
                    throw new InvalidDescriptorException(methodDescriptor);
                }
            }
            ++charIdx;
        }
        return argDescriptors;
    }

    public static int getArgumentCount(String methodDescriptor) {
        char c;
        int length = methodDescriptor.length();
        int charIdx = 1;
        int argCount = 0;
        while (charIdx < length && (c = methodDescriptor.charAt(charIdx++)) != ')') {
            if (c == 'L') {
                while (charIdx < length && methodDescriptor.charAt(charIdx++) != ';') {
                }
                if (charIdx >= length || methodDescriptor.charAt(charIdx - 1) != ';') {
                    throw new InvalidDescriptorException(methodDescriptor);
                }
                ++argCount;
                continue;
            }
            if (c == '[') continue;
            ++argCount;
        }
        if (charIdx >= length || methodDescriptor.charAt(charIdx - 1) != ')') {
            throw new InvalidDescriptorException(methodDescriptor);
        }
        return argCount;
    }

    public static class ModuleAndDescriptor {
        private final String module;
        private final String descriptor;

        ModuleAndDescriptor(String module, String descriptor) {
            this.module = module;
            this.descriptor = descriptor;
        }

        public String getModule() {
            return this.module;
        }

        public String getDescriptor() {
            return this.descriptor;
        }
    }
}

