/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassDefinition;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Comparator;

public class DeterminismChecker {
    private final LineCallbackSupplier callbackFactory;

    public static DeterminismChecker createWithFileBacking(final Path directory) {
        return new DeterminismChecker(new LineCallbackSupplier(){
            private int index = 0;

            @Override
            public LineCallback createCallback() throws IOException {
                Path log = directory.resolve("" + this.index++ + ".log");
                if (Files.exists(log, new LinkOption[0])) {
                    System.out.println("Checking against determinism log: " + log);
                    return new LineCallbackChecker(Files.newBufferedReader(log, StandardCharsets.UTF_8));
                }
                System.out.println("Writing determinism log: " + log);
                BufferedWriter bufferedWriter = Files.newBufferedWriter(log, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                return new LineCallbackWriter(bufferedWriter);
            }
        });
    }

    private DeterminismChecker(LineCallbackSupplier callbackFactory) {
        this.callbackFactory = callbackFactory;
    }

    private static String fmtClass(DexProgramClass clazz) {
        return clazz.getType().toSourceString() + " " + clazz.getMethodCollection().getBackingDescriptionString();
    }

    private static String fmtMethod(DexEncodedMethod method) {
        return ((DexMethod)method.getReference()).toSourceString();
    }

    private void checkClass(LineCallback callback, DexProgramClass clazz) throws IOException {
        String line = DeterminismChecker.fmtClass(clazz);
        if (!callback.onLine(line)) {
            return;
        }
        for (DexEncodedMethod method : clazz.methods()) {
            this.checkMethod(callback, method);
        }
    }

    private void checkMethod(LineCallback callback, DexEncodedMethod method) throws IOException {
        String header = DeterminismChecker.fmtMethod(method);
        if (!callback.onLine(header)) {
            return;
        }
        if (method.hasCode()) {
            String[] lines;
            for (String line : lines = method.getCode().toString().split("\n")) {
                if (callback.onLine(line)) continue;
                return;
            }
        } else if (!callback.onLine("<nocode>")) {
            return;
        }
    }

    private static String escape(String line) {
        return line.replace("\r", "<CR>");
    }

    public void check(AppView<?> appView) {
        block14: {
            try {
                LineCallback callback;
                block15: {
                    callback = this.callbackFactory.createCallback();
                    Throwable throwable = null;
                    try {
                        ArrayList<DexProgramClass> classes = new ArrayList<DexProgramClass>(((AppInfo)appView.appInfo()).classes());
                        classes.sort(Comparator.comparing(ClassDefinition::getType));
                        for (int i = 0; i < classes.size(); ++i) {
                            DexProgramClass clazz = (DexProgramClass)classes.get(i);
                            this.checkClass(callback, clazz);
                        }
                        if (callback == null) break block14;
                        if (throwable == null) break block15;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (callback != null) {
                                if (throwable != null) {
                                    try {
                                        callback.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    callback.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    try {
                        callback.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    break block14;
                }
                callback.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class LineCallbackWriter
    implements LineCallback {
        private final Writer writer;

        public LineCallbackWriter(Writer writer) {
            this.writer = writer;
        }

        @Override
        public boolean onLine(String line) throws IOException {
            this.writer.write(DeterminismChecker.escape(line));
            this.writer.write(10);
            return true;
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class LineCallbackChecker
    implements LineCallback {
        private final BufferedReader reader;

        public LineCallbackChecker(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public boolean onLine(String unescapedLine) throws IOException {
            String line = DeterminismChecker.escape(unescapedLine);
            String dumpLine = this.reader.readLine();
            boolean equals = dumpLine.equals(line);
            if (!equals) {
                throw new AssertionError((Object)("\nMismatch for line: " + line + "\n    and dump-line: " + dumpLine));
            }
            return equals;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    public static interface LineCallback
    extends Closeable {
        public boolean onLine(String var1) throws IOException;
    }

    public static interface LineCallbackSupplier {
        public LineCallback createCallback() throws IOException;
    }
}

