/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.utils.ClassReferenceUtils;
import com.android.tools.r8.utils.CompareResult;
import com.android.tools.r8.utils.TypeReferenceUtils;
import java.util.Comparator;

public class FieldReferenceUtils {
    private static final Comparator<FieldReference> COMPARATOR = (field, other) -> {
        CompareResult holderClassCompareResult = CompareResult.compare(field.getHolderClass(), other.getHolderClass(), ClassReferenceUtils.getClassReferenceComparator());
        if (!holderClassCompareResult.isEqual()) {
            return holderClassCompareResult.getComparisonResult();
        }
        CompareResult fieldNameCompareResult = CompareResult.compare(field.getFieldName(), other.getFieldName());
        if (!fieldNameCompareResult.isEqual()) {
            return fieldNameCompareResult.getComparisonResult();
        }
        return TypeReferenceUtils.getTypeReferenceComparator().compare(field.getFieldType(), other.getFieldType());
    };

    public static int compare(FieldReference fieldReference, ClassReference other) {
        return ClassReferenceUtils.compare(other, fieldReference) * -1;
    }

    public static int compare(FieldReference fieldReference, FieldReference other) {
        return FieldReferenceUtils.getFieldReferenceComparator().compare(fieldReference, other);
    }

    public static int compare(FieldReference fieldReference, MethodReference other) {
        int comparisonResult = ClassReferenceUtils.compare(fieldReference.getHolderClass(), other.getHolderClass());
        return comparisonResult != 0 ? comparisonResult : -1;
    }

    public static FieldReference fieldFromField(Class<?> clazz, String name) {
        try {
            return Reference.fieldFromField(clazz.getDeclaredField(name));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static Comparator<FieldReference> getFieldReferenceComparator() {
        return COMPARATOR;
    }

    public static String toSourceString(FieldReference fieldReference) {
        return fieldReference.getFieldType().getTypeName() + " " + fieldReference.getHolderClass().getTypeName() + "." + fieldReference.getFieldName();
    }
}

