/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import javax.management.MBeanServer;

public class HeapUtils {
    private static final String HOTSPOT_MBEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initHotSpotMBean() throws IOException {
        if (hotSpotDiagnosticMXBean != null) return;
        Class<HeapUtils> clazz = HeapUtils.class;
        synchronized (HeapUtils.class) {
            if (hotSpotDiagnosticMXBean != null) return;
            hotSpotDiagnosticMXBean = HeapUtils.getHotSpotDiagnosticMXBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static HotSpotDiagnosticMXBean getHotSpotDiagnosticMXBean() throws IOException {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        return ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_MBEAN_NAME, HotSpotDiagnosticMXBean.class);
    }

    public static void dumpHeap(Path fileName, boolean live) throws IOException {
        HeapUtils.initHotSpotMBean();
        hotSpotDiagnosticMXBean.dumpHeap(fileName.toString(), live);
    }
}

