/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.ZipUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class InternalArchiveClassFileProvider
implements ClassFileResourceProvider,
AutoCloseable {
    private final Path path;
    private final Origin origin;
    private final Set<String> descriptors = new HashSet<String>();
    private ZipFile openedZipFile = null;

    public InternalArchiveClassFileProvider(Path archive) throws IOException {
        this(archive, entry -> true);
    }

    public InternalArchiveClassFileProvider(Path archive, Predicate<String> include) throws IOException {
        assert (FileUtils.isArchive(archive));
        this.path = archive;
        this.origin = new PathOrigin(archive);
        Enumeration<? extends ZipEntry> entries = this.getOpenZipFile().entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!ZipUtils.isClassFile(name) || !include.test(name)) continue;
            this.descriptors.add(DescriptorUtils.guessTypeDescriptor(name));
        }
    }

    private ZipFile getOpenZipFile() throws IOException {
        if (this.openedZipFile == null) {
            try {
                this.openedZipFile = FileUtils.createZipFile(this.path.toFile(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                if (!Files.exists(this.path, new LinkOption[0])) {
                    throw new NoSuchFileException(this.path.toString());
                }
                throw e;
            }
        }
        return this.openedZipFile;
    }

    private ZipEntry getZipEntryFromDescriptor(String descriptor) throws IOException {
        return this.getOpenZipFile().getEntry(descriptor.substring(1, descriptor.length() - 1) + ".class");
    }

    @Override
    public Set<String> getClassDescriptors() {
        return Collections.unmodifiableSet(this.descriptors);
    }

    @Override
    public ProgramResource getProgramResource(String descriptor) {
        ProgramResource programResource;
        block15: {
            InputStream inputStream;
            block16: {
                if (!this.descriptors.contains(descriptor)) {
                    return null;
                }
                ZipEntry zipEntry = this.getZipEntryFromDescriptor(descriptor);
                inputStream = this.getOpenZipFile().getInputStream(zipEntry);
                Throwable throwable = null;
                try {
                    programResource = ProgramResource.fromBytes(new ArchiveEntryOrigin(zipEntry.getName(), this.origin), ProgramResource.Kind.CF, ByteStreams.toByteArray(inputStream), Collections.singleton(descriptor));
                    if (inputStream == null) break block15;
                    if (throwable == null) break block16;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (inputStream != null) {
                                if (throwable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    inputStream.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    catch (IOException e) {
                        throw new CompilationError("Failed to read '" + descriptor, this.origin);
                    }
                }
                try {
                    inputStream.close();
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                break block15;
            }
            inputStream.close();
        }
        return programResource;
    }

    @Override
    public void close() throws IOException {
        this.openedZipFile.close();
        this.openedZipFile = null;
    }
}

