/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.utils.IntBox;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class IteratorUtils {
    public static <T> Iterator<T> createCircularIterator(final Iterable<T> iterable) {
        assert (!Iterables.isEmpty(iterable));
        return new Iterator<T>(){
            private Iterator<T> iterator;
            {
                this.iterator = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                if (!this.iterator.hasNext()) {
                    this.iterator = iterable.iterator();
                }
                return this.iterator.next();
            }
        };
    }

    public static <T> int countRemaining(Iterator<T> iterator2) {
        IntBox counter = new IntBox();
        iterator2.forEachRemaining(ignore -> counter.increment());
        return counter.get();
    }

    public static <T, S extends T> Iterator<S> filter(final Iterator<? extends T> iterator2, final Predicate<T> predicate) {
        return new Iterator<S>(){
            private S next = this.advance();

            private S advance() {
                while (iterator2.hasNext()) {
                    Object element = iterator2.next();
                    if (!predicate.test(element)) continue;
                    return element;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public S next() {
                Object current = this.next;
                if (current == null) {
                    throw new NoSuchElementException();
                }
                this.next = this.advance();
                return current;
            }
        };
    }

    public static <T> T nextUntil(Iterator<T> iterator2, Predicate<T> predicate) {
        while (iterator2.hasNext()) {
            T element = iterator2.next();
            if (!predicate.test(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> T peekPrevious(ListIterator<T> iterator2) {
        T previous = iterator2.previous();
        T next = iterator2.next();
        assert (previous == next);
        return previous;
    }

    public static <T> T peekNext(ListIterator<T> iterator2) {
        if (iterator2.hasNext()) {
            T next = iterator2.next();
            T previous = iterator2.previous();
            assert (previous == next);
            return next;
        }
        return null;
    }

    public static <T> T previousUntil(ListIterator<T> iterator2, Predicate<T> predicate) {
        while (iterator2.hasPrevious()) {
            T previous = iterator2.previous();
            if (!predicate.test(previous)) continue;
            return previous;
        }
        throw new Unreachable();
    }

    public static <T> T previousUntilUnsafe(ListIterator<T> iterator2, Predicate<T> predicate) {
        while (iterator2.hasPrevious()) {
            T previous = iterator2.previous();
            if (!predicate.test(previous)) continue;
            return previous;
        }
        return null;
    }

    public static <T> T removeFirst(Iterator<T> iterator2, Predicate<T> predicate) {
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            if (!predicate.test(item)) continue;
            iterator2.remove();
            return item;
        }
        return null;
    }

    public static <T> void removeIf(Iterator<T> iterator2, Predicate<T> predicate) {
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            if (!predicate.test(item)) continue;
            iterator2.remove();
        }
    }

    @Deprecated
    public static void removeIf(InstructionIterator iterator2, Predicate<Instruction> predicate) {
        throw new Unimplemented();
    }

    public static void removeIf(InstructionListIterator iterator2, Predicate<Instruction> predicate) {
        IteratorUtils.removeIf(iterator2, predicate);
    }

    public static void skip(InstructionIterator iterator2, int times) {
        for (int i = 0; i < times; ++i) {
            iterator2.next();
        }
    }

    public static <T> boolean allRemainingMatch(ListIterator<T> iterator2, Predicate<T> predicate) {
        return !IteratorUtils.anyRemainingMatch(iterator2, remaining -> !predicate.test(remaining));
    }

    public static <T> boolean allRemainingMatchDestructive(Iterator<T> iterator2, Predicate<T> predicate) {
        while (iterator2.hasNext()) {
            if (predicate.test(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean anyRemainingMatch(ListIterator<T> iterator2, Predicate<T> predicate) {
        T state = IteratorUtils.peekNext(iterator2);
        boolean result = false;
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            if (!predicate.test(item)) continue;
            result = true;
            break;
        }
        while (iterator2.hasPrevious() && iterator2.previous() != state) {
        }
        assert (IteratorUtils.peekNext(iterator2) == state);
        return result;
    }
}

