/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ResourceException;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfPosition;
import com.android.tools.r8.com.google.common.base.Suppliers;
import com.android.tools.r8.debuginfo.DebugRepresentation;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugEvent;
import com.android.tools.r8.graph.DexDebugEventBuilder;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexDebugInfoForSingleLineMethod;
import com.android.tools.r8.graph.DexDebugPositionState;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.kotlin.KotlinSourceDebugExtensionParser;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.naming.ClassNaming;
import com.android.tools.r8.naming.ClassNamingForNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.ProguardMapSupplier;
import com.android.tools.r8.naming.Range;
import com.android.tools.r8.naming.mappinginformation.CompilerSynthesizedMappingInformation;
import com.android.tools.r8.naming.mappinginformation.FileNameInformation;
import com.android.tools.r8.naming.mappinginformation.MappingInformation;
import com.android.tools.r8.naming.mappinginformation.OutlineCallsiteMappingInformation;
import com.android.tools.r8.naming.mappinginformation.OutlineMappingInformation;
import com.android.tools.r8.naming.mappinginformation.RewriteFrameMappingInformation;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.retrace.internal.RetraceUtils;
import com.android.tools.r8.shaking.KeepInfoCollection;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.BooleanBox;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.CfLineToMethodMapper;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.Int2StructuralItemArrayMap;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.OriginalSourceFiles;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class LineNumberOptimizer {
    private static final int MAX_LINE_NUMBER = 65535;

    public static ProguardMapSupplier.ProguardMapId runAndWriteMap(AndroidApp inputApp, AppView<?> appView, NamingLens namingLens, Timing timing, OriginalSourceFiles originalSourceFiles, DebugRepresentation.DebugRepresentationPredicate representation) {
        assert (appView.options().proguardMapConsumer != null);
        timing.begin("Line number remapping");
        ClassNameMapper mapper = LineNumberOptimizer.run(appView, ((AppInfo)appView.appInfo()).app(), inputApp, namingLens, originalSourceFiles, representation);
        timing.end();
        timing.begin("Write proguard map");
        ProguardMapSupplier.ProguardMapId mapId = ProguardMapSupplier.create(mapper, appView.options()).writeProguardMap();
        timing.end();
        return mapId;
    }

    public static ClassNameMapper run(AppView<?> appView, DexApplication application, AndroidApp inputApp, NamingLens namingLens, OriginalSourceFiles originalSourceFiles, DebugRepresentation.DebugRepresentationPredicate representation) {
        CfLineToMethodMapper cfLineToMethodMapper = new CfLineToMethodMapper(inputApp);
        ClassNameMapper.Builder classNameMapperBuilder = ClassNameMapper.builder();
        IdentityHashMap<DexMethod, OutlineFixupBuilder> outlinesToFix = new IdentityHashMap<DexMethod, OutlineFixupBuilder>();
        PcBasedDebugInfoRecorder pcBasedDebugInfo = appView.options().canUseNativeDexPcInsteadOfDebugInfo() ? new NativePcSupport() : new Pc2PcMappingSupport(appView.options().allowDiscardingResidualDebugInfo());
        for (DexProgramClass clazz : application.classes()) {
            boolean isSyntheticClass = appView.getSyntheticItems().isSyntheticClass(clazz);
            IdentityHashMap<DexString, List<ProgramMethod>> methodsByRenamedName = LineNumberOptimizer.groupMethodsByRenamedName(appView.graphLens(), namingLens, clazz);
            DexType originalType = appView.graphLens().getOriginalType(clazz.type);
            DexString renamedDescriptor = namingLens.lookupDescriptor(clazz.getType());
            com.android.tools.r8.com.google.common.base.Supplier<ClassNaming.Builder> onDemandClassNamingBuilder = Suppliers.memoize(() -> classNameMapperBuilder.classNamingBuilder(DescriptorUtils.descriptorToJavaType(renamedDescriptor.toString()), originalType.toSourceString(), com.android.tools.r8.position.Position.UNKNOWN));
            DexString originalSourceFile = originalSourceFiles.getOriginalSourceFile(clazz);
            if (originalSourceFile != null) {
                String sourceFile = originalSourceFile.toString();
                if (!RetraceUtils.hasPredictableSourceFileName(clazz.toSourceString(), sourceFile)) {
                    ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMappingInformation(FileNameInformation.build(sourceFile), xva$0 -> Unreachable.raise(xva$0));
                }
            }
            if (isSyntheticClass) {
                ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMappingInformation(CompilerSynthesizedMappingInformation.builder().build(), xva$0 -> Unreachable.raise(xva$0));
            }
            LineNumberOptimizer.addClassToClassNaming(originalType, renamedDescriptor, onDemandClassNamingBuilder);
            LineNumberOptimizer.addFieldsToClassNaming(appView.graphLens(), namingLens, clazz, originalType, onDemandClassNamingBuilder);
            ArrayList<DexString> renamedMethodNames = new ArrayList<DexString>(methodsByRenamedName.keySet());
            renamedMethodNames.sort(DexString::compareTo);
            for (DexString methodName : renamedMethodNames) {
                List<ProgramMethod> methods = methodsByRenamedName.get(methodName);
                if (methods.size() > 1) {
                    LineNumberOptimizer.sortMethods(methods);
                    assert (LineNumberOptimizer.verifyMethodsAreKeptDirectlyOrIndirectly(appView, methods));
                }
                boolean identityMapping = appView.options().lineNumberOptimization == InternalOptions.LineNumberOptimization.OFF;
                PositionRemapper positionRemapper = identityMapping ? new IdentityPositionRemapper() : new OptimizingPositionRemapper(appView.options());
                KotlinInlineFunctionPositionRemapper kotlinRemapper = new KotlinInlineFunctionPositionRemapper(appView, positionRemapper, cfLineToMethodMapper);
                for (ProgramMethod method : methods) {
                    boolean canUseDexPc;
                    DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
                    kotlinRemapper.currentMethod = definition;
                    Code code = definition.getCode();
                    boolean bl = canUseDexPc = methods.size() == 1 && representation.useDexPcEncoding(clazz, definition);
                    List<Object> mappedPositions = code != null ? (code.isDexCode() && LineNumberOptimizer.doesContainPositions(code.asDexCode()) ? (canUseDexPc ? LineNumberOptimizer.optimizeDexCodePositionsForPc(definition, appView, kotlinRemapper, pcBasedDebugInfo) : LineNumberOptimizer.optimizeDexCodePositions(definition, appView, kotlinRemapper, identityMapping, methods.size() != 1)) : (code.isCfCode() && LineNumberOptimizer.doesContainPositions(code.asCfCode()) && !appView.isCfByteCodePassThrough(definition) ? LineNumberOptimizer.optimizeCfCodePositions(method, kotlinRemapper, appView) : new ArrayList())) : new ArrayList();
                    DexMethod originalMethod = appView.graphLens().getOriginalMethodSignature((DexMethod)method.getReference());
                    MemberNaming.MethodSignature originalSignature = MemberNaming.MethodSignature.fromDexMethod(originalMethod, originalMethod.holder != originalType);
                    DexString obfuscatedNameDexString = namingLens.lookupName((DexMethod)method.getReference());
                    String obfuscatedName = obfuscatedNameDexString.toString();
                    ArrayList<MappingInformation> methodMappingInfo = new ArrayList<MappingInformation>();
                    if (definition.isD8R8Synthesized()) {
                        methodMappingInfo.add(CompilerSynthesizedMappingInformation.builder().build());
                    }
                    if (mappedPositions.isEmpty() && methodMappingInfo.isEmpty() && obfuscatedNameDexString == originalMethod.name && originalMethod.holder == originalType) {
                        assert (appView.options().lineNumberOptimization == InternalOptions.LineNumberOptimization.OFF || !LineNumberOptimizer.doesContainPositions(definition) || appView.isCfByteCodePassThrough(definition));
                        continue;
                    }
                    MemberNaming memberNaming = new MemberNaming(originalSignature, obfuscatedName);
                    ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMemberEntry(memberNaming);
                    if (mappedPositions.isEmpty()) {
                        ClassNamingForNameMapper.MappedRange range = ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMappedRange(null, originalSignature, null, obfuscatedName);
                        methodMappingInfo.forEach(info -> range.addMappingInformation((MappingInformation)info, xva$0 -> Unreachable.raise(xva$0)));
                        continue;
                    }
                    IdentityHashMap<DexMethod, MemberNaming.MethodSignature> signatures = new IdentityHashMap<DexMethod, MemberNaming.MethodSignature>();
                    signatures.put(originalMethod, originalSignature);
                    Function<DexMethod, MemberNaming.MethodSignature> getOriginalMethodSignature = m3 -> signatures.computeIfAbsent((DexMethod)m3, key -> MemberNaming.MethodSignature.fromDexMethod(m3, m3.holder != clazz.getType()));
                    DexMethod outlineMethod = LineNumberOptimizer.getOutlineMethod((MappedPosition)mappedPositions.get(0));
                    if (outlineMethod != null) {
                        outlinesToFix.computeIfAbsent(outlineMethod, ignored -> new OutlineFixupBuilder()).setMappedPositionsOutline(mappedPositions);
                        methodMappingInfo.add(OutlineMappingInformation.builder().build());
                    }
                    int i = 0;
                    while (i < mappedPositions.size()) {
                        Range obfuscatedRange;
                        int j;
                        MappedPosition firstPosition = (MappedPosition)mappedPositions.get(i);
                        MappedPosition lastPosition = firstPosition;
                        for (j = i + 1; j < mappedPositions.size(); ++j) {
                            boolean isMappingRangeToSingleLine;
                            MappedPosition currentPosition = (MappedPosition)mappedPositions.get(j);
                            boolean isSingleLine = currentPosition.originalLine == firstPosition.originalLine;
                            boolean differentDelta = currentPosition.originalLine - lastPosition.originalLine != currentPosition.obfuscatedLine - lastPosition.obfuscatedLine;
                            boolean bl2 = isMappingRangeToSingleLine = firstPosition.obfuscatedLine != lastPosition.obfuscatedLine && firstPosition.originalLine == lastPosition.originalLine;
                            if (currentPosition.method != lastPosition.method || !isSingleLine && differentDelta || !isSingleLine && isMappingRangeToSingleLine || !Objects.equals(currentPosition.caller, lastPosition.caller) || currentPosition.outlineCallee != null || firstPosition.outlineCallee != null) break;
                            if (firstPosition.obfuscatedLine > currentPosition.obfuscatedLine) {
                                firstPosition = currentPosition;
                            }
                            if (lastPosition.obfuscatedLine >= currentPosition.obfuscatedLine) continue;
                            lastPosition = currentPosition;
                        }
                        if (definition.getCode().isDexCode() && definition.getCode().asDexCode().getDebugInfo() == DexDebugInfoForSingleLineMethod.getInstance()) {
                            assert (firstPosition.originalLine == lastPosition.originalLine);
                            obfuscatedRange = new Range(0, 65535);
                        } else {
                            obfuscatedRange = new Range(firstPosition.obfuscatedLine, lastPosition.obfuscatedLine);
                        }
                        ClassNaming.Builder classNamingBuilder = (ClassNaming.Builder)onDemandClassNamingBuilder.get();
                        ClassNamingForNameMapper.MappedRange lastMappedRange = LineNumberOptimizer.getMappedRangesForPosition(appView.options().dexItemFactory(), getOriginalMethodSignature, classNamingBuilder, firstPosition.method, obfuscatedName, obfuscatedRange, new Range(firstPosition.originalLine, lastPosition.originalLine), firstPosition.caller);
                        for (MappingInformation info2 : methodMappingInfo) {
                            lastMappedRange.addMappingInformation(info2, xva$0 -> Unreachable.raise(xva$0));
                        }
                        if (firstPosition.outlineCallee != null) {
                            Int2IntArrayMap positionMap = new Int2IntArrayMap();
                            int maxPc = ((MappedPosition)ListUtils.last(mappedPositions)).obfuscatedLine;
                            firstPosition.outlinePositions.forEach((line, position) -> {
                                int placeHolderLineToBeFixed = canUseDexPc ? maxPc + line + 1 : positionRemapper.createRemappedPosition((Position)position).getSecond().getLine();
                                positionMap.put((int)line, placeHolderLineToBeFixed);
                                LineNumberOptimizer.getMappedRangesForPosition(appView.options().dexItemFactory(), getOriginalMethodSignature, classNamingBuilder, position.getMethod(), obfuscatedName, new Range(placeHolderLineToBeFixed, placeHolderLineToBeFixed), new Range(position.getLine(), position.getLine()), position.getCallerPosition());
                            });
                            outlinesToFix.computeIfAbsent(firstPosition.outlineCallee, ignored -> new OutlineFixupBuilder()).addMappedRangeForOutlineCallee(lastMappedRange, positionMap);
                        }
                        i = j;
                    }
                    if (!definition.getCode().isDexCode() || definition.getCode().asDexCode().getDebugInfo() != DexDebugInfoForSingleLineMethod.getInstance()) continue;
                    pcBasedDebugInfo.recordSingleLineFor(definition.getCode().asDexCode(), method.getParameters().size());
                }
            }
        }
        outlinesToFix.values().forEach(OutlineFixupBuilder::fixup);
        pcBasedDebugInfo.updateDebugInfoInCodeObjects();
        return classNameMapperBuilder.build();
    }

    private static DexMethod getOutlineMethod(MappedPosition mappedPosition) {
        if (mappedPosition.isOutline) {
            return mappedPosition.method;
        }
        if (mappedPosition.caller == null) {
            return null;
        }
        Position outermostCaller = mappedPosition.caller.getOutermostCaller();
        return outermostCaller.isOutline() ? outermostCaller.getMethod() : null;
    }

    private static ClassNamingForNameMapper.MappedRange getMappedRangesForPosition(DexItemFactory factory, Function<DexMethod, MemberNaming.MethodSignature> getOriginalMethodSignature, ClassNaming.Builder classNamingBuilder, DexMethod method, String obfuscatedName, Range obfuscatedRange, Range originalLine, Position caller) {
        ClassNamingForNameMapper.MappedRange lastMappedRange = classNamingBuilder.addMappedRange(obfuscatedRange, getOriginalMethodSignature.apply(method), originalLine, obfuscatedName);
        int inlineFramesCount = 0;
        while (caller != null) {
            ++inlineFramesCount;
            lastMappedRange = classNamingBuilder.addMappedRange(obfuscatedRange, getOriginalMethodSignature.apply(caller.getMethod()), new Range(Math.max(caller.getLine(), 0)), obfuscatedName);
            if (caller.isRemoveInnerFramesIfThrowingNpe()) {
                lastMappedRange.addMappingInformation(RewriteFrameMappingInformation.builder().addCondition(RewriteFrameMappingInformation.ThrowsCondition.create(Reference.classFromDescriptor(factory.npeDescriptor.toString()))).addRewriteAction(RewriteFrameMappingInformation.RemoveInnerFramesAction.create(inlineFramesCount)).build(), xva$0 -> Unreachable.raise(xva$0));
            }
            caller = caller.getCallerPosition();
        }
        return lastMappedRange;
    }

    private static boolean verifyMethodsAreKeptDirectlyOrIndirectly(AppView<?> appView, List<ProgramMethod> methods) {
        if (appView.options().isGeneratingClassFiles() || !((AppInfo)appView.appInfo()).hasClassHierarchy()) {
            return true;
        }
        AppInfoWithClassHierarchy appInfo = ((AppInfo)appView.appInfo()).withClassHierarchy();
        KeepInfoCollection keepInfo = appView.getKeepInfo();
        boolean allSeenAreInstanceInitializers = true;
        DexString originalName = null;
        for (ProgramMethod method : methods) {
            DexProgramClass clazz;
            DexClassAndMethod lookupResult;
            if (((DexEncodedMethod)method.getDefinition()).isInstanceInitializer()) {
                assert (allSeenAreInstanceInitializers);
                continue;
            }
            allSeenAreInstanceInitializers = false;
            if (!keepInfo.isMinificationAllowed(method.getReference(), appView, appView.options()) || ((DexEncodedMethod)method.getDefinition()).isLibraryMethodOverride().isTrue() || (lookupResult = appInfo.lookupMaximallySpecificMethod(clazz = appView.definitionForProgramType(method.getHolderType()), (DexMethod)method.getReference())) == null) continue;
            String errorString = ((DexMethod)method.getReference()).qualifiedName() + " is not kept but is overloaded";
            assert (lookupResult.getHolder().isInterface()) : errorString;
            originalName = ((DexMethod)method.getReference()).name;
        }
        return true;
    }

    private static int getMethodStartLine(ProgramMethod method) {
        Code code = ((DexEncodedMethod)method.getDefinition()).getCode();
        if (code == null) {
            return 0;
        }
        if (code.isDexCode()) {
            DexDebugInfo dexDebugInfo = code.asDexCode().getDebugInfo();
            return dexDebugInfo == null ? 0 : dexDebugInfo.getStartLine();
        }
        if (code.isCfCode()) {
            List<CfInstruction> instructions = code.asCfCode().getInstructions();
            for (CfInstruction instruction : instructions) {
                if (!(instruction instanceof CfPosition)) continue;
                return ((CfPosition)instruction).getPosition().getLine();
            }
        }
        return 0;
    }

    private static void sortMethods(List<ProgramMethod> methods) {
        methods.sort((lhs, rhs) -> {
            int rhsStartLine;
            int lhsStartLine = LineNumberOptimizer.getMethodStartLine(lhs);
            int startLineDiff = lhsStartLine - (rhsStartLine = LineNumberOptimizer.getMethodStartLine(rhs));
            if (startLineDiff != 0) {
                return startLineDiff;
            }
            return DexEncodedMethod.slowCompare((DexEncodedMethod)lhs.getDefinition(), (DexEncodedMethod)rhs.getDefinition());
        });
    }

    private static void addClassToClassNaming(DexType originalType, DexString renamedClassName, Supplier<ClassNaming.Builder> onDemandClassNamingBuilder) {
        if (originalType.descriptor != renamedClassName) {
            onDemandClassNamingBuilder.get();
        }
    }

    private static void addFieldsToClassNaming(GraphLens graphLens, NamingLens namingLens, DexProgramClass clazz, DexType originalType, Supplier<ClassNaming.Builder> onDemandClassNamingBuilder) {
        clazz.forEachField(dexEncodedField -> {
            DexField dexField = (DexField)dexEncodedField.getReference();
            DexField originalField = graphLens.getOriginalFieldSignature(dexField);
            DexString renamedName = namingLens.lookupName(dexField);
            if (renamedName != originalField.name || originalField.holder != originalType) {
                MemberNaming.FieldSignature originalSignature = MemberNaming.FieldSignature.fromDexField(originalField, originalField.holder != originalType);
                MemberNaming memberNaming = new MemberNaming(originalSignature, renamedName.toString());
                ((ClassNaming.Builder)onDemandClassNamingBuilder.get()).addMemberEntry(memberNaming);
            }
        });
    }

    public static IdentityHashMap<DexString, List<ProgramMethod>> groupMethodsByRenamedName(GraphLens graphLens, NamingLens namingLens, DexProgramClass clazz) {
        IdentityHashMap<DexString, List<ProgramMethod>> methodsByRenamedName = new IdentityHashMap<DexString, List<ProgramMethod>>(clazz.getMethodCollection().size());
        for (ProgramMethod programMethod : clazz.programMethods()) {
            DexEncodedMethod definition = (DexEncodedMethod)programMethod.getDefinition();
            DexMethod method = (DexMethod)programMethod.getReference();
            DexString renamedName = namingLens.lookupName(method);
            if (renamedName == method.name && graphLens.getOriginalMethodSignature(method) == method && !LineNumberOptimizer.doesContainPositions(definition) && !definition.isD8R8Synthesized()) continue;
            methodsByRenamedName.computeIfAbsent(renamedName, key -> new ArrayList()).add(programMethod);
        }
        return methodsByRenamedName;
    }

    private static boolean doesContainPositions(DexEncodedMethod method) {
        Code code = method.getCode();
        if (code == null) {
            return false;
        }
        if (code.isDexCode()) {
            return LineNumberOptimizer.doesContainPositions(code.asDexCode());
        }
        if (code.isCfCode()) {
            return LineNumberOptimizer.doesContainPositions(code.asCfCode());
        }
        return false;
    }

    public static boolean doesContainPositions(DexCode dexCode) {
        DexDebugInfo debugInfo = dexCode.getDebugInfo();
        if (debugInfo == null) {
            return false;
        }
        if (debugInfo.isPcBasedInfo()) {
            return true;
        }
        for (DexDebugEvent event : debugInfo.asEventBasedInfo().events) {
            if (!(event instanceof DexDebugEvent.Default)) continue;
            return true;
        }
        return false;
    }

    private static boolean doesContainPositions(CfCode cfCode) {
        List<CfInstruction> instructions = cfCode.getInstructions();
        for (CfInstruction instruction : instructions) {
            if (!(instruction instanceof CfPosition)) continue;
            return true;
        }
        return false;
    }

    private static List<MappedPosition> optimizeDexCodePositions(DexEncodedMethod method, AppView<?> appView, final PositionRemapper positionRemapper, boolean identityMapping, boolean hasOverloads) {
        final ArrayList<MappedPosition> mappedPositions = new ArrayList<MappedPosition>();
        DexApplication application = ((AppInfo)appView.appInfo()).app();
        DexCode dexCode = method.getCode().asDexCode();
        DexDebugInfo.EventBasedDebugInfo debugInfo = DexDebugInfo.convertToEventBased(dexCode, appView.dexItemFactory());
        assert (debugInfo != null);
        final ArrayList processedEvents = new ArrayList();
        final PositionEventEmitter positionEventEmitter = new PositionEventEmitter(application.dexItemFactory, appView.graphLens().getOriginalMethodSignature((DexMethod)method.getReference()), processedEvents);
        final Box<Boolean> inlinedOriginalPosition = new Box<Boolean>(false);
        DexDebugPositionState visitor = new DexDebugPositionState(debugInfo.startLine, appView.graphLens().getOriginalMethodSignature((DexMethod)method.getReference())){
            private int emittedPc;
            {
                super(startLine, method);
                this.emittedPc = 0;
            }

            private void flushPc() {
                if (this.emittedPc != this.getCurrentPc()) {
                    positionEventEmitter.emitAdvancePc(this.getCurrentPc());
                    this.emittedPc = this.getCurrentPc();
                }
            }

            @Override
            public void visit(DexDebugEvent.Default defaultEvent) {
                super.visit(defaultEvent);
                assert (this.getCurrentLine() >= 0);
                Position position = LineNumberOptimizer.getPositionFromPositionState(this);
                Position currentPosition = LineNumberOptimizer.remapAndAdd(position, positionRemapper, mappedPositions);
                positionEventEmitter.emitPositionEvents(this.getCurrentPc(), currentPosition);
                if (currentPosition != position) {
                    inlinedOriginalPosition.set(true);
                }
                this.emittedPc = this.getCurrentPc();
                this.resetOutlineInformation();
            }

            @Override
            public void visit(DexDebugEvent.SetFile setFile) {
                processedEvents.add(setFile);
            }

            @Override
            public void visit(DexDebugEvent.SetPrologueEnd setPrologueEnd) {
                processedEvents.add(setPrologueEnd);
            }

            @Override
            public void visit(DexDebugEvent.SetEpilogueBegin setEpilogueBegin) {
                processedEvents.add(setEpilogueBegin);
            }

            @Override
            public void visit(DexDebugEvent.StartLocal startLocal) {
                this.flushPc();
                processedEvents.add(startLocal);
            }

            @Override
            public void visit(DexDebugEvent.EndLocal endLocal) {
                this.flushPc();
                processedEvents.add(endLocal);
            }

            @Override
            public void visit(DexDebugEvent.RestartLocal restartLocal) {
                this.flushPc();
                processedEvents.add(restartLocal);
            }
        };
        for (DexDebugEvent event : debugInfo.events) {
            event.accept(visitor);
        }
        if (!(mappedPositions.size() > 1 || hasOverloads || appView.options().debug || appView.options().lineNumberOptimization == InternalOptions.LineNumberOptimization.OFF || !appView.options().allowDiscardingResidualDebugInfo() || !mappedPositions.isEmpty() && ((MappedPosition)mappedPositions.get(0)).isOutlineCaller())) {
            dexCode.setDebugInfo(DexDebugInfoForSingleLineMethod.getInstance());
            return mappedPositions;
        }
        DexDebugInfo.EventBasedDebugInfo optimizedDebugInfo = new DexDebugInfo.EventBasedDebugInfo(positionEventEmitter.getStartLine(), debugInfo.parameters, processedEvents.toArray(DexDebugEvent.EMPTY_ARRAY));
        assert (!identityMapping || inlinedOriginalPosition.get().booleanValue() || LineNumberOptimizer.verifyIdentityMapping(debugInfo, optimizedDebugInfo));
        dexCode.setDebugInfo(optimizedDebugInfo);
        return mappedPositions;
    }

    private static Position getPositionFromPositionState(DexDebugPositionState state) {
        Position.PositionBuilder positionBuilder;
        if (state.getOutlineCallee() != null) {
            Position.OutlineCallerPosition.OutlineCallerPositionBuilder outlineCallerPositionBuilder = Position.OutlineCallerPosition.builder().setOutlineCallee(state.getOutlineCallee()).setIsOutline(state.isOutline());
            state.getOutlineCallerPositions().forEach(outlineCallerPositionBuilder::addOutlinePosition);
            positionBuilder = outlineCallerPositionBuilder;
        } else {
            positionBuilder = state.isOutline() ? Position.OutlinePosition.builder() : Position.SourcePosition.builder();
        }
        return ((Position.PositionBuilder)((Position.PositionBuilder)((Position.PositionBuilder)positionBuilder.setLine(state.getCurrentLine())).setMethod(state.getCurrentMethod())).setCallerPosition(state.getCurrentCallerPosition())).build();
    }

    private static List<MappedPosition> optimizeDexCodePositionsForPc(DexEncodedMethod method, AppView<?> appView, final PositionRemapper positionRemapper, PcBasedDebugInfoRecorder debugInfoProvider) {
        final ArrayList<MappedPosition> mappedPositions = new ArrayList<MappedPosition>();
        DexCode dexCode = method.getCode().asDexCode();
        DexDebugInfo.EventBasedDebugInfo debugInfo = DexDebugInfo.convertToEventBased(dexCode, appView.dexItemFactory());
        assert (debugInfo != null);
        final BooleanBox singleOriginalLine = new BooleanBox(true);
        final Pair lastPosition = new Pair();
        DexDebugPositionState visitor = new DexDebugPositionState(debugInfo.startLine, appView.graphLens().getOriginalMethodSignature((DexMethod)method.getReference())){

            @Override
            public void visit(DexDebugEvent.Default defaultEvent) {
                super.visit(defaultEvent);
                assert (this.getCurrentLine() >= 0);
                Position currentPosition = LineNumberOptimizer.getPositionFromPositionState(this);
                if (lastPosition.getSecond() != null) {
                    if (singleOriginalLine.isTrue() && !currentPosition.equals(lastPosition.getSecond())) {
                        singleOriginalLine.set(false);
                    }
                    LineNumberOptimizer.remapAndAddForPc((Integer)lastPosition.getFirst(), this.getCurrentPc(), (Position)lastPosition.getSecond(), positionRemapper, mappedPositions);
                }
                lastPosition.setFirst(this.getCurrentPc());
                lastPosition.setSecond(currentPosition);
                this.resetOutlineInformation();
            }
        };
        for (DexDebugEvent event : debugInfo.events) {
            event.accept(visitor);
        }
        int lastInstructionPc = ArrayUtils.last(dexCode.instructions).getOffset();
        if (lastPosition.getSecond() != null) {
            LineNumberOptimizer.remapAndAddForPc((Integer)lastPosition.getFirst(), lastInstructionPc + 1, (Position)lastPosition.getSecond(), positionRemapper, mappedPositions);
        }
        assert (!mappedPositions.isEmpty());
        if (singleOriginalLine.isTrue() && lastPosition.getSecond() != null && !((MappedPosition)mappedPositions.get(0)).isOutlineCaller()) {
            dexCode.setDebugInfo(DexDebugInfoForSingleLineMethod.getInstance());
            debugInfoProvider.recordSingleLineFor(dexCode, method.getParameters().size(), lastInstructionPc);
        } else {
            debugInfoProvider.recordPcMappingFor(dexCode, lastInstructionPc, debugInfo.parameters.length);
        }
        return mappedPositions;
    }

    private static boolean verifyIdentityMapping(DexDebugInfo.EventBasedDebugInfo originalDebugInfo, DexDebugInfo.EventBasedDebugInfo optimizedDebugInfo) {
        assert (optimizedDebugInfo.startLine == originalDebugInfo.startLine);
        assert (optimizedDebugInfo.events.length == originalDebugInfo.events.length);
        for (int i = 0; i < originalDebugInfo.events.length; ++i) {
            assert (optimizedDebugInfo.events[i].equals(originalDebugInfo.events[i]));
        }
        return true;
    }

    private static List<MappedPosition> optimizeCfCodePositions(ProgramMethod method, PositionRemapper positionRemapper, AppView<?> appView) {
        ArrayList<MappedPosition> mappedPositions = new ArrayList<MappedPosition>();
        CfCode oldCode = ((DexEncodedMethod)method.getDefinition()).getCode().asCfCode();
        List<CfInstruction> oldInstructions = oldCode.getInstructions();
        ArrayList<CfInstruction> newInstructions = new ArrayList<CfInstruction>(oldInstructions.size());
        for (CfInstruction oldInstruction : oldInstructions) {
            CfInstruction newInstruction;
            if (oldInstruction instanceof CfPosition) {
                CfPosition cfPosition = (CfPosition)oldInstruction;
                newInstruction = new CfPosition(cfPosition.getLabel(), LineNumberOptimizer.remapAndAdd(cfPosition.getPosition(), positionRemapper, mappedPositions));
            } else {
                newInstruction = oldInstruction;
            }
            newInstructions.add(newInstruction);
        }
        method.setCode(new CfCode(method.getHolderType(), oldCode.getMaxStack(), oldCode.getMaxLocals(), newInstructions, oldCode.getTryCatchRanges(), oldCode.getLocalVariables()), appView);
        return mappedPositions;
    }

    private static Position remapAndAdd(Position position, PositionRemapper remapper, List<MappedPosition> mappedPositions) {
        Pair<Position, Position> remappedPosition = remapper.createRemappedPosition(position);
        Position oldPosition = remappedPosition.getFirst();
        Position newPosition = remappedPosition.getSecond();
        mappedPositions.add(new MappedPosition(oldPosition.getMethod(), oldPosition.getLine(), oldPosition.getCallerPosition(), newPosition.getLine(), oldPosition.isOutline(), oldPosition.getOutlineCallee(), oldPosition.getOutlinePositions()));
        return newPosition;
    }

    private static void remapAndAddForPc(int startPc, int endPc, Position position, PositionRemapper remapper, List<MappedPosition> mappedPositions) {
        Pair<Position, Position> remappedPosition = remapper.createRemappedPosition(position);
        Position oldPosition = remappedPosition.getFirst();
        for (int currentPc = startPc; currentPc < endPc; ++currentPc) {
            boolean firstEntry = currentPc == startPc;
            mappedPositions.add(new MappedPosition(oldPosition.getMethod(), oldPosition.getLine(), oldPosition.getCallerPosition(), currentPc, firstEntry && oldPosition.isOutline(), firstEntry ? oldPosition.getOutlineCallee() : null, firstEntry ? oldPosition.getOutlinePositions() : null));
        }
    }

    private static class OutlineFixupBuilder {
        private static int MINIFIED_POSITION_REMOVED = -1;
        private List<MappedPosition> mappedOutlinePositions = null;
        private final List<Pair<ClassNamingForNameMapper.MappedRange, Int2IntMap>> mappedOutlineCalleePositions = new ArrayList<Pair<ClassNamingForNameMapper.MappedRange, Int2IntMap>>();

        private OutlineFixupBuilder() {
        }

        private int getMinifiedLinePosition(int originalPosition, List<MappedPosition> mappedPositions) {
            for (MappedPosition mappedPosition : mappedPositions) {
                if (mappedPosition.originalLine != originalPosition) continue;
                return mappedPosition.obfuscatedLine;
            }
            return MINIFIED_POSITION_REMOVED;
        }

        public void setMappedPositionsOutline(List<MappedPosition> mappedPositionsOutline) {
            this.mappedOutlinePositions = mappedPositionsOutline;
        }

        public void addMappedRangeForOutlineCallee(ClassNamingForNameMapper.MappedRange mappedRangeForOutline, Int2IntMap calleePositions) {
            this.mappedOutlineCalleePositions.add(Pair.create(mappedRangeForOutline, calleePositions));
        }

        public void fixup() {
            if (this.mappedOutlinePositions == null || this.mappedOutlineCalleePositions.isEmpty()) {
                assert (this.mappedOutlinePositions != null) : "Mapped outline positions is null";
                assert (false) : "Mapped outline positions is empty";
                return;
            }
            for (Pair<ClassNamingForNameMapper.MappedRange, Int2IntMap> mappingInfo : this.mappedOutlineCalleePositions) {
                ClassNamingForNameMapper.MappedRange mappedRange = mappingInfo.getFirst();
                Int2IntMap positions = mappingInfo.getSecond();
                Int2IntLinkedOpenHashMap map = new Int2IntLinkedOpenHashMap();
                positions.forEach((outlinePosition, calleePosition) -> {
                    int minifiedLinePosition = this.getMinifiedLinePosition((int)outlinePosition, this.mappedOutlinePositions);
                    if (minifiedLinePosition != MINIFIED_POSITION_REMOVED) {
                        map.put(minifiedLinePosition, (int)calleePosition);
                    }
                });
                mappedRange.addMappingInformation(OutlineCallsiteMappingInformation.create(map), xva$0 -> Unreachable.raise(xva$0));
            }
        }
    }

    private static class NativePcSupport
    implements PcBasedDebugInfoRecorder {
        private NativePcSupport() {
        }

        @Override
        public void recordPcMappingFor(DexCode code, int lastInstructionPc, int length) {
            code.setDebugInfo(null);
        }

        @Override
        public void recordSingleLineFor(DexCode code, int parameterCount) {
            code.setDebugInfo(null);
        }

        @Override
        public void recordSingleLineFor(DexCode code, int parameterCount, int lastInstructionPc) {
            this.recordSingleLineFor(code, parameterCount);
        }

        @Override
        public void updateDebugInfoInCodeObjects() {
        }
    }

    private static class Pc2PcMappingSupport
    implements PcBasedDebugInfoRecorder {
        private Int2IntMap paramToMaxPc = new Int2IntOpenHashMap();
        private final List<Pair<Integer, DexCode>> codesToUpdate = new ArrayList<Pair<Integer, DexCode>>();
        private final List<DexCode> singleLineCodesToClear;

        public Pc2PcMappingSupport(boolean allowDiscardingSourceFile) {
            this.singleLineCodesToClear = allowDiscardingSourceFile ? new ArrayList() : null;
        }

        private static DexDebugInfo buildPc2PcDebugInfo(int lastInstructionPc, int parameterCount) {
            return new DexDebugInfo.PcBasedDebugInfo(parameterCount, lastInstructionPc);
        }

        @Override
        public void recordPcMappingFor(DexCode code, int lastInstructionPc, int parameterCount) {
            this.codesToUpdate.add(new Pair<Integer, DexCode>(parameterCount, code));
            int existing = this.paramToMaxPc.getOrDefault(parameterCount, -1);
            if (existing < lastInstructionPc) {
                this.paramToMaxPc.put(parameterCount, lastInstructionPc);
            }
        }

        @Override
        public void recordSingleLineFor(DexCode code, int parameterCount) {
            if (this.singleLineCodesToClear != null) {
                this.singleLineCodesToClear.add(code);
                return;
            }
            int lastInstructionPc = ArrayUtils.last(code.instructions).getOffset();
            this.recordPcMappingFor(code, lastInstructionPc, parameterCount);
        }

        @Override
        public void recordSingleLineFor(DexCode code, int parameterCount, int lastInstructionPc) {
            if (this.singleLineCodesToClear != null) {
                this.singleLineCodesToClear.add(code);
                return;
            }
            this.recordPcMappingFor(code, lastInstructionPc, parameterCount);
        }

        @Override
        public void updateDebugInfoInCodeObjects() {
            Int2ReferenceOpenHashMap debugInfos = new Int2ReferenceOpenHashMap(this.paramToMaxPc.size());
            this.codesToUpdate.forEach(entry -> {
                int parameterCount = (Integer)entry.getFirst();
                DexCode code = (DexCode)entry.getSecond();
                DexDebugInfo debugInfo = debugInfos.computeIfAbsent(parameterCount, key -> Pc2PcMappingSupport.buildPc2PcDebugInfo(this.paramToMaxPc.get(key), parameterCount));
                code.setDebugInfo(debugInfo);
            });
            if (this.singleLineCodesToClear != null) {
                this.singleLineCodesToClear.forEach(c -> c.setDebugInfo(null));
            }
        }
    }

    private static interface PcBasedDebugInfoRecorder {
        public void recordPcMappingFor(DexCode var1, int var2, int var3);

        public void recordSingleLineFor(DexCode var1, int var2);

        public void recordSingleLineFor(DexCode var1, int var2, int var3);

        public void updateDebugInfoInCodeObjects();
    }

    private static class MappedPosition {
        private final DexMethod method;
        private final int originalLine;
        private final Position caller;
        private final int obfuscatedLine;
        private final boolean isOutline;
        private final DexMethod outlineCallee;
        private final Int2StructuralItemArrayMap<Position> outlinePositions;

        private MappedPosition(DexMethod method, int originalLine, Position caller, int obfuscatedLine, boolean isOutline, DexMethod outlineCallee, Int2StructuralItemArrayMap<Position> outlinePositions) {
            this.method = method;
            this.originalLine = originalLine;
            this.caller = caller;
            this.obfuscatedLine = obfuscatedLine;
            this.isOutline = isOutline;
            this.outlineCallee = outlineCallee;
            this.outlinePositions = outlinePositions;
        }

        public boolean isOutlineCaller() {
            return this.outlineCallee != null;
        }
    }

    private static class PositionEventEmitter {
        private final DexItemFactory dexItemFactory;
        private int startLine = -1;
        private final DexMethod method;
        private int previousPc = 0;
        private Position previousPosition = null;
        private final List<DexDebugEvent> processedEvents;

        private PositionEventEmitter(DexItemFactory dexItemFactory, DexMethod method, List<DexDebugEvent> processedEvents) {
            this.dexItemFactory = dexItemFactory;
            this.method = method;
            this.processedEvents = processedEvents;
        }

        private void emitAdvancePc(int pc) {
            this.processedEvents.add(new DexDebugEvent.AdvancePC(pc - this.previousPc));
            this.previousPc = pc;
        }

        private void emitPositionEvents(int currentPc, Position currentPosition) {
            if (this.previousPosition == null) {
                this.startLine = currentPosition.getLine();
                this.previousPosition = ((Position.SourcePosition.SourcePositionBuilder)((Position.SourcePosition.SourcePositionBuilder)Position.SourcePosition.builder().setLine(this.startLine)).setMethod(this.method)).build();
            }
            DexDebugEventBuilder.emitAdvancementEvents(this.previousPc, this.previousPosition, currentPc, currentPosition, this.processedEvents, this.dexItemFactory, true);
            this.previousPc = currentPc;
            this.previousPosition = currentPosition;
        }

        private int getStartLine() {
            assert (this.startLine >= 0);
            return this.startLine;
        }
    }

    private static class KotlinInlineFunctionPositionRemapper
    implements PositionRemapper {
        private final AppView<?> appView;
        private final DexItemFactory factory;
        private final Map<DexType, KotlinSourceDebugExtensionParser.Result> parsedKotlinSourceDebugExtensions = new IdentityHashMap<DexType, KotlinSourceDebugExtensionParser.Result>();
        private final CfLineToMethodMapper lineToMethodMapper;
        private final PositionRemapper baseRemapper;
        private DexEncodedMethod currentMethod;
        private KotlinSourceDebugExtensionParser.Result parsedData = null;

        private KotlinInlineFunctionPositionRemapper(AppView<?> appView, PositionRemapper baseRemapper, CfLineToMethodMapper lineToMethodMapper) {
            this.appView = appView;
            this.factory = appView.dexItemFactory();
            this.baseRemapper = baseRemapper;
            this.lineToMethodMapper = lineToMethodMapper;
        }

        private KotlinSourceDebugExtensionParser.Result getAndParseSourceDebugExtension(DexType holder) {
            if (this.parsedData == null) {
                this.parsedData = this.parsedKotlinSourceDebugExtensions.get(holder);
            }
            if (this.parsedData != null || this.parsedKotlinSourceDebugExtensions.containsKey(holder)) {
                return this.parsedData;
            }
            DexClass clazz = this.appView.definitionFor(this.currentMethod.getHolderType());
            DexValue.DexValueString dexValueString = this.appView.getSourceDebugExtensionForType(clazz);
            if (dexValueString != null) {
                this.parsedData = KotlinSourceDebugExtensionParser.parse(((DexString)dexValueString.value).toString());
            }
            this.parsedKotlinSourceDebugExtensions.put(holder, this.parsedData);
            return this.parsedData;
        }

        @Override
        public Pair<Position, Position> createRemappedPosition(Position position) {
            assert (this.currentMethod != null);
            int line = position.getLine();
            KotlinSourceDebugExtensionParser.Result parsedData = this.getAndParseSourceDebugExtension(position.getMethod().holder);
            if (parsedData == null) {
                return this.baseRemapper.createRemappedPosition(position);
            }
            Map.Entry<Integer, KotlinSourceDebugExtensionParser.Position> inlinedPosition = parsedData.lookupInlinedPosition(line);
            if (inlinedPosition == null) {
                return this.baseRemapper.createRemappedPosition(position);
            }
            int inlineeLineDelta = line - inlinedPosition.getKey();
            int originalInlineeLine = inlinedPosition.getValue().getRange().from + inlineeLineDelta;
            try {
                String binaryName = inlinedPosition.getValue().getSource().getPath();
                String nameAndDescriptor = this.lineToMethodMapper.lookupNameAndDescriptor(binaryName, originalInlineeLine);
                if (nameAndDescriptor == null) {
                    return this.baseRemapper.createRemappedPosition(position);
                }
                String clazzDescriptor = DescriptorUtils.getDescriptorFromClassBinaryName(binaryName);
                String methodName = CfLineToMethodMapper.getName(nameAndDescriptor);
                String methodDescriptor = CfLineToMethodMapper.getDescriptor(nameAndDescriptor);
                String returnTypeDescriptor = DescriptorUtils.getReturnTypeDescriptor(methodDescriptor);
                String[] argumentDescriptors = DescriptorUtils.getArgumentTypeDescriptors(methodDescriptor);
                DexString[] argumentDexStringDescriptors = new DexString[argumentDescriptors.length];
                for (int i = 0; i < argumentDescriptors.length; ++i) {
                    argumentDexStringDescriptors[i] = this.factory.createString(argumentDescriptors[i]);
                }
                DexMethod inlinee = this.factory.createMethod(this.factory.createString(clazzDescriptor), this.factory.createString(methodName), this.factory.createString(returnTypeDescriptor), argumentDexStringDescriptors);
                if (!inlinee.equals(position.getMethod())) {
                    Map.Entry<Integer, KotlinSourceDebugExtensionParser.Position> calleePosition = parsedData.lookupCalleePosition(line);
                    if (calleePosition != null) {
                        position = ((Position.PositionBuilder)position.builderWithCopy().setLine(calleePosition.getValue().getRange().from)).build();
                    }
                    return this.baseRemapper.createRemappedPosition(((Position.SourcePosition.SourcePositionBuilder)((Position.SourcePosition.SourcePositionBuilder)((Position.SourcePosition.SourcePositionBuilder)Position.SourcePosition.builder().setLine(originalInlineeLine)).setMethod(inlinee)).setCallerPosition(position)).build());
                }
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
            return this.baseRemapper.createRemappedPosition(position);
        }

        public void setMethod(DexEncodedMethod method) {
            this.currentMethod = method;
            this.parsedData = null;
        }
    }

    private static class OptimizingPositionRemapper
    implements PositionRemapper {
        private final int maxLineDelta;
        private DexMethod previousMethod = null;
        private int previousSourceLine = -1;
        private int nextOptimizedLineNumber = 1;

        OptimizingPositionRemapper(InternalOptions options) {
            this.maxLineDelta = options.isGeneratingClassFiles() ? Integer.MAX_VALUE : 1;
        }

        @Override
        public Pair<Position, Position> createRemappedPosition(Position position) {
            assert (position.getMethod() != null);
            if (this.previousMethod == position.getMethod()) {
                assert (this.previousSourceLine >= 0);
                if (position.getLine() > this.previousSourceLine && position.getLine() - this.previousSourceLine <= this.maxLineDelta) {
                    this.nextOptimizedLineNumber += position.getLine() - this.previousSourceLine - 1;
                }
            }
            Object newPosition = ((Position.PositionBuilder)((Position.PositionBuilder)position.builderWithCopy().setLine(this.nextOptimizedLineNumber++)).setCallerPosition(null)).build();
            this.previousSourceLine = position.getLine();
            this.previousMethod = position.getMethod();
            return new Pair<Position, Position>(position, (Position)newPosition);
        }
    }

    private static class IdentityPositionRemapper
    implements PositionRemapper {
        private IdentityPositionRemapper() {
        }

        @Override
        public Pair<Position, Position> createRemappedPosition(Position position) {
            assert (position.getOutlineCallee() == null);
            return new Pair<Position, Position>(position, position);
        }
    }

    private static interface PositionRemapper {
        public Pair<Position, Position> createRemappedPosition(Position var1);
    }
}

