/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.utils.Box;
import java.util.Map;
import java.util.TreeMap;

public class SegmentTree<V> {
    private final TreeMap<Integer, V> internalTree = new TreeMap();
    private final boolean allowIntervalOverwrites;
    private int size = 0;

    public SegmentTree(boolean allowIntervalOverwrites) {
        this.allowIntervalOverwrites = allowIntervalOverwrites;
    }

    public V find(int point) {
        Map.Entry<Integer, V> entry = this.findEntry(point);
        return entry != null ? (V)entry.getValue() : null;
    }

    public Map.Entry<Integer, V> findEntry(Integer point) {
        Map.Entry<Integer, V> kvEntry = this.internalTree.floorEntry(point);
        return kvEntry == null || kvEntry.getValue() == null ? null : kvEntry;
    }

    public SegmentTree<V> add(int start, int end, V value) {
        Map.Entry<Integer, V> existingEndRange = this.findEntry(end);
        Box<Integer> removedIntervals = new Box<Integer>(0);
        boolean removedKeys = this.internalTree.navigableKeySet().removeIf(key -> {
            if (start < key && key <= end) {
                assert (this.allowIntervalOverwrites);
                if (this.internalTree.get(key) != null) {
                    removedIntervals.set((Integer)removedIntervals.get() + 1);
                }
                return true;
            }
            return false;
        });
        if (existingEndRange != null) {
            assert (this.allowIntervalOverwrites);
            if (removedKeys) {
                removedIntervals.set(removedIntervals.get() - 1);
            }
        }
        this.internalTree.put(start, value);
        if (!this.internalTree.containsKey(end + 1)) {
            this.internalTree.put(end + 1, existingEndRange == null ? null : (Object)existingEndRange.getValue());
        }
        this.size = this.size - removedIntervals.get() + 1;
        return this;
    }

    public int size() {
        return this.size;
    }
}

