/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.utils.ForEachable;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class SetUtils {
    public static <T> boolean containsAnyOf(Set<T> set, Iterable<T> elements) {
        for (T element : elements) {
            if (!set.contains(element)) continue;
            return true;
        }
        return false;
    }

    public static <T> Set<T> newConcurrentHashSet(int capacity) {
        return Collections.newSetFromMap(new ConcurrentHashMap(capacity));
    }

    public static <T> HashSet<T> newHashSet(T element) {
        HashSet<T> result = new HashSet<T>(1);
        result.add(element);
        return result;
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... elements) {
        HashSet result = new HashSet(elements.length);
        Collections.addAll(result, elements);
        return result;
    }

    public static <T> Set<T> newIdentityHashSet(T element) {
        Set<T> result = Sets.newIdentityHashSet();
        result.add(element);
        return result;
    }

    @SafeVarargs
    public static <T> Set<T> newIdentityHashSet(T ... elements) {
        Set<T> result = SetUtils.newIdentityHashSet(elements.length);
        Collections.addAll(result, elements);
        return result;
    }

    public static <T> Set<T> newIdentityHashSet(ForEachable<T> forEachable) {
        Set result = Sets.newIdentityHashSet();
        forEachable.forEach(result::add);
        return result;
    }

    public static <T> Set<T> newIdentityHashSet(Iterable<? extends T> c) {
        Set result = Sets.newIdentityHashSet();
        c.forEach(result::add);
        return result;
    }

    public static <T> Set<T> newIdentityHashSet(Iterable<T> c1, Iterable<T> c2) {
        Set result = Sets.newIdentityHashSet();
        c1.forEach(result::add);
        c2.forEach(result::add);
        return result;
    }

    public static <T> Set<T> newIdentityHashSet(Iterable<T> c1, Iterable<T> c2, Iterable<T> c3) {
        Set result = Sets.newIdentityHashSet();
        c1.forEach(result::add);
        c2.forEach(result::add);
        c3.forEach(result::add);
        return result;
    }

    public static <T> Set<T> newIdentityHashSet(int capacity) {
        return Collections.newSetFromMap(new IdentityHashMap(capacity));
    }

    public static <T> Set<T> newIdentityHashSet(T element, int capacity) {
        Set<T> result = SetUtils.newIdentityHashSet(capacity);
        result.add(element);
        return result;
    }

    public static <T> ImmutableSet<T> newImmutableSet(ForEachable<T> forEachable) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        forEachable.forEach(builder::add);
        return builder.build();
    }

    @SafeVarargs
    public static <T> ImmutableSet<T> newImmutableSetExcludingNullItems(T ... items) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (T item : items) {
            if (item == null) continue;
            builder.add(item);
        }
        return builder.build();
    }

    public static <T, S> Set<T> mapIdentityHashSet(Set<S> set, Function<S, T> fn) {
        Set<T> out = SetUtils.newIdentityHashSet(set.size());
        for (S element : set) {
            out.add(fn.apply(element));
        }
        return out;
    }

    public static <T> T removeFirst(Set<T> set) {
        T element = set.iterator().next();
        set.remove(element);
        return element;
    }

    public static <T> Set<T> unionIdentityHashSet(Set<T> one, Set<T> other) {
        Set<T> union = Sets.newIdentityHashSet();
        union.addAll(one);
        union.addAll(other);
        return union;
    }
}

