/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.SourceFileEnvironment;
import com.android.tools.r8.SourceFileProvider;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.Map;

public class SourceFileTemplateProvider
implements SourceFileProvider {
    private static final char VARIABLE_PREFIX = '%';
    private static final Map<String, SourceFileProvider> HANDLERS = ImmutableMap.builder().put(SourceFileTemplateProvider.var("MAP_ID"), SourceFileEnvironment::getMapId).put(SourceFileTemplateProvider.var("MAP_HASH"), SourceFileEnvironment::getMapHash).build();
    private final String template;
    private String cachedValue = null;

    private static String var(String name) {
        return '%' + name;
    }

    private static int getMaxVariableLength() {
        int max = 0;
        for (String key : HANDLERS.keySet()) {
            max = Math.max(max, key.length());
        }
        return max;
    }

    public static SourceFileProvider create(String template, DiagnosticsHandler handler) {
        String cleaned = template;
        for (String variable : HANDLERS.keySet()) {
            cleaned = cleaned.replace(variable, ' ' + variable.substring(1));
        }
        assert (template.length() == cleaned.length());
        int unhandled = cleaned.indexOf(37);
        if (unhandled >= 0) {
            while (unhandled >= 0) {
                int endIndex = Math.min(unhandled + SourceFileTemplateProvider.getMaxVariableLength(), template.length());
                String variablePrefix = template.substring(unhandled, endIndex);
                handler.error(new StringDiagnostic("Invalid template variable starting with " + variablePrefix));
                unhandled = cleaned.indexOf(37, unhandled + 1);
            }
            return null;
        }
        return new SourceFileTemplateProvider(template);
    }

    private SourceFileTemplateProvider(String template) {
        this.template = template;
    }

    @Override
    public String get(SourceFileEnvironment environment) {
        if (this.cachedValue == null) {
            this.cachedValue = this.template;
            HANDLERS.forEach((variable, getter) -> {
                this.cachedValue = this.cachedValue.replace((CharSequence)variable, getter.get(environment));
            });
        }
        return this.cachedValue;
    }
}

