/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.utils.DescriptorUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static void writeResourcesToZip(List<ProgramResource> resources, Set<DataEntryResource> dataResources, Closer closer, ZipOutputStream out) throws IOException, ResourceException {
        for (ProgramResource resource : resources) {
            assert (resource.getClassDescriptors().size() == 1);
            Iterator<String> iterator2 = resource.getClassDescriptors().iterator();
            String className = iterator2.next();
            String entryName = DescriptorUtils.getClassFileName(className);
            byte[] bytes = ByteStreams.toByteArray(closer.register(resource.getByteStream()));
            ZipUtils.writeToZipStream(out, entryName, bytes, 8);
        }
        for (DataEntryResource dataResource : dataResources) {
            String entryName = dataResource.getName();
            byte[] bytes = ByteStreams.toByteArray(closer.register(dataResource.getByteStream()));
            ZipUtils.writeToZipStream(out, entryName, bytes, 8);
        }
    }

    public static void iter(String zipFileStr, OnEntryHandler handler) throws IOException {
        ZipUtils.iter(Paths.get(zipFileStr, new String[0]), handler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void iter(Path zipFilePath, OnEntryHandler handler) throws IOException {
        ZipFile zipFile = new ZipFile(zipFilePath.toFile(), StandardCharsets.UTF_8);
        Throwable throwable = null;
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream entryStream = zipFile.getInputStream(entry);
                Throwable throwable2 = null;
                try {
                    handler.onEntry(entry, entryStream);
                    if (entryStream == null) continue;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (entryStream == null) throw throwable4;
                        ZipUtils.$closeResource(throwable2, entryStream);
                        throw throwable4;
                    }
                }
                ZipUtils.$closeResource(throwable2, entryStream);
            }
        }
        catch (Throwable throwable5) {
            try {
                throwable = throwable5;
                throw throwable5;
            }
            catch (Throwable throwable6) {
                ZipUtils.$closeResource(throwable, zipFile);
                throw throwable6;
            }
        }
        ZipUtils.$closeResource(throwable, zipFile);
    }

    public static Path map(Path zipFilePath, Path mappedFilePath, BiFunction<ZipEntry, byte[], byte[]> map) throws IOException {
        ZipBuilder builder = ZipBuilder.builder(mappedFilePath);
        ZipUtils.iter(zipFilePath, (ZipEntry entry, InputStream input) -> builder.addBytes(entry.getName(), (byte[])map.apply(entry, ByteStreams.toByteArray(input))));
        return builder.build();
    }

    public static Path filter(Path zipFilePath, Path filteredFilePath, Predicate<ZipEntry> predicate) throws IOException {
        ZipBuilder builder = ZipBuilder.builder(filteredFilePath);
        ZipUtils.iter(zipFilePath, (ZipEntry entry, InputStream input) -> {
            if (predicate.test(entry)) {
                builder.addBytes(entry.getName(), ByteStreams.toByteArray(input));
            }
        });
        return builder.build();
    }

    public static byte[] readSingleEntry(Path zipFilePath, String name) throws IOException {
        byte[] byArray;
        ZipFile zipFile = new ZipFile(zipFilePath.toFile(), StandardCharsets.UTF_8);
        Throwable throwable = null;
        try {
            byArray = ByteStreams.toByteArray(zipFile.getInputStream(zipFile.getEntry(name)));
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                ZipUtils.$closeResource(throwable, zipFile);
                throw throwable3;
            }
        }
        ZipUtils.$closeResource(throwable, zipFile);
        return byArray;
    }

    public static void zip(Path zipFile, Path inputDirectory) throws IOException {
        List<Path> files = Files.walk(inputDirectory, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).collect(Collectors.toList());
        ZipUtils.zip(zipFile, inputDirectory, files);
    }

    public static void zip(Path zipFile, Path basePath, Collection<Path> filesToZip) throws IOException {
        ZipOutputStream stream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(zipFile, new OpenOption[0])));
        Throwable throwable = null;
        try {
            ZipUtils.zip(stream, basePath, filesToZip);
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                ZipUtils.$closeResource(throwable, stream);
                throw throwable3;
            }
        }
        ZipUtils.$closeResource(throwable, stream);
    }

    public static void zip(ZipOutputStream stream, Path basePath, Collection<Path> filesToZip) throws IOException {
        for (Path path : filesToZip) {
            ZipEntry zipEntry = new ZipEntry(StreamSupport.stream(Spliterators.spliteratorUnknownSize(basePath.relativize(path).iterator(), 16), false).map(Path::toString).collect(Collectors.joining("/")));
            stream.putNextEntry(zipEntry);
            Files.copy(path, stream);
            stream.closeEntry();
        }
    }

    public static void zip(Path zipFile, Path basePath, Path ... filesToZip) throws IOException {
        ZipUtils.zip(zipFile, basePath, Arrays.asList(filesToZip));
    }

    public static List<Path> unzip(Path zipFile, Path outDirectory) throws IOException {
        return ZipUtils.unzip(zipFile.toString(), outDirectory.toFile(), entry -> true).stream().map(File::toPath).collect(Collectors.toList());
    }

    public static List<File> unzip(String zipFile, File outDirectory) throws IOException {
        return ZipUtils.unzip(zipFile, outDirectory, entry -> true);
    }

    public static List<File> unzip(String zipFile, File outDirectory, Predicate<ZipEntry> filter) throws IOException {
        Path outDirectoryPath = outDirectory.toPath();
        ArrayList<File> outFiles = new ArrayList<File>();
        ZipUtils.iter(zipFile, (ZipEntry entry, InputStream input) -> {
            block5: {
                String name = entry.getName();
                if (entry.isDirectory() || !filter.test(entry)) break block5;
                if (name.contains("..")) {
                    throw new CompilationError("Invalid entry name \"" + name + "\"");
                }
                Path outPath = outDirectoryPath.resolve(name);
                File outFile = outPath.toFile();
                outFile.getParentFile().mkdirs();
                FileOutputStream output = new FileOutputStream(outFile);
                Throwable throwable = null;
                try {
                    ByteStreams.copy(input, output);
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        ZipUtils.$closeResource(throwable, output);
                        throw throwable3;
                    }
                }
                ZipUtils.$closeResource(throwable, output);
                outFiles.add(outFile);
            }
        });
        return outFiles;
    }

    public static void writeToZipStream(ZipOutputStream stream, String entry, byte[] content, int compressionMethod) throws IOException {
        ZipUtils.writeToZipStream(stream, entry, ByteDataView.of(content), compressionMethod);
    }

    public static void writeToZipStream(ZipOutputStream stream, String entry, ByteDataView content, int compressionMethod) throws IOException {
        byte[] buffer = content.getBuffer();
        int offset = content.getOffset();
        int length = content.getLength();
        CRC32 crc = new CRC32();
        crc.update(buffer, offset, length);
        ZipEntry zipEntry = new ZipEntry(entry);
        zipEntry.setMethod(compressionMethod);
        zipEntry.setSize(length);
        zipEntry.setCrc(crc.getValue());
        zipEntry.setTime(0L);
        stream.putNextEntry(zipEntry);
        stream.write(buffer, offset, length);
        stream.closeEntry();
    }

    public static boolean isDexFile(String entry) {
        String name = entry.toLowerCase();
        return name.endsWith(".dex");
    }

    public static boolean isClassFile(String entry) {
        String name = entry.toLowerCase();
        if (name.endsWith("module-info.class")) {
            return false;
        }
        if (name.startsWith("meta-inf") || name.startsWith("/meta-inf")) {
            return false;
        }
        return name.endsWith(".class");
    }

    public static String zipEntryNameForClass(Class<?> clazz) {
        return DescriptorUtils.getClassBinaryName(clazz) + ".class";
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    public static class ZipBuilder {
        private final Path zipFile;
        private final ZipOutputStream stream;

        private ZipBuilder(Path zipFile) throws IOException {
            this.zipFile = zipFile;
            this.stream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(zipFile, new OpenOption[0])));
        }

        public static ZipBuilder builder(Path zipFile) throws IOException {
            return new ZipBuilder(zipFile);
        }

        public ZipBuilder addFilesRelative(Path basePath, Collection<Path> filesToAdd) throws IOException {
            for (Path path : filesToAdd) {
                ZipEntry zipEntry = new ZipEntry(StreamSupport.stream(Spliterators.spliteratorUnknownSize(basePath.relativize(path).iterator(), 16), false).map(Path::toString).collect(Collectors.joining("/")));
                this.stream.putNextEntry(zipEntry);
                Files.copy(path, this.stream);
                this.stream.closeEntry();
            }
            return this;
        }

        public ZipBuilder addFilesRelative(Path basePath, Path ... filesToAdd) throws IOException {
            return this.addFilesRelative(basePath, Arrays.asList(filesToAdd));
        }

        public ZipBuilder addBytes(String path, byte[] bytes) throws IOException {
            ZipEntry zipEntry = new ZipEntry(path);
            this.stream.putNextEntry(zipEntry);
            this.stream.write(bytes);
            this.stream.closeEntry();
            return this;
        }

        public Path build() throws IOException {
            this.stream.close();
            return this.zipFile;
        }
    }

    public static interface OnEntryHandler {
        public void onEntry(ZipEntry var1, InputStream var2) throws IOException;
    }
}

