/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.collections;

import com.android.tools.r8.utils.TriConsumer;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneHashMap;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneRepresentativeMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalManyToOneRepresentativeMap;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class BidirectionalManyToOneRepresentativeHashMap<K, V>
extends BidirectionalManyToOneHashMap<K, V>
implements MutableBidirectionalManyToOneRepresentativeMap<K, V> {
    private final Map<V, K> representatives;

    public static <K, V> BidirectionalManyToOneRepresentativeHashMap<K, V> newIdentityHashMap() {
        return new BidirectionalManyToOneRepresentativeHashMap(new IdentityHashMap(), new IdentityHashMap(), new IdentityHashMap());
    }

    private BidirectionalManyToOneRepresentativeHashMap(Map<K, V> backing, Map<V, Set<K>> inverse, Map<V, K> representatives) {
        super(backing, inverse);
        this.representatives = representatives;
    }

    @Override
    public void clear() {
        super.clear();
        this.representatives.clear();
    }

    @Override
    public void forEachManyToOneMapping(TriConsumer<? super Set<K>, V, K> consumer) {
        this.forEachManyToOneMapping((? super Set<K> keys2, V value) -> consumer.accept((Set<K>)keys2, (V)value, this.getRepresentativeKey(value)));
    }

    @Override
    public K removeRepresentativeFor(V value) {
        return this.representatives.remove(value);
    }

    @Override
    public void setRepresentative(V value, K representative) {
        this.representatives.put(value, representative);
    }

    @Override
    public boolean hasExplicitRepresentativeKey(V value) {
        return this.representatives.containsKey(value);
    }

    @Override
    public K getRepresentativeKey(V value) {
        Set keys2 = this.getKeys(value);
        if (!keys2.isEmpty()) {
            if (keys2.size() == 1) {
                return keys2.iterator().next();
            }
            assert (this.hasExplicitRepresentativeKey(value));
            return this.representatives.get(value);
        }
        return null;
    }

    @Override
    public V getRepresentativeValue(K key) {
        return this.get(key);
    }

    @Override
    public Set<V> getValues(K key) {
        if (this.containsKey(key)) {
            return Collections.singleton(this.get(key));
        }
        return Collections.emptySet();
    }

    @Override
    public void putAll(BidirectionalManyToOneRepresentativeMap<K, V> map) {
        map.forEachManyToOneMapping((? super Set<K> keys2, V value, K representative) -> {
            this.put(keys2, value);
            if (keys2.size() > 1) {
                this.setRepresentative(value, representative);
            }
        });
    }

    @Override
    public V remove(K key) {
        Object value = super.remove(key);
        if (this.hasExplicitRepresentativeKey(value) && (this.getKeys(value).size() <= 1 || this.getRepresentativeKey(value) == key)) {
            this.removeRepresentativeFor(value);
        }
        return value;
    }

    @Override
    public Set<K> removeValue(V value) {
        Set keys2 = super.removeValue(value);
        this.removeRepresentativeFor(value);
        return keys2;
    }
}

