/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.collections;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.utils.TriConsumer;
import com.android.tools.r8.utils.collections.BidirectionalManyToManyMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalOneToOneMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class BidirectionalOneToOneHashMap<K, V>
implements MutableBidirectionalOneToOneMap<K, V>,
Map<K, V> {
    private final BiMap<K, V> backing;

    public BidirectionalOneToOneHashMap() {
        this(HashBiMap.create());
    }

    public BidirectionalOneToOneHashMap(BiMap<K, V> backing) {
        this.backing = backing;
    }

    @Override
    public void clear() {
        this.backing.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backing.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backing.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backing.entrySet();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> consumer) {
        this.backing.forEach(consumer);
    }

    @Override
    public void forEachKey(Consumer<? super K> consumer) {
        this.backing.keySet().forEach(consumer);
    }

    @Override
    public void forEachManyToOneMapping(BiConsumer<? super Set<K>, V> consumer) {
        this.backing.forEach((key, value) -> consumer.accept(Collections.singleton(key), value));
    }

    @Override
    public void forEachManyToOneMapping(TriConsumer<? super Set<K>, V, K> consumer) {
        this.backing.forEach((key, value) -> consumer.accept(Collections.singleton(key), value, key));
    }

    @Override
    public void forEachValue(Consumer<? super V> consumer) {
        this.backing.values().forEach(consumer);
    }

    @Override
    public V get(Object key) {
        return this.backing.get(key);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V value = this.get(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public K getKey(V value) {
        return (K)this.backing.inverse().get(value);
    }

    @Override
    public BiMap<K, V> getForwardMap() {
        return this.backing;
    }

    @Override
    public BidirectionalOneToOneHashMap<V, K> getInverseOneToOneMap() {
        return new BidirectionalOneToOneHashMap<V, K>(this.backing.inverse());
    }

    @Override
    public boolean hasExplicitRepresentativeKey(V value) {
        assert (this.containsValue((Object)value));
        return true;
    }

    @Override
    public K getRepresentativeKey(V value) {
        return this.getKey(value);
    }

    @Override
    public V getRepresentativeValue(K key) {
        return this.get(key);
    }

    @Override
    public Set<K> getKeys(V value) {
        if (this.containsValue((Object)value)) {
            return Collections.singleton(this.getRepresentativeKey(value));
        }
        return Collections.emptySet();
    }

    @Override
    public Set<V> getValues(K key) {
        if (this.containsKey((Object)key)) {
            return Collections.singleton(this.getRepresentativeValue(key));
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.backing.keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.backing.forcePut(key, value);
    }

    @Override
    public void putAll(BidirectionalManyToManyMap<K, V> map) {
        map.forEach(this::put);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.backing.putAll(map);
    }

    @Override
    public V remove(Object key) {
        return this.backing.remove(key);
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public Set<V> values() {
        return this.backing.values();
    }
}

