/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.collections;

import com.android.tools.r8.graph.DexClassAndMember;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.utils.SetUtils;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class DexClassAndMethodSetBase<T extends DexClassAndMethod>
implements Iterable<T> {
    protected final Map<DexMethod, T> backing;
    protected final Supplier<? extends Map<DexMethod, T>> backingFactory;

    protected DexClassAndMethodSetBase(Supplier<? extends Map<DexMethod, T>> backingFactory) {
        this(backingFactory, backingFactory.get());
    }

    protected DexClassAndMethodSetBase(Supplier<? extends Map<DexMethod, T>> backingFactory, Map<DexMethod, T> backing) {
        this.backing = backing;
        this.backingFactory = backingFactory;
    }

    public boolean add(T method) {
        DexClassAndMethod existing = (DexClassAndMethod)this.backing.put((DexMethod)((DexClassAndMember)method).getReference(), method);
        assert (existing == null || existing.isStructurallyEqualTo((DexClassAndMethod)method));
        return existing == null;
    }

    public void addAll(Iterable<T> methods) {
        methods.forEach(this::add);
    }

    public T get(DexMethod method) {
        return (T)((DexClassAndMethod)this.backing.get(method));
    }

    public T getFirst() {
        return (T)((DexClassAndMethod)this.iterator().next());
    }

    public boolean contains(DexMethod method) {
        return this.backing.containsKey(method);
    }

    public boolean contains(DexEncodedMethod method) {
        return this.backing.containsKey(method.getReference());
    }

    public boolean contains(T method) {
        return this.backing.containsKey(((DexClassAndMember)method).getReference());
    }

    public void clear() {
        this.backing.clear();
    }

    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.backing.values().iterator();
    }

    public boolean remove(DexMethod method) {
        DexClassAndMethod existing = (DexClassAndMethod)this.backing.remove(method);
        return existing != null;
    }

    public boolean remove(DexEncodedMethod method) {
        return this.remove((DexMethod)method.getReference());
    }

    public boolean removeIf(Predicate<? super T> predicate) {
        return this.backing.values().removeIf(predicate);
    }

    public int size() {
        return this.backing.size();
    }

    public Stream<T> stream() {
        return this.backing.values().stream();
    }

    public Collection<T> toCollection() {
        return this.backing.values();
    }

    public Set<DexEncodedMethod> toDefinitionSet() {
        assert (this.backing instanceof IdentityHashMap);
        return this.toDefinitionSet(SetUtils::newIdentityHashSet);
    }

    public Set<DexEncodedMethod> toDefinitionSet(IntFunction<Set<DexEncodedMethod>> factory) {
        Set<DexEncodedMethod> definitions = factory.apply(this.size());
        this.forEach(method -> definitions.add((DexEncodedMethod)method.getDefinition()));
        return definitions;
    }
}

