/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.collections;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;

public class DexMethodSignatureSet
implements Collection<DexMethodSignature> {
    private static final DexMethodSignatureSet EMPTY = new DexMethodSignatureSet(Collections.emptySet());
    private final Set<DexMethodSignature> backing;

    private DexMethodSignatureSet(Set<DexMethodSignature> backing) {
        this.backing = backing;
    }

    public static DexMethodSignatureSet create() {
        return new DexMethodSignatureSet(new HashSet<DexMethodSignature>());
    }

    public static DexMethodSignatureSet create(DexMethodSignatureSet collection) {
        return new DexMethodSignatureSet(new HashSet<DexMethodSignature>(collection.backing));
    }

    public static DexMethodSignatureSet createConcurrent() {
        return new DexMethodSignatureSet(Sets.newConcurrentHashSet());
    }

    public static DexMethodSignatureSet createLinked() {
        return new DexMethodSignatureSet(new LinkedHashSet<DexMethodSignature>());
    }

    public static DexMethodSignatureSet empty() {
        return EMPTY;
    }

    @Override
    public boolean add(DexMethodSignature signature) {
        return this.backing.add(signature);
    }

    @Override
    public boolean add(DexMethod method) {
        return this.add(method.getSignature());
    }

    @Override
    public boolean add(DexEncodedMethod method) {
        return this.add((DexMethod)method.getReference());
    }

    @Override
    public boolean add(DexClassAndMethod method) {
        return this.add((DexMethod)method.getReference());
    }

    @Override
    public boolean addAll(Collection<? extends DexMethodSignature> collection) {
        return this.backing.addAll(collection);
    }

    public void addAllMethods(Iterable<DexEncodedMethod> methods) {
        methods.forEach(this::add);
    }

    public void addAll(DexMethodSignatureSet signatures) {
        this.addAll((Collection<? extends DexMethodSignature>)signatures.backing);
    }

    public <T> void addAll(Iterable<T> elements, Function<T, Iterable<DexMethodSignature>> fn) {
        for (T element : elements) {
            Iterables.addAll(this, fn.apply(element));
        }
    }

    @Override
    public void clear() {
        this.backing.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.backing.contains(o);
    }

    public boolean contains(DexMethodSignature signature) {
        return this.backing.contains(signature);
    }

    public boolean contains(DexMethod method) {
        return this.contains(method.getSignature());
    }

    public boolean contains(DexEncodedMethod method) {
        return this.contains(method.getSignature());
    }

    public boolean contains(DexClassAndMethod method) {
        return this.contains(method.getMethodSignature());
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.backing.containsAll(collection);
    }

    public boolean containsAnyOf(Iterable<DexMethodSignature> signatures) {
        for (DexMethodSignature signature : signatures) {
            if (!this.contains(signature)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public Iterator<DexMethodSignature> iterator() {
        return this.backing.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.backing.remove(o);
    }

    public boolean remove(DexMethodSignature signature) {
        return this.backing.remove(signature);
    }

    public boolean remove(DexEncodedMethod method) {
        return this.remove(method.getSignature());
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.backing.removeAll(collection);
    }

    public void removeAllMethods(Iterable<DexEncodedMethod> methods) {
        methods.forEach(this::remove);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.backing.retainAll(collection);
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public Object[] toArray() {
        return this.backing.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.backing.toArray(ts);
    }
}

