/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.collections;

import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.ProgramDerivedContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class IdentityHashSetFromMap<K, V>
implements Set<V> {
    private final Map<K, V> backing = new IdentityHashMap();
    private final Function<V, K> valueToKeyMapping;

    public IdentityHashSetFromMap(Function<V, K> valueToKeyMapping) {
        this.valueToKeyMapping = valueToKeyMapping;
    }

    public static Set<ProgramDerivedContext> newProgramDerivedContextSet() {
        return new IdentityHashSetFromMap<DexReference, ProgramDerivedContext>(context -> context.getContext().getReference());
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.backing.containsKey(this.valueToKeyMapping.apply(o));
    }

    @Override
    public Iterator<V> iterator() {
        return this.backing.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.backing.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.backing.values().toArray(ts);
    }

    @Override
    public boolean add(V v) {
        return this.backing.put(this.valueToKeyMapping.apply(v), v) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.backing.remove(this.valueToKeyMapping.apply(o)) != null;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.backing.values().containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends V> collection) {
        boolean changed = false;
        for (V element : collection) {
            changed |= this.add(element);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        ArrayList found = new ArrayList(collection.size());
        for (Object element : collection) {
            if (!this.contains(element)) continue;
            found.add(element);
        }
        if (found.size() < this.size()) {
            this.clear();
            this.addAll(found);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        for (Object element : collection) {
            changed |= this.remove(element);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.backing.clear();
    }
}

