/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.collections;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;

public class LongLivedProgramMethodSetBuilder<T extends ProgramMethodSet> {
    private final IntFunction<T> factory;
    private final IntFunction<Set<DexMethod>> factoryForBuilder;
    private GraphLens appliedGraphLens;
    private Set<DexMethod> methods;

    private LongLivedProgramMethodSetBuilder(GraphLens currentGraphLens, IntFunction<T> factory, IntFunction<Set<DexMethod>> factoryBuilder) {
        this.appliedGraphLens = currentGraphLens;
        this.factory = factory;
        this.factoryForBuilder = factoryBuilder;
        this.methods = factoryBuilder.apply(2);
    }

    public static LongLivedProgramMethodSetBuilder<ProgramMethodSet> createForIdentitySet(GraphLens currentGraphLens) {
        return new LongLivedProgramMethodSetBuilder<ProgramMethodSet>(currentGraphLens, ProgramMethodSet::create, SetUtils::newIdentityHashSet);
    }

    public static LongLivedProgramMethodSetBuilder<ProgramMethodSet> createConcurrentForIdentitySet(GraphLens currentGraphLens) {
        return new LongLivedProgramMethodSetBuilder<ProgramMethodSet>(currentGraphLens, ProgramMethodSet::create, SetUtils::newConcurrentHashSet);
    }

    @Deprecated
    public void add(ProgramMethod method) {
        this.methods.add((DexMethod)method.getReference());
    }

    public void add(ProgramMethod method, GraphLens currentGraphLens) {
        assert (this.verifyIsRewrittenWithLens(currentGraphLens));
        this.methods.add((DexMethod)method.getReference());
    }

    public void addAll(Iterable<ProgramMethod> methodsToAdd, GraphLens currentGraphLens) {
        assert (this.verifyIsRewrittenWithLens(currentGraphLens));
        methodsToAdd.forEach(method -> this.add((ProgramMethod)method, currentGraphLens));
    }

    public void clear() {
        this.methods.clear();
    }

    public boolean contains(ProgramMethod method, GraphLens currentGraphLens) {
        assert (this.verifyIsRewrittenWithLens(currentGraphLens));
        return this.methods.contains(method.getReference());
    }

    public boolean isRewrittenWithLens(GraphLens graphLens) {
        return this.appliedGraphLens == graphLens;
    }

    public LongLivedProgramMethodSetBuilder<T> merge(LongLivedProgramMethodSetBuilder<T> builder) {
        if (this.isRewrittenWithLens(builder.appliedGraphLens)) {
            this.methods.addAll(builder.methods);
        } else {
            assert (this.verifyIsRewrittenWithNewerLens(builder.appliedGraphLens));
            for (DexMethod method : builder.methods) {
                this.methods.add(this.appliedGraphLens.getRenamedMethodSignature(method, builder.appliedGraphLens));
            }
        }
        return this;
    }

    @Deprecated
    public void remove(DexMethod method) {
        this.methods.remove(method);
    }

    public void remove(DexMethod method, GraphLens currentGraphLens) {
        assert (this.isEmpty() || this.verifyIsRewrittenWithLens(currentGraphLens));
        this.methods.remove(method);
    }

    public LongLivedProgramMethodSetBuilder<T> removeAll(Iterable<DexMethod> methods) {
        methods.forEach(this::remove);
        return this;
    }

    public LongLivedProgramMethodSetBuilder<T> removeIf(DexDefinitionSupplier definitions, Predicate<ProgramMethod> predicate) {
        this.methods.removeIf(method -> {
            DexProgramClass holder = DexProgramClass.asProgramClassOrNull(definitions.definitionFor(method.getHolderType()));
            ProgramMethod definition = method.lookupOnProgramClass(holder);
            if (definition == null) {
                assert (false);
                return true;
            }
            return predicate.test(definition);
        });
        return this;
    }

    public LongLivedProgramMethodSetBuilder<T> rewrittenWithLens(AppView<AppInfoWithLiveness> appView) {
        return this.rewrittenWithLens(appView.graphLens());
    }

    public LongLivedProgramMethodSetBuilder<T> rewrittenWithLens(GraphLens newGraphLens) {
        if (newGraphLens == this.appliedGraphLens) {
            return this;
        }
        Set<DexMethod> newMethods = this.factoryForBuilder.apply(this.methods.size());
        for (DexMethod method : this.methods) {
            newMethods.add(newGraphLens.getRenamedMethodSignature(method, this.appliedGraphLens));
        }
        this.methods = newMethods;
        this.appliedGraphLens = newGraphLens;
        return this;
    }

    public T build(AppView<AppInfoWithLiveness> appView) {
        ProgramMethodSet result = (ProgramMethodSet)this.factory.apply(this.methods.size());
        for (DexMethod method : this.methods) {
            DexMethod rewrittenMethod = appView.graphLens().getRenamedMethodSignature(method, this.appliedGraphLens);
            DexProgramClass holder = appView.definitionForHolder(rewrittenMethod).asProgramClass();
            result.createAndAdd(holder, holder.lookupMethod(rewrittenMethod));
        }
        return (T)result;
    }

    public boolean isEmpty() {
        return this.methods.isEmpty();
    }

    public boolean verifyIsRewrittenWithLens(GraphLens graphLens) {
        assert (this.isRewrittenWithLens(graphLens));
        return true;
    }

    public boolean verifyIsRewrittenWithNewerLens(GraphLens graphLens) {
        assert (this.appliedGraphLens != graphLens);
        assert (this.appliedGraphLens.isNonIdentityLens());
        assert (graphLens.isIdentityLens() || this.appliedGraphLens.asNonIdentityLens().findPrevious(previous -> previous == graphLens) != null);
        return true;
    }
}

