/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.dfs;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.utils.dfs.DFSWorklistItem;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Set;

public class DFSStack<T> {
    private final Deque<T> stack;
    private final Set<T> stackSet;

    private DFSStack(Deque<T> stack, Set<T> stackSet) {
        this.stack = stack;
        this.stackSet = stackSet;
    }

    public static <T> DFSStack<T> createIdentityStack() {
        return new DFSStack(new ArrayDeque(), Sets.newIdentityHashSet());
    }

    private void recoverStack(Deque<T> extractedCycle) {
        Iterator<T> descendingIt = extractedCycle.descendingIterator();
        while (descendingIt.hasNext()) {
            this.stack.addLast(descendingIt.next());
        }
    }

    public boolean contains(T item) {
        return this.stackSet.contains(item);
    }

    public Deque<T> getCycleStartingAt(T entry) {
        ArrayDeque<T> cycle = new ArrayDeque<T>();
        do {
            assert (!this.stack.isEmpty());
            cycle.addLast(this.stack.removeLast());
        } while (cycle.getLast() != entry);
        this.recoverStack(cycle);
        return cycle;
    }

    public void handle(DFSWorklistItem<T> item) {
        if (item.isNewlyVisited()) {
            this.push(item.getValue());
        } else {
            assert (item.isFullyVisited());
            this.pop(item.getValue());
        }
    }

    public void pop(T expectedItem) {
        T popped = this.stack.removeLast();
        assert (popped == expectedItem);
        boolean removed = this.stackSet.remove(popped);
        assert (removed);
    }

    public void push(T item) {
        this.stack.addLast(item);
        boolean added = this.stackSet.add(item);
        assert (added);
    }
}

