/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.structural;

import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.structural.HasherWrapper;
import com.android.tools.r8.utils.structural.HashingVisitor;
import com.android.tools.r8.utils.structural.RepresentativeMap;
import com.android.tools.r8.utils.structural.StructuralItem;
import com.android.tools.r8.utils.structural.StructuralMapping;
import com.android.tools.r8.utils.structural.StructuralSpecification;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class HashingVisitorWithTypeEquivalence
extends HashingVisitor {
    private final HasherWrapper hash;
    private final RepresentativeMap representatives;

    public static <T> void run(T item, HasherWrapper hasher, RepresentativeMap map, StructuralMapping<T> accept) {
        HashingVisitorWithTypeEquivalence.run(item, hasher, map, (T i, HashingVisitor visitor) -> visitor.visit(i, accept));
    }

    public static <T> void run(T item, HasherWrapper hasher, RepresentativeMap map, StructuralItem.HashingAccept<T> hashingAccept) {
        hashingAccept.acceptHashing(item, new HashingVisitorWithTypeEquivalence(hasher, map));
    }

    private HashingVisitorWithTypeEquivalence(HasherWrapper hash, RepresentativeMap representatives) {
        this.hash = hash;
        this.representatives = representatives;
    }

    @Override
    public void visitBool(boolean value) {
        this.hash.putBoolean(value);
    }

    @Override
    public void visitInt(int value) {
        this.hash.putInt(value);
    }

    @Override
    public void visitFloat(float value) {
        this.hash.putFloat(value);
    }

    @Override
    public void visitLong(long value) {
        this.hash.putLong(value);
    }

    @Override
    public void visitDouble(double value) {
        this.hash.putDouble(value);
    }

    @Override
    public void visitDexString(DexString string) {
        this.hash.putBytes(string.content);
    }

    @Override
    public void visitDexType(DexType type) {
        this.visitDexString(this.representatives.getRepresentative(type).getDescriptor());
    }

    @Override
    public <S> void visit(S item, StructuralMapping<S> accept) {
        accept.apply(new ItemSpecification(item, this));
    }

    @Override
    protected <S> void visitItemIterator(Iterator<S> it, StructuralItem.HashingAccept<S> hashingAccept) {
        while (it.hasNext()) {
            hashingAccept.acceptHashing(it.next(), this);
        }
    }

    private static class ItemSpecification<T>
    extends StructuralSpecification<T, ItemSpecification<T>> {
        private final HashingVisitorWithTypeEquivalence parent;
        private final T item;

        private ItemSpecification(T item, HashingVisitorWithTypeEquivalence parent) {
            this.item = item;
            this.parent = parent;
        }

        @Override
        ItemSpecification<T> self() {
            return this;
        }

        @Override
        public ItemSpecification<T> withAssert(Predicate<T> predicate) {
            assert (predicate.test(this.item));
            return this;
        }

        @Override
        public ItemSpecification<T> withBool(Predicate<T> getter) {
            this.parent.visitBool(getter.test(this.item));
            return this;
        }

        @Override
        public ItemSpecification<T> withInt(ToIntFunction<T> getter) {
            this.parent.visitInt(getter.applyAsInt(this.item));
            return this;
        }

        @Override
        public ItemSpecification<T> withLong(ToLongFunction<T> getter) {
            this.parent.visitLong(getter.applyAsLong(this.item));
            return this;
        }

        @Override
        public ItemSpecification<T> withDouble(ToDoubleFunction<T> getter) {
            this.parent.visitDouble(getter.applyAsDouble(this.item));
            return this;
        }

        @Override
        public ItemSpecification<T> withIntArray(Function<T, int[]> getter) {
            int[] ints = getter.apply(this.item);
            for (int i = 0; i < ints.length; ++i) {
                this.parent.visitInt(ints[i]);
            }
            return this;
        }

        @Override
        public ItemSpecification<T> withShortArray(Function<T, short[]> getter) {
            short[] ints = getter.apply(this.item);
            for (int i = 0; i < ints.length; ++i) {
                this.parent.visitInt(ints[i]);
            }
            return this;
        }

        @Override
        protected <S> ItemSpecification<T> withConditionalCustomItem(Predicate<T> predicate, Function<T, S> getter, StructuralItem.CompareToAccept<S> compare, StructuralItem.HashingAccept<S> hasher) {
            boolean test = predicate.test(this.item);
            this.parent.visitBool(test);
            if (test) {
                hasher.acceptHashing(getter.apply(this.item), this.parent);
            }
            return this;
        }

        @Override
        protected <S> ItemSpecification<T> withCustomItemIterator(Function<T, Iterator<S>> getter, StructuralItem.CompareToAccept<S> compare, StructuralItem.HashingAccept<S> hasher) {
            this.parent.visitItemIterator(getter.apply(this.item), hasher);
            return this;
        }

        @Override
        public ItemSpecification<T> withDexReference(Function<T, DexReference> getter) {
            this.parent.visitDexReference(getter.apply(this.item));
            return this;
        }
    }
}

