/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.structural;

import com.android.tools.r8.utils.structural.Equatable;

public interface Ordered<T>
extends Equatable<T>,
Comparable<T> {
    public static <T extends Ordered<T>> T min(T o1, T o2) {
        return o1.isLessThan(o2) ? o1 : o2;
    }

    public static <T extends Ordered<T>> T max(T o1, T o2) {
        return o1.isLessThan(o2) ? o2 : o1;
    }

    public static <T extends Ordered<T>> T minIgnoreNull(T o1, T o2) {
        if (o1 == null) {
            return o2;
        }
        if (o2 == null) {
            return o1;
        }
        return Ordered.min(o1, o2);
    }

    public static <T extends Ordered<T>> T maxIgnoreNull(T o1, T o2) {
        if (o1 == null) {
            return o2;
        }
        if (o2 == null) {
            return o1;
        }
        return o1.isLessThan(o2) ? o2 : o1;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    @Override
    public int compareTo(T var1);

    @Override
    default public boolean isEqualTo(T other) {
        if (!1.$assertionsDisabled && other == null) {
            throw new AssertionError();
        }
        return this == other || this.compareTo(other) == 0;
    }

    default public boolean isLessThan(T other) {
        return this.compareTo(other) < 0;
    }

    default public boolean isLessThanOrEqualTo(T other) {
        return this.compareTo(other) <= 0;
    }

    default public boolean isGreaterThan(T other) {
        return this.compareTo(other) > 0;
    }

    default public boolean isGreaterThanOrEqualTo(T other) {
        return this.compareTo(other) >= 0;
    }

    default public boolean betweenBothIncluded(T lower, T upper) {
        return this.isGreaterThanOrEqualTo(lower) && this.isLessThanOrEqualTo(upper);
    }
}

