/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils.structural;

import com.android.tools.r8.utils.structural.CompareToVisitor;
import com.android.tools.r8.utils.structural.CompareToVisitorWithTypeEquivalence;
import com.android.tools.r8.utils.structural.DefaultCompareToVisitor;
import com.android.tools.r8.utils.structural.DefaultHashingVisitor;
import com.android.tools.r8.utils.structural.HasherWrapper;
import com.android.tools.r8.utils.structural.HashingVisitor;
import com.android.tools.r8.utils.structural.HashingVisitorWithTypeEquivalence;
import com.android.tools.r8.utils.structural.Ordered;
import com.android.tools.r8.utils.structural.RepresentativeMap;
import com.android.tools.r8.utils.structural.StructuralMapping;

public interface StructuralItem<T extends StructuralItem<T>>
extends Ordered<T> {
    public T self();

    public StructuralMapping<T> getStructuralMapping();

    @Override
    default public int compareTo(T other) {
        return DefaultCompareToVisitor.run(this.self(), other, StructuralItem::acceptCompareTo);
    }

    default public int compareWithTypeEquivalenceTo(T other, RepresentativeMap map) {
        return CompareToVisitorWithTypeEquivalence.run(this.self(), other, map, StructuralItem::acceptCompareTo);
    }

    default public int acceptCompareTo(T other, CompareToVisitor visitor) {
        return visitor.visit(this.self(), other, this.self().getStructuralMapping());
    }

    default public void hash(HasherWrapper hasher) {
        DefaultHashingVisitor.run(this.self(), hasher, StructuralItem::acceptHashing);
    }

    default public void hashWithTypeEquivalence(HasherWrapper hasher, RepresentativeMap map) {
        HashingVisitorWithTypeEquivalence.run(this.self(), hasher, map, StructuralItem::acceptHashing);
    }

    default public void acceptHashing(HashingVisitor visitor) {
        visitor.visit(this.self(), this.self().getStructuralMapping());
    }

    @FunctionalInterface
    public static interface HashingAccept<T> {
        public void acceptHashing(T var1, HashingVisitor var2);
    }

    @FunctionalInterface
    public static interface CompareToAccept<T> {
        public int acceptCompareTo(T var1, T var2, CompareToVisitor var3);
    }
}

