/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.verticalclassmerging;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.FieldPut;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.verticalclassmerging.InterfaceTypeToClassTypeLensCodeRewriterHelper;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Map;

public class InterfaceTypeToClassTypeLensCodeRewriterHelperImpl
extends InterfaceTypeToClassTypeLensCodeRewriterHelper {
    private final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final IRCode code;
    private final Map<Instruction, Deque<WorklistItem>> worklist = new IdentityHashMap<Instruction, Deque<WorklistItem>>();

    public InterfaceTypeToClassTypeLensCodeRewriterHelperImpl(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code) {
        this.appView = appView;
        this.code = code;
    }

    private void addWorklistItem(Instruction rewrittenInstruction, int operandIndex, DexType originalType, DexType rewrittenType) {
        ((Deque)this.worklist.computeIfAbsent(rewrittenInstruction, MapUtils.ignoreKey(ArrayDeque::new))).addLast(new WorklistItem(operandIndex, originalType, rewrittenType));
    }

    private InstructionListIterator insertCastForOperand(Value operand, DexType castType, Instruction rewrittenUser, BasicBlockIterator blockIterator, BasicBlock block, InstructionListIterator instructionIterator) {
        Instruction previous = (Instruction)instructionIterator.previous();
        assert (previous == rewrittenUser);
        CheckCast checkCast = ((CheckCast.Builder)((CheckCast.Builder)CheckCast.builder().setCastType(castType).setObject(operand).setFreshOutValue(this.code, castType.toTypeElement(this.appView, operand.getType().nullability()), operand.getLocalInfo())).setPosition(rewrittenUser)).build();
        if (block.hasCatchHandlers()) {
            BasicBlock splitBlock = instructionIterator.splitCopyCatchHandlers(this.code, blockIterator, this.appView.options());
            instructionIterator.previous();
            instructionIterator.add(checkCast);
            instructionIterator = splitBlock.listIterator(this.code);
        } else {
            instructionIterator.add(checkCast);
        }
        rewrittenUser.replaceValue(operand, checkCast.outValue());
        Instruction next = (Instruction)instructionIterator.next();
        assert (next == rewrittenUser);
        return instructionIterator;
    }

    private boolean isOperandRewrittenWithLens(Value operand, BasicBlock blockWithUser, boolean isCodeFullyRewrittenWithLens) {
        if (isCodeFullyRewrittenWithLens) {
            return true;
        }
        if (operand.isPhi()) {
            return false;
        }
        Instruction definition = operand.getDefinition();
        return definition.isArgument() || operand.getBlock() == blockWithUser;
    }

    private OptionalBool needsCastForOperand(Value operand, BasicBlock blockWithUser, DexType originalType, DexType rewrittenType) {
        return this.needsCastForOperand(operand, blockWithUser, originalType, rewrittenType, false);
    }

    private OptionalBool needsCastForOperand(Value operand, BasicBlock blockWithUser, DexType originalType, DexType rewrittenType, boolean isCodeFullyRewrittenWithLens) {
        if (!originalType.isClassType() || !rewrittenType.isClassType()) {
            return OptionalBool.FALSE;
        }
        DexProgramClass originalClass = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(originalType));
        if (originalClass == null || !originalClass.isInterface()) {
            return OptionalBool.FALSE;
        }
        DexProgramClass rewrittenClass = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(rewrittenType));
        if (rewrittenClass == null || rewrittenClass.isInterface()) {
            return OptionalBool.FALSE;
        }
        if (!this.isOperandRewrittenWithLens(operand, blockWithUser, isCodeFullyRewrittenWithLens)) {
            assert (!isCodeFullyRewrittenWithLens);
            return OptionalBool.UNKNOWN;
        }
        TypeElement rewrittenTypeElement = rewrittenType.toTypeElement(this.appView);
        return OptionalBool.of(!operand.getType().lessThanOrEqualUpToNullability(rewrittenTypeElement, this.appView));
    }

    @Override
    public void insertCastsForOperandsIfNeeded(InvokeMethod originalInvoke, InvokeMethod rewrittenInvoke, GraphLens.MethodLookupResult lookupResult, BasicBlockIterator blockIterator, BasicBlock block, InstructionListIterator instructionIterator) {
        DexMethod originalInvokedMethod = originalInvoke.getInvokedMethod();
        DexMethod rewrittenInvokedMethod = rewrittenInvoke.getInvokedMethod();
        if (lookupResult.getPrototypeChanges().getArgumentInfoCollection().hasRemovedArguments()) {
            assert (false);
            return;
        }
        if (originalInvoke.arguments().size() != originalInvokedMethod.getNumberOfArguments(originalInvoke.isInvokeStatic())) {
            return;
        }
        for (int operandIndex = 0; operandIndex < originalInvoke.arguments().size(); ++operandIndex) {
            DexType rewrittenType;
            DexType originalType;
            Value operand = rewrittenInvoke.getArgument(operandIndex);
            if (!this.needsCastForOperand(operand, block, originalType = originalInvokedMethod.getArgumentType(operandIndex, originalInvoke.isInvokeStatic()), rewrittenType = rewrittenInvokedMethod.getArgumentType(operandIndex, rewrittenInvoke.isInvokeStatic())).isPossiblyTrue()) continue;
            this.addWorklistItem(rewrittenInvoke, operandIndex, originalType, rewrittenType);
        }
    }

    @Override
    public void insertCastsForOperandsIfNeeded(Return rewrittenReturn, BasicBlockIterator blockIterator, BasicBlock block, InstructionListIterator instructionIterator) {
        assert (!rewrittenReturn.isReturnVoid());
        DexMethod originalMethodSignature = this.appView.graphLens().getOriginalMethodSignature((DexMethod)this.code.context().getReference());
        DexType originalReturnType = originalMethodSignature.getReturnType();
        DexType rewrittenReturnType = this.code.context().getReturnType();
        if (this.needsCastForOperand(rewrittenReturn.returnValue(), block, originalReturnType, rewrittenReturnType).isPossiblyTrue()) {
            this.addWorklistItem(rewrittenReturn, 0, originalReturnType, rewrittenReturnType);
        }
    }

    @Override
    public void insertCastsForOperandsIfNeeded(FieldPut originalFieldPut, InvokeStatic rewrittenFieldPut, BasicBlockIterator blockIterator, BasicBlock block, InstructionListIterator instructionIterator) {
        DexType originalFieldType = originalFieldPut.getField().getType();
        int valueIndex = originalFieldPut.getValueIndex();
        DexType rewrittenFieldType = rewrittenFieldPut.getInvokedMethod().getParameter(valueIndex);
        Value operand = rewrittenFieldPut.getOperand(valueIndex);
        if (this.needsCastForOperand(operand, block, originalFieldType, rewrittenFieldType).isPossiblyTrue()) {
            this.addWorklistItem(rewrittenFieldPut, valueIndex, originalFieldType, rewrittenFieldType);
        }
    }

    @Override
    public void insertCastsForOperandsIfNeeded(FieldPut originalFieldPut, FieldPut rewrittenFieldPut, BasicBlockIterator blockIterator, BasicBlock block, InstructionListIterator instructionIterator) {
        DexType originalFieldType = originalFieldPut.getField().getType();
        DexType rewrittenFieldType = rewrittenFieldPut.getField().getType();
        if (this.needsCastForOperand(rewrittenFieldPut.value(), block, originalFieldType, rewrittenFieldType).isPossiblyTrue()) {
            this.addWorklistItem(rewrittenFieldPut.asFieldInstruction(), rewrittenFieldPut.getValueIndex(), originalFieldType, rewrittenFieldType);
        }
    }

    @Override
    public void processWorklist() {
        if (this.worklist.isEmpty()) {
            return;
        }
        BasicBlockIterator blockIterator = this.code.listIterator();
        boolean isCodeFullyRewrittenWithLens = true;
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            InstructionListIterator instructionIterator = block.listIterator(this.code);
            while (instructionIterator.hasNext()) {
                Instruction instruction = (Instruction)instructionIterator.next();
                Deque<WorklistItem> worklistItems = this.worklist.get(instruction);
                if (worklistItems == null) continue;
                for (WorklistItem worklistItem : worklistItems) {
                    Value operand = instruction.getOperand(worklistItem.operandIndex);
                    DexType originalType = worklistItem.originalType;
                    DexType rewrittenType = worklistItem.rewrittenType;
                    OptionalBool needsCastForOperand = this.needsCastForOperand(operand, block, originalType, rewrittenType, isCodeFullyRewrittenWithLens);
                    assert (!needsCastForOperand.isUnknown());
                    if (!needsCastForOperand.isTrue()) continue;
                    instructionIterator = this.insertCastForOperand(operand, rewrittenType, instruction, blockIterator, block, instructionIterator);
                }
            }
        }
    }

    private static class WorklistItem {
        final int operandIndex;
        final DexType originalType;
        final DexType rewrittenType;

        WorklistItem(int operandIndex, DexType originalType, DexType rewrittenType) {
            this.operandIndex = operandIndex;
            this.originalType = originalType;
            this.rewrittenType = rewrittenType;
        }
    }
}

