/*
 * Decompiled with CFR 0.152.
 */
package org.moe.samples.calculator.common;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.moe.samples.calculator.common.CalcOperations;
import org.moe.samples.calculator.common.CalcOpsTypes;

public class CalculatorAdapter {
    private boolean isFirst = true;
    private boolean isFractPart = false;
    private double a = 0.0;
    private double b = 0.0;
    private CalcOpsTypes type = CalcOpsTypes.NONE;
    private String showStr = "0";
    private long fractPart;
    private long numberOfNulls = 0L;

    public String sendNewSymbol(String symbol) {
        block36: {
            block38: {
                block37: {
                    block34: {
                        long fractNulls;
                        double digit;
                        block35: {
                            digit = this.isDigit(symbol);
                            if (Double.compare(digit, -1.0) == 0) break block34;
                            if (Double.compare(this.a, 0.0) == 0) {
                                this.type = CalcOpsTypes.NONE;
                            }
                            if (this.type != CalcOpsTypes.NONE && Double.compare(this.b, 0.0) == 0 && this.isFirst) {
                                this.isFirst = false;
                                this.numberOfNulls = 0L;
                            }
                            if (this.isFractPart) {
                                if (this.fractPart == 0L) {
                                    if ((int)digit != 0) {
                                        this.fractPart += (long)((int)digit);
                                    } else {
                                        ++this.numberOfNulls;
                                    }
                                } else {
                                    long prevFractPart = this.fractPart;
                                    this.fractPart = this.fractPart * 10L + (long)((int)digit);
                                    if (this.fractPart < 0L) {
                                        this.fractPart = prevFractPart;
                                    }
                                }
                            }
                            if (!this.isFirst) break block35;
                            if (!this.isFractPart) {
                                this.a = this.a * 10.0 + digit;
                            } else {
                                String fractStr = ".";
                                int i = 0;
                                while ((long)i < this.numberOfNulls) {
                                    fractStr = fractStr + "0";
                                    ++i;
                                }
                                boolean aLessZero = false;
                                if (this.a < 0.0) {
                                    aLessZero = true;
                                }
                                this.a = Double.parseDouble((int)this.a + fractStr + this.fractPart);
                                if (this.a > 0.0 && aLessZero) {
                                    this.a = -this.a;
                                }
                            }
                            this.showStr = String.valueOf(this.a);
                            if (this.fractPart == 0L && this.isFractPart) {
                                int i = 1;
                                while ((long)i < this.numberOfNulls) {
                                    this.showStr = this.showStr + "0";
                                    ++i;
                                }
                            }
                            if (this.fractPart == 0L) break block36;
                            fractNulls = 0L;
                            while (this.fractPart % (long)Math.pow(10.0, fractNulls + 1L) == 0L) {
                                this.showStr = this.showStr + "0";
                                ++fractNulls;
                            }
                            break block36;
                        }
                        if (!this.isFractPart) {
                            this.b = this.b * 10.0 + digit;
                        } else {
                            String fractStr = ".";
                            int i = 0;
                            while ((long)i < this.numberOfNulls) {
                                fractStr = fractStr + "0";
                                ++i;
                            }
                            this.b = Double.parseDouble((int)this.b + fractStr + this.fractPart);
                        }
                        this.showStr = String.valueOf(this.a) + this.opToString(this.type) + String.valueOf(this.b);
                        if (this.fractPart == 0L && this.isFractPart) {
                            int i = 1;
                            while ((long)i < this.numberOfNulls) {
                                this.showStr = this.showStr + "0";
                                ++i;
                            }
                        }
                        if (this.fractPart == 0L) break block36;
                        fractNulls = 0L;
                        while (this.fractPart % (long)Math.pow(10.0, fractNulls + 1L) == 0L) {
                            this.showStr = this.showStr + "0";
                            ++fractNulls;
                        }
                        break block36;
                    }
                    CalcOpsTypes opType = this.isCalcOperation(symbol);
                    if (opType == CalcOpsTypes.NONE) break block37;
                    if (Double.compare(this.a, 0.0) == 0) break block36;
                    if (Double.compare(this.b, 0.0) != 0) {
                        this.calculateAndPrepare(opType);
                    } else {
                        this.type = opType;
                        this.showStr = String.valueOf(this.a) + this.opToString(this.type) + "0";
                        this.fractPart = 0L;
                        this.isFractPart = false;
                    }
                    break block36;
                }
                if (!symbol.equals("=")) break block38;
                if (this.isFirst) break block36;
                this.calculateAndPrepare(CalcOpsTypes.NONE);
                break block36;
            }
            if (symbol.equals("C")) {
                this.fractPart = 0L;
                this.a = 0.0;
                this.b = 0.0;
                this.numberOfNulls = 0L;
                this.isFractPart = false;
                this.isFirst = true;
                this.showStr = "0";
            } else if (symbol.equals(".")) {
                if (!this.isFractPart) {
                    this.showStr = this.showStr + ".";
                }
                this.isFractPart = true;
            } else if (symbol.equals("INVERT") && this.isFirst) {
                this.a = -this.a;
                this.showStr = String.valueOf(this.a);
                if (this.fractPart == 0L && this.isFractPart) {
                    int i = 1;
                    while ((long)i < this.numberOfNulls) {
                        this.showStr = this.showStr + "0";
                        ++i;
                    }
                }
                if (this.fractPart != 0L) {
                    long fractNulls = 0L;
                    while (this.fractPart % (long)Math.pow(10.0, fractNulls + 1L) == 0L) {
                        this.showStr = this.showStr + "0";
                        ++fractNulls;
                    }
                }
            }
        }
        return this.showStr;
    }

    public double isDigit(String ss) {
        double digit = -1.0;
        try {
            digit = Double.parseDouble(ss);
        }
        catch (NumberFormatException nfe) {
            return digit;
        }
        return digit;
    }

    public CalcOpsTypes isCalcOperation(String ss) {
        CalcOpsTypes myType = CalcOpsTypes.NONE;
        if (ss.equals("+")) {
            myType = CalcOpsTypes.SUM;
        } else if (ss.equals("-")) {
            myType = CalcOpsTypes.DIFF;
        } else if (ss.equals("*")) {
            myType = CalcOpsTypes.MULT;
        } else if (ss.equals("/")) {
            myType = CalcOpsTypes.DIVIDE;
        }
        return myType;
    }

    public String opToString(CalcOpsTypes myType) {
        String ss = "";
        switch (myType) {
            case DIFF: {
                ss = "-";
                break;
            }
            case DIVIDE: {
                ss = "/";
                break;
            }
            case MULT: {
                ss = "*";
                break;
            }
            case NONE: {
                break;
            }
            case SUM: {
                ss = "+";
            }
        }
        return ss;
    }

    private void calculateAndPrepare(CalcOpsTypes afterOperation) {
        double result = CalcOperations.calculate(this.a, this.b, this.type);
        try {
            result = new BigDecimal(result).setScale(4, RoundingMode.HALF_UP).doubleValue();
            this.showStr = String.valueOf(result);
            switch (afterOperation) {
                case SUM: {
                    this.showStr = this.showStr + "+";
                    break;
                }
                case DIFF: {
                    this.showStr = this.showStr + "-";
                    break;
                }
                case DIVIDE: {
                    this.showStr = this.showStr + "/";
                    break;
                }
                case MULT: {
                    this.showStr = this.showStr + "*";
                    break;
                }
                case NONE: {
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            System.out.println("The result is NAN!");
            this.showStr = String.valueOf(result);
        }
        this.a = result;
        this.b = 0.0;
        this.numberOfNulls = 0L;
        this.isFirst = true;
        this.fractPart = (int)(Math.abs(this.a - (double)((int)this.a)) * Math.pow(10.0, String.valueOf(Math.abs(this.a)).length() - 2));
        this.type = afterOperation;
    }

    public String getShowStr() {
        return this.showStr;
    }
}

