/*
 * Decompiled with CFR 0.152.
 */
package org.moe.samples.calculator.ios.ui;

import apple.uikit.UIButton;
import apple.uikit.UIColor;
import apple.uikit.UILabel;
import apple.uikit.UIViewController;
import java.util.HashMap;
import java.util.Map;
import org.moe.natj.general.NatJ;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ann.Owned;
import org.moe.natj.general.ann.RegisterOnStartup;
import org.moe.natj.general.ann.Runtime;
import org.moe.natj.objc.ObjCRuntime;
import org.moe.natj.objc.SEL;
import org.moe.natj.objc.ann.IBAction;
import org.moe.natj.objc.ann.IBOutlet;
import org.moe.natj.objc.ann.ObjCClassName;
import org.moe.natj.objc.ann.Property;
import org.moe.natj.objc.ann.Selector;
import org.moe.samples.calculator.common.CalculatorAdapter;

@Runtime(value=ObjCRuntime.class)
@ObjCClassName(value="AppViewController")
@RegisterOnStartup
public class AppViewController
extends UIViewController {
    private CalculatorAdapter myCalculatorAdapter;
    private UILabel calcNum;
    private UIColor blue = UIColor.colorWithRedGreenBlueAlpha((double)0.0, (double)0.44313725490196076, (double)0.7294117647058823, (double)1.0);
    private UIColor darkBlue = UIColor.colorWithRedGreenBlueAlpha((double)0.0, (double)0.29411764705882354, (double)0.5529411764705883, (double)1.0);
    private UIColor orange = UIColor.colorWithRedGreenBlueAlpha((double)0.9921568627450981, (double)0.7215686274509804, (double)0.07450980392156863, (double)1.0);
    private final Map<UIButton, UIColor> defaultColorMap = new HashMap<UIButton, UIColor>();

    @Owned
    @Selector(value="alloc")
    public static native AppViewController alloc();

    @Selector(value="init")
    public native AppViewController init();

    protected AppViewController(Pointer peer) {
        super(peer);
    }

    @Selector(value="viewDidLoad")
    public void viewDidLoad() {
        super.viewDidLoad();
        this.myCalculatorAdapter = new CalculatorAdapter();
        this.calcNum = this.getDisplayLabel();
        this.registerButton(this.getButtonC(), this.blue);
        this.registerButton(this.getButtonSign(), this.blue);
        this.registerButton(this.getButtonPerc(), this.blue);
        this.registerButton(this.getButtonDiv(), this.darkBlue);
        this.registerButton(this.getButtonMul(), this.darkBlue);
        this.registerButton(this.getButtonSub(), this.darkBlue);
        this.registerButton(this.getButtonAdd(), this.darkBlue);
        this.registerButton(this.getButtonEq(), this.darkBlue);
        this.registerButton(this.getButtonComma(), this.blue);
        this.registerButton(this.getButton0(), this.blue);
        this.registerButton(this.getButton1(), this.blue);
        this.registerButton(this.getButton2(), this.blue);
        this.registerButton(this.getButton3(), this.blue);
        this.registerButton(this.getButton4(), this.blue);
        this.registerButton(this.getButton5(), this.blue);
        this.registerButton(this.getButton6(), this.blue);
        this.registerButton(this.getButton7(), this.blue);
        this.registerButton(this.getButton8(), this.blue);
        this.registerButton(this.getButton9(), this.blue);
    }

    private void registerButton(UIButton button, UIColor color) {
        this.defaultColorMap.put(button, color);
        button.setBackgroundColor(color);
        button.addTargetActionForControlEvents((Object)this, new SEL("setButtonActive:"), 1L);
        button.addTargetActionForControlEvents((Object)this, new SEL("setButtonInactive:"), 256L);
        button.addTargetActionForControlEvents((Object)this, new SEL("setButtonInactive:"), 64L);
        button.addTargetActionForControlEvents((Object)this, new SEL("setButtonInactive:"), 128L);
    }

    @IBAction
    @Selector(value="buttonCPressed:")
    public void buttonCPressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("C");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="buttonSignPressed:")
    public void buttonSignPressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("INVERT");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="buttonPercPressed:")
    public void buttonPercPressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("C");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="buttonDivPressed:")
    public void buttonDivPressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("/");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="buttonMulPressed:")
    public void buttonMulPressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("*");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="buttonSubPressed:")
    public void buttonSubPressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("-");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="buttonAddPressed:")
    public void buttonAddPressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("+");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="buttonEqPressed:")
    public void buttonEqPressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("=");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="buttonCommaPressed:")
    public void buttonCommaPressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol(".");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="button0Pressed:")
    public void button0Pressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("0");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="button1Pressed:")
    public void button1Pressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("1");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="button2Pressed:")
    public void button2Pressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("2");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="button3Pressed:")
    public void button3Pressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("3");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="button4Pressed:")
    public void button4Pressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("4");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="button5Pressed:")
    public void button5Pressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("5");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="button6Pressed:")
    public void button6Pressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("6");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="button7Pressed:")
    public void button7Pressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("7");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="button8Pressed:")
    public void button8Pressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("8");
        this.calcNum.setText(str);
    }

    @IBAction
    @Selector(value="button9Pressed:")
    public void button9Pressed(UIButton sender) {
        String str = this.myCalculatorAdapter.sendNewSymbol("9");
        this.calcNum.setText(str);
    }

    @Selector(value="setButtonActive:")
    public void setButtonActive(UIButton button) {
        button.setBackgroundColor(this.orange);
    }

    @Selector(value="setButtonInactive:")
    public void setButtonInactive(UIButton button) {
        UIColor color = this.defaultColorMap.get(button);
        button.setBackgroundColor(color == null ? this.blue : color);
    }

    @Selector(value="displayLabel")
    @Property
    @IBOutlet
    public native UILabel getDisplayLabel();

    @Selector(value="buttonC")
    @Property
    @IBOutlet
    public native UIButton getButtonC();

    @Selector(value="buttonSign")
    @Property
    @IBOutlet
    public native UIButton getButtonSign();

    @Selector(value="buttonPerc")
    @Property
    @IBOutlet
    public native UIButton getButtonPerc();

    @Selector(value="buttonDiv")
    @Property
    @IBOutlet
    public native UIButton getButtonDiv();

    @Selector(value="buttonMul")
    @Property
    @IBOutlet
    public native UIButton getButtonMul();

    @Selector(value="buttonSub")
    @Property
    @IBOutlet
    public native UIButton getButtonSub();

    @Selector(value="buttonAdd")
    @Property
    @IBOutlet
    public native UIButton getButtonAdd();

    @Selector(value="buttonEq")
    @Property
    @IBOutlet
    public native UIButton getButtonEq();

    @Selector(value="buttonComma")
    @Property
    @IBOutlet
    public native UIButton getButtonComma();

    @Selector(value="button0")
    @Property
    @IBOutlet
    public native UIButton getButton0();

    @Selector(value="button1")
    @Property
    @IBOutlet
    public native UIButton getButton1();

    @Selector(value="button2")
    @Property
    @IBOutlet
    public native UIButton getButton2();

    @Selector(value="button3")
    @Property
    @IBOutlet
    public native UIButton getButton3();

    @Selector(value="button4")
    @Property
    @IBOutlet
    public native UIButton getButton4();

    @Selector(value="button5")
    @Property
    @IBOutlet
    public native UIButton getButton5();

    @Selector(value="button6")
    @Property
    @IBOutlet
    public native UIButton getButton6();

    @Selector(value="button7")
    @Property
    @IBOutlet
    public native UIButton getButton7();

    @Selector(value="button8")
    @Property
    @IBOutlet
    public native UIButton getButton8();

    @Selector(value="button9")
    @Property
    @IBOutlet
    public native UIButton getButton9();

    static {
        NatJ.register();
    }
}

