/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.c;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.moe.natj.c.OpaquePtr;
import org.moe.natj.c.StructObject;
import org.moe.natj.c.map.CCallbackMapper;
import org.moe.natj.c.map.CObjectMapper;
import org.moe.natj.c.map.CStringMapper;
import org.moe.natj.general.NatJ;
import org.moe.natj.general.NativeObject;
import org.moe.natj.general.NativeRuntime;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ptr.ConstVoidPtr;
import org.moe.natj.general.ptr.VoidPtr;
import org.moe.natj.general.ptr.impl.PtrFactory;

public class CRuntime
extends NativeRuntime {
    public static final int POINTER_SIZE = CRuntime.sizeOfPointer();
    public static final int NATIVE_LONG_SIZE;
    public static final int NATIVE_WCHART_SIZE;
    public static final int BOOLEAN_SIZE = 1;
    public static final int CHAR_SIZE = 2;
    public static final int BYTE_SIZE = 1;
    public static final int SHORT_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int FLOAT_SIZE = 4;
    public static final int DOUBLE_SIZE = 8;
    private static Pointer.Releaser strongReleaser;

    @Override
    protected void doRegistration(Class<?> type) {
        this.registerClass(type);
    }

    private CRuntime() {
        super(CObjectMapper.class, CStringMapper.class, CCallbackMapper.class);
        CRuntime.initialize(this);
    }

    public static Pointer createStrongPointer(long peer, boolean owned) {
        return new Pointer(peer, owned ? strongReleaser : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void tryToDisposeCallback(Object callback) {
        CCallbackMapper.CallbackInfo[] callbackInfoArray;
        Object map;
        CCallbackMapper.CallbackInfo[] infos;
        Object cache = NatJ.getAndRemoveObjectCacheForRuntime(this.getClass(), callback);
        if (cache instanceof CCallbackMapper.CallbackInfo[]) {
            infos = (CCallbackMapper.CallbackInfo[])cache;
        } else {
            map = ((CCallbackMapper)this.callbackMapper).instance2callbacks;
            callbackInfoArray = map;
            // MONITORENTER : map
            infos = map.remove(callback);
            // MONITOREXIT : callbackInfoArray
        }
        if (infos == null) return;
        map = ((CCallbackMapper)this.callbackMapper).callback2extras;
        callbackInfoArray = infos;
        int n = callbackInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            CCallbackMapper.CallbackInfo info = callbackInfoArray[n2];
            if (info != null) {
                Object object = map;
                // MONITORENTER : object
                map.remove(info.callback.getPeer());
                // MONITOREXIT : object
                CRuntime.deallocNativeCallback(info.extra);
            }
            ++n2;
        }
    }

    public static <T extends OpaquePtr> T cast(ConstVoidPtr ptr, Class<T> cls) {
        NatJ.JavaObjectConstructionInfo toOpqquePtrInfo = NatJ.buildJavaObjectConstructionInfo(null, cls, null, null, null, false, false, false);
        return (T)((OpaquePtr)NatJ.toJava(ptr.getPeer().getPeer(), toOpqquePtrInfo));
    }

    public static VoidPtr cast(OpaquePtr ptr) {
        return PtrFactory.newWeakVoidPtr(ptr.getPeer().getPeer());
    }

    public static <T extends StructObject> T cast(StructObject obj, Class<T> cls) {
        try {
            Constructor<T> constructor = cls.getDeclaredConstructor(Pointer.class);
            constructor.setAccessible(true);
            return (T)((StructObject)constructor.newInstance(obj.getPeer()));
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not construct casted StructObject.", ex);
        }
    }

    @Override
    public byte getDefaultUnboxPolicy() {
        return 1;
    }

    private static native void initialize(CRuntime var0);

    private native void registerClass(Class<?> var1);

    public static native String createJavaString(long var0);

    public static native long createNativeString(String var0);

    private static native long malloc(long var0);

    public static native void free(long var0);

    public static native long createNativeStringArray(String[] var0);

    public static native long allocNativeObject(Class<? extends NativeObject> var0, int var1);

    public static native long sizeOfNativeObject(Class<? extends NativeObject> var0);

    public static native void copyNativeObject(Class<? extends NativeObject> var0, long var1, long var3);

    public static native <T extends NativeObject> long copyNativeObjectArray(T[] var0);

    public static native int sizeOfPointer();

    public static native int sizeOfLong();

    public static native int sizeOfWCharT();

    public static native long allocPointer(int var0);

    public static native void copyPointerArray(long var0, long[] var2);

    public static native long loadPointer(long var0, int var2);

    public static native void storePointer(long var0, int var2, long var3);

    public static native long allocNativeCallback(Object var0, Method var1, long[] var2);

    public static native void deallocNativeCallback(long var0);

    public static native Object createJavaCallback(long var0);

    public static native void memset(long var0, int var2, int var3, byte var4);

    public static void memset(VoidPtr ptr, int idx, int length, byte value) {
        CRuntime.memset(ptr.getPeer().getPeer(), idx, length, value);
    }

    public static native void memcpy(long var0, long var2, int var4);

    public static void memcpy(VoidPtr dst, ConstVoidPtr src, int length) {
        CRuntime.memcpy(dst.getPeer().getPeer(), src.getPeer().getPeer(), length);
    }

    public static native long allocBoolean(int var0);

    public static native void copyBooleanArray(long var0, int var2, boolean[] var3, int var4, int var5);

    public static native void copyFromNativeBooleanArray(boolean[] var0, int var1, long var2, int var4, int var5);

    public static native void copyNativeBooleanArray(long var0, int var2, long var3, int var5, int var6);

    public static native boolean loadBoolean(long var0, int var2);

    public static native void storeBoolean(long var0, int var2, boolean var3);

    public static native boolean[] createBooleanArray(long var0, int var2);

    public static native long getCharBufferPointer(CharBuffer var0);

    public static native long allocChar(int var0);

    public static native void copyCharArray(long var0, int var2, char[] var3, int var4, int var5);

    public static native void copyFromNativeCharArray(char[] var0, int var1, long var2, int var4, int var5);

    public static native void copyNativeCharArray(long var0, int var2, long var3, int var5, int var6);

    public static native char loadChar(long var0, int var2);

    public static native void storeChar(long var0, int var2, char var3);

    public static native char[] createCharArray(long var0, int var2);

    public static native long getByteBufferPointer(ByteBuffer var0);

    public static native long allocByte(int var0);

    public static native void copyByteArray(long var0, int var2, byte[] var3, int var4, int var5);

    public static native void copyFromNativeByteArray(byte[] var0, int var1, long var2, int var4, int var5);

    public static native void copyNativeByteArray(long var0, int var2, long var3, int var5, int var6);

    public static native byte loadByte(long var0, int var2);

    public static native void storeByte(long var0, int var2, byte var3);

    public static native byte[] createByteArray(long var0, int var2);

    public static native long getShortBufferPointer(ShortBuffer var0);

    public static native long allocShort(int var0);

    public static native void copyShortArray(long var0, int var2, short[] var3, int var4, int var5);

    public static native void copyFromNativeShortArray(short[] var0, int var1, long var2, int var4, int var5);

    public static native void copyNativeShortArray(long var0, int var2, long var3, int var5, int var6);

    public static native short loadShort(long var0, int var2);

    public static native void storeShort(long var0, int var2, short var3);

    public static native short[] createShortArray(long var0, int var2);

    public static native long getIntBufferPointer(IntBuffer var0);

    public static native long allocInt(int var0);

    public static native void copyIntArray(long var0, int var2, int[] var3, int var4, int var5);

    public static native void copyFromNativeIntArray(int[] var0, int var1, long var2, int var4, int var5);

    public static native void copyNativeIntArray(long var0, int var2, long var3, int var5, int var6);

    public static native int loadInt(long var0, int var2);

    public static native void storeInt(long var0, int var2, int var3);

    public static native int[] createIntArray(long var0, int var2);

    public static native long getLongBufferPointer(LongBuffer var0);

    public static native long allocLong(int var0);

    public static native void copyLongArray(long var0, int var2, long[] var3, int var4, int var5);

    public static native void copyFromNativeLongArray(long[] var0, int var1, long var2, int var4, int var5);

    public static native void copyNativeLongArray(long var0, int var2, long var3, int var5, int var6);

    public static native long loadLong(long var0, int var2);

    public static native void storeLong(long var0, int var2, long var3);

    public static native long[] createLongArray(long var0, int var2);

    public static native long getFloatBufferPointer(FloatBuffer var0);

    public static native long allocFloat(int var0);

    public static native void copyFloatArray(long var0, int var2, float[] var3, int var4, int var5);

    public static native void copyFromNativeFloatArray(float[] var0, int var1, long var2, int var4, int var5);

    public static native void copyNativeFloatArray(long var0, int var2, long var3, int var5, int var6);

    public static native float loadFloat(long var0, int var2);

    public static native void storeFloat(long var0, int var2, float var3);

    public static native float[] createFloatArray(long var0, int var2);

    public static native long getDoubleBufferPointer(DoubleBuffer var0);

    public static native long allocDouble(int var0);

    public static native void copyDoubleArray(long var0, int var2, double[] var3, int var4, int var5);

    public static native void copyFromNativeDoubleArray(double[] var0, int var1, long var2, int var4, int var5);

    public static native void copyNativeDoubleArray(long var0, int var2, long var3, int var5, int var6);

    public static native double loadDouble(long var0, int var2);

    public static native void storeDouble(long var0, int var2, double var3);

    public static native double[] createDoubleArray(long var0, int var2);

    static {
        NatJ.registerRuntime(CRuntime.class);
        NATIVE_LONG_SIZE = CRuntime.sizeOfLong();
        NATIVE_WCHART_SIZE = CRuntime.sizeOfWCharT();
        strongReleaser = new Pointer.Releaser(){

            @Override
            public void release(long peer) {
                CRuntime.free(peer);
            }

            @Override
            public boolean ifFinalizedExternally() {
                return false;
            }
        };
    }
}

