/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general;

public class Pointer {
    private long peer;
    private Releaser releaser;

    public Pointer(long peer, Releaser releaser) {
        if (peer == -1L) {
            throw new IllegalArgumentException();
        }
        this.peer = peer;
        this.releaser = releaser;
    }

    public Pointer(long peer) {
        if (peer == -1L) {
            throw new IllegalArgumentException();
        }
        this.peer = peer;
        this.releaser = null;
    }

    protected void finalize() {
        if (this.releaser != null && this.peer != 0L && !this.releaser.ifFinalizedExternally()) {
            this.releaser.release(this.peer);
        }
    }

    void release() {
        if (this.releaser != null && this.peer != 0L && this.releaser.ifFinalizedExternally()) {
            if (this.peer == -1L) {
                new RuntimeException("peer already released").printStackTrace();
            } else {
                this.releaser.release(this.peer);
                this.peer = -1L;
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Pointer) {
            return this.peer == ((Pointer)object).peer;
        }
        return false;
    }

    public long getPeer() {
        if (this.peer == -1L) {
            throw new IllegalStateException();
        }
        return this.peer;
    }

    public void setPeer(long peer) {
        if (peer == -1L) {
            throw new IllegalArgumentException();
        }
        if (this.peer == -1L) {
            throw new IllegalStateException();
        }
        this.peer = peer;
    }

    public boolean hasReleaser() {
        return this.releaser != null;
    }

    public static interface Releaser {
        public void release(long var1);

        public boolean ifFinalizedExternally();
    }
}

