/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import java.lang.reflect.Array;
import org.moe.natj.c.OpaquePtr;
import org.moe.natj.cxx.CxxObject;
import org.moe.natj.general.NativeObject;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ptr.Ptr;
import org.moe.natj.general.ptr.impl.VoidPtrImpl;

abstract class AbstractTypedPtr<T, E>
extends VoidPtrImpl
implements Ptr<E> {
    protected final Class<T> type;

    protected AbstractTypedPtr(Class<T> type, Pointer peer) {
        super(peer);
        this.type = type;
        AbstractTypedPtr.checkType(type);
    }

    protected AbstractTypedPtr(Class<T> type, long peer, boolean owned) {
        super(peer, owned, null);
        this.type = type;
        AbstractTypedPtr.checkType(type);
    }

    protected AbstractTypedPtr(Class<T> type, long peer, Object bufferOwner) {
        super(peer, false, bufferOwner);
        this.type = type;
        AbstractTypedPtr.checkType(type);
    }

    protected static final void checkType(Class<?> type) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (Void.class.isAssignableFrom(type)) {
            return;
        }
        if (NativeObject.class.isAssignableFrom(type)) {
            return;
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return;
        }
        if (Byte.class.isAssignableFrom(type)) {
            return;
        }
        if (Short.class.isAssignableFrom(type)) {
            return;
        }
        if (Character.class.isAssignableFrom(type)) {
            return;
        }
        if (Integer.class.isAssignableFrom(type)) {
            return;
        }
        if (Long.class.isAssignableFrom(type)) {
            return;
        }
        if (Float.class.isAssignableFrom(type)) {
            return;
        }
        if (Double.class.isAssignableFrom(type)) {
            return;
        }
        if (OpaquePtr.class.isAssignableFrom(type)) {
            return;
        }
        if (CxxObject.class.isAssignableFrom(type)) {
            return;
        }
        throw new IllegalArgumentException("unsupported class");
    }

    @Override
    public final E get() {
        return (E)this.get(0);
    }

    @Override
    public final E[] toArray(int length) {
        return this.toArray(0, length);
    }

    @Override
    public final E[] toArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        int length = toIndex - fromIndex;
        Object[] array = (Object[])Array.newInstance(this.type, length);
        this.copyTo(fromIndex, (E[])array, 0, length);
        return array;
    }

    @Override
    public final void copyTo(E[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    @Override
    public final void copyTo(E[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    @Override
    public void copyTo(int srcOffset, E[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        int idx = 0;
        while (idx < length) {
            dest[destOffset] = this.get(srcOffset);
            ++idx;
            ++srcOffset;
            ++destOffset;
        }
    }

    @Override
    public int getGuardLow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGuardHigh() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Ptr<E> getGuarded(int length) {
        return (Ptr)this.getGuarded(0, length);
    }

    @Override
    public void set(E obj) {
        this.set(0, obj);
    }

    @Override
    public void copyFrom(E[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    @Override
    public void copyFrom(E[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    @Override
    public void copyFrom(E[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    @Override
    public void copyFrom(E[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < length) {
            this.set(destOffset, src[srcOffset]);
            ++i;
            ++srcOffset;
            ++destOffset;
        }
    }
}

