/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.general.ptr.impl;

import org.moe.natj.c.CRuntime;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ptr.IGuardedPtr;
import org.moe.natj.general.ptr.NLongPtr;
import org.moe.natj.general.ptr.impl.VoidPtrImpl;

class NLongPtrImpl
extends VoidPtrImpl
implements NLongPtr {
    protected static final int ELEM_SIZE = CRuntime.NATIVE_LONG_SIZE;

    protected NLongPtrImpl(Pointer peer) {
        super(peer);
    }

    protected NLongPtrImpl(long peer, Object bufferOwner) {
        super(peer, false, bufferOwner);
    }

    NLongPtrImpl(int capacity, boolean owned) {
        super(ELEM_SIZE == 8 ? CRuntime.allocLong(capacity) : CRuntime.allocInt(capacity), owned, null);
    }

    @Override
    public boolean isConstPtr() {
        return false;
    }

    @Override
    public final Long get() {
        return this.getValue(0);
    }

    @Override
    public final Long get(int idx) {
        return this.getValue(idx);
    }

    @Override
    public final long getValue() {
        return this.getValue(0);
    }

    @Override
    public long getValue(int idx) {
        if (ELEM_SIZE == 8) {
            return CRuntime.loadLong(this.getRoot(), idx);
        }
        return CRuntime.loadInt(this.getRoot(), idx);
    }

    public final Long[] toArray(int length) {
        return this.toArray(0, length);
    }

    public Long[] toArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        int length = toIndex - fromIndex;
        Long[] array = new Long[length];
        this.copyTo(fromIndex, array, 0, length);
        return array;
    }

    @Override
    public final long[] toLongArray(int length) {
        return this.toLongArray(0, length);
    }

    @Override
    public long[] toLongArray(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        if (ELEM_SIZE == 8) {
            return CRuntime.createLongArray(this.getRoot() + (long)(fromIndex * ELEM_SIZE), toIndex - fromIndex);
        }
        int[] intArray = CRuntime.createIntArray(this.getRoot() + (long)(fromIndex * ELEM_SIZE), toIndex - fromIndex);
        long[] longArray = new long[intArray.length];
        for (int i = 0; i < intArray.length; ++i) {
            longArray[i] = intArray[i];
        }
        return longArray;
    }

    public final void copyTo(Long[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    public final void copyTo(Long[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    public void copyTo(int srcOffset, Long[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        if (ELEM_SIZE == 8) {
            int idx = 0;
            while (idx < length) {
                dest[destOffset] = CRuntime.loadLong(root, srcOffset);
                ++idx;
                ++srcOffset;
                ++destOffset;
            }
        } else {
            int idx = 0;
            while (idx < length) {
                dest[destOffset] = CRuntime.loadInt(root, srcOffset);
                ++idx;
                ++srcOffset;
                ++destOffset;
            }
        }
    }

    @Override
    public final void copyTo(long[] dest) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, dest.length);
    }

    @Override
    public final void copyTo(long[] dest, int length) {
        if (dest == null) {
            throw new IllegalArgumentException();
        }
        this.copyTo(0, dest, 0, length);
    }

    @Override
    public void copyTo(int srcOffset, long[] dest, int destOffset, int length) {
        if (dest == null || destOffset < 0 || length < 0 || destOffset + length > dest.length) {
            throw new IllegalArgumentException();
        }
        if (ELEM_SIZE == 8) {
            CRuntime.copyFromNativeLongArray(dest, destOffset, this.getRoot(), srcOffset, length);
        } else {
            long root = this.getRoot();
            int idx = 0;
            while (idx < length) {
                dest[destOffset] = CRuntime.loadInt(root, srcOffset);
                ++idx;
                ++srcOffset;
                ++destOffset;
            }
        }
    }

    @Override
    public void set(Long obj) {
        this.setValue(obj);
    }

    @Override
    public void set(int idx, Long obj) {
        this.setValue(idx, obj);
    }

    @Override
    public void setValue(long value) {
        this.setValue(0, value);
    }

    @Override
    public void setValue(int idx, long value) {
        if (ELEM_SIZE == 8) {
            CRuntime.storeLong(this.getRoot(), idx, value);
        } else {
            CRuntime.storeInt(this.getRoot(), idx, (int)value);
        }
    }

    public void copyFrom(Long[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    public void copyFrom(Long[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    public void copyFrom(Long[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    public void copyFrom(Long[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        long root = this.getRoot();
        if (ELEM_SIZE == 8) {
            int i = 0;
            while (i < length) {
                CRuntime.storeLong(root, destOffset, src[srcOffset]);
                ++i;
                ++srcOffset;
                ++destOffset;
            }
        } else {
            int i = 0;
            while (i < length) {
                CRuntime.storeInt(root, destOffset, src[srcOffset].intValue());
                ++i;
                ++srcOffset;
                ++destOffset;
            }
        }
    }

    @Override
    public void copyFrom(long[] src) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, 0, src.length);
    }

    @Override
    public void copyFrom(long[] src, int destOffset) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, src.length);
    }

    @Override
    public void copyFrom(long[] src, int destOffset, int length) {
        if (src == null) {
            throw new IllegalArgumentException();
        }
        this.copyFrom(src, 0, destOffset, length);
    }

    @Override
    public void copyFrom(long[] src, int srcOffset, int destOffset, int length) {
        if (src == null || srcOffset < 0 || length < 0 || srcOffset + length > src.length) {
            throw new IllegalArgumentException();
        }
        if (ELEM_SIZE == 8) {
            CRuntime.copyLongArray(this.getRoot(), destOffset, src, srcOffset, length);
        } else {
            int[] intArray = new int[length];
            for (int i = 0; i < length; ++i) {
                intArray[i] = (int)src[i + srcOffset];
            }
            CRuntime.copyIntArray(this.getRoot(), destOffset, intArray, 0, length);
        }
    }

    @Override
    public NLongPtr ofs(int elemOffset) {
        return new NLongPtrImpl(this.getRoot() + (long)(elemOffset * ELEM_SIZE), this);
    }

    @Override
    public boolean isGuarded() {
        return false;
    }

    @Override
    public final NLongPtr getGuarded(int length) {
        return this.getGuarded(0, length);
    }

    @Override
    public NLongPtr getGuarded(int fromIndex, int toIndex) {
        if (toIndex < fromIndex) {
            throw new IllegalArgumentException();
        }
        return new GuardedNLongPtrImpl(this.getRoot(), this, fromIndex, toIndex);
    }

    @Override
    public int getGuardLow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGuardHigh() {
        throw new UnsupportedOperationException();
    }

    static {
        if (ELEM_SIZE != 8 && ELEM_SIZE != 4) {
            throw new RuntimeException("Unexpected long size");
        }
    }

    private static class GuardedConstNLongPtrImpl
    extends GuardedNLongPtrImpl {
        public GuardedConstNLongPtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner, low, hi);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Long obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Long obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Long[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Long[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Long[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Long[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(long[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(long[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(long[] src, int srcOffset, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(long[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final NLongPtr ofs(int elemOffset) {
            return new GuardedConstNLongPtrImpl(this.getRoot() + (long)(elemOffset * ELEM_SIZE), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public NLongPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstNLongPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }

    private static class GuardedNLongPtrImpl
    extends NLongPtrImpl
    implements IGuardedPtr {
        protected final int low;
        protected final int hi;

        public GuardedNLongPtrImpl(long peer, Object bufferOwner, int low, int hi) {
            super(peer, bufferOwner);
            if (low > hi) {
                throw new IllegalArgumentException();
            }
            this.low = low;
            this.hi = hi;
        }

        @Override
        public boolean checkIndex(int index) {
            return index >= this.low && index < this.hi;
        }

        @Override
        public boolean isGuarded() {
            return true;
        }

        @Override
        public long getValue(int idx) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            return super.get(idx);
        }

        @Override
        public Long[] toArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toArray(fromIndex, toIndex);
        }

        @Override
        public long[] toLongArray(int fromIndex, int toIndex) {
            if (!this.checkIndex(fromIndex) || !this.checkIndex(toIndex)) {
                throw new IndexOutOfBoundsException();
            }
            return super.toLongArray(fromIndex, toIndex);
        }

        @Override
        public void copyTo(int srcOffset, Long[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void copyTo(int srcOffset, long[] dest, int destOffset, int length) {
            if (!this.checkIndex(srcOffset) || !this.checkIndex(srcOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyTo(srcOffset, dest, destOffset, length);
        }

        @Override
        public void setValue(int idx, long value) {
            if (!this.checkIndex(idx)) {
                throw new IndexOutOfBoundsException();
            }
            super.set(idx, value);
        }

        @Override
        public void copyFrom(Long[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public void copyFrom(long[] src, int srcOffset, int destOffset, int length) {
            if (!this.checkIndex(destOffset) || !this.checkIndex(destOffset + length - 1)) {
                throw new IndexOutOfBoundsException();
            }
            super.copyFrom(src, srcOffset, destOffset, length);
        }

        @Override
        public NLongPtr ofs(int elemOffset) {
            return new GuardedNLongPtrImpl(this.getRoot() + (long)(elemOffset * ELEM_SIZE), this, this.low + elemOffset, this.hi + elemOffset);
        }

        @Override
        public NLongPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedNLongPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }

        @Override
        public int getGuardLow() {
            return this.low;
        }

        @Override
        public int getGuardHigh() {
            return this.hi;
        }
    }

    static class ConstNLongPtrImpl
    extends NLongPtrImpl {
        protected ConstNLongPtrImpl(Pointer peer) {
            super(peer);
        }

        protected ConstNLongPtrImpl(long peer, Object bufferOwner) {
            super(peer, bufferOwner);
        }

        ConstNLongPtrImpl(int capacity, boolean owned) {
            super(capacity, owned);
        }

        @Override
        public boolean isConstPtr() {
            return true;
        }

        @Override
        public void set(Long obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int idx, Long obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void setValue(int idx, long value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Long[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Long[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(Long[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(Long[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(long[] src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(long[] src, int destOffset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyFrom(long[] src, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void copyFrom(long[] src, int srcOffset, int destOffset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final NLongPtr ofs(int elemOffset) {
            return new ConstNLongPtrImpl(this.getRoot() + (long)(elemOffset * ELEM_SIZE), this);
        }

        @Override
        public NLongPtr getGuarded(int fromIndex, int toIndex) {
            if (toIndex < fromIndex) {
                throw new IllegalArgumentException();
            }
            return new GuardedConstNLongPtrImpl(this.getRoot(), this, fromIndex, toIndex);
        }
    }
}

