/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.objc;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.moe.natj.c.CRuntime;
import org.moe.natj.c.StructObject;
import org.moe.natj.c.ann.Structure;
import org.moe.natj.general.Pointer;
import org.moe.natj.objc.ObjCRuntime;
import org.moe.natj.objc.ann.Selector;

@Structure
public class SEL
extends StructObject {
    private static Map<String, Long> resolvedSelectors = new HashMap<String, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long resolveSelectorByName(String name) {
        Long sel;
        Map<String, Long> map = resolvedSelectors;
        synchronized (map) {
            sel = resolvedSelectors.get(name);
            if (sel == null) {
                sel = ObjCRuntime.registerSelector(name);
                resolvedSelectors.put(name, sel);
            }
        }
        return sel;
    }

    protected SEL(Pointer peer) {
        super(peer);
    }

    public SEL(String name) {
        super(CRuntime.createStrongPointer(SEL.resolveSelectorByName(name), false));
    }

    public SEL(Method method) {
        super(CRuntime.createStrongPointer(SEL.resolveSelectorByName(SEL.getSelectorString(method)), false));
    }

    static String getSelectorString(Method method) {
        Selector ann = method.getAnnotation(Selector.class);
        if (ann == null) {
            throw new RuntimeException("Can not create native selector from non-Objective-C method!");
        }
        return ann.value();
    }
}

