/*
 * Decompiled with CFR 0.152.
 */
package org.moe.natj.objc.map;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.moe.natj.general.Mapper;
import org.moe.natj.general.NatJ;
import org.moe.natj.general.NativeObject;
import org.moe.natj.general.Pointer;
import org.moe.natj.general.ann.NUInt;
import org.moe.natj.general.ann.Runtime;
import org.moe.natj.objc.Class;
import org.moe.natj.objc.ObjCObject;
import org.moe.natj.objc.ObjCOpaqueObject;
import org.moe.natj.objc.ObjCRuntime;
import org.moe.natj.objc.WeakReference;
import org.moe.natj.objc.ann.ObjCProtocolName;
import org.moe.natj.objc.ann.Selector;

@Runtime(value=ObjCRuntime.class)
public class ObjCObjectMapper
implements Mapper {
    private Map<java.lang.Class<?>, Long> class2addr = new HashMap();
    public Map<Object, WeakReference> proxy2addr = new WeakHashMap<Object, WeakReference>();
    public Map<java.lang.Class<?>, NativeProtocolInfo> type2ProtocolInfo = new HashMap();
    private static Pointer.Releaser strongBindingReleaser = new Pointer.Releaser(){

        @Override
        public void release(long peer) {
            ObjCRuntime.lockObject(peer);
            Object instance = ObjCRuntime.getJavaReferenceOfBindingObject(peer);
            if (instance == null) {
                ObjCRuntime.setJavaReferenceOfBindingObject(peer, null);
            }
            ObjCRuntime.unlockObject(peer);
            ObjCRuntime.releaseObject(peer);
        }

        @Override
        public boolean ifFinalizedExternally() {
            return false;
        }
    };

    public static Pointer createStrongBindingPointer(long peer, boolean owned) {
        if (!owned) {
            ObjCRuntime.retainObject(peer);
        }
        return new Pointer(peer, strongBindingReleaser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupObjCProxy(Object peer) {
        Map<Object, WeakReference> map = this.proxy2addr;
        synchronized (map) {
            WeakReference reference = this.proxy2addr.get(peer);
            if (reference != null && reference.getPeer() == null) {
                this.proxy2addr.remove(peer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pointer getNativePeerOfProxyedObject(Object object) {
        Map<Object, WeakReference> map = this.proxy2addr;
        synchronized (map) {
            WeakReference peer = this.proxy2addr.get(object);
            if (peer == null) {
                return null;
            }
            return peer.getPeer();
        }
    }

    public boolean dispose(Object object) {
        InvocationHandler handler;
        ObjCObject peer = null;
        if (object instanceof ObjCObject) {
            peer = (ObjCObject)object;
        }
        if (Proxy.isProxyClass(object.getClass()) && (handler = Proxy.getInvocationHandler(object)) instanceof ObjCOpaqueObject.ProtocolProxyHandler) {
            peer = ((ObjCOpaqueObject.ProtocolProxyHandler)handler).getHolder();
        }
        if (peer != null) {
            long pointer = peer.getPeerPointer();
            ObjCRuntime.lockObject(pointer);
            ObjCRuntime.setJavaReferenceOfBindingObject(pointer, null);
            peer.getPeer().setPeer(0L);
            ObjCRuntime.unlockObject(pointer);
            ObjCRuntime.releaseObject(pointer);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long toNative(Object instance, NatJ.NativeObjectConstructionInfo info) {
        InvocationHandler handler;
        if (instance == null) {
            return 0L;
        }
        if (instance instanceof Proxy && (handler = Proxy.getInvocationHandler(instance)) instanceof ObjCOpaqueObject.ProtocolProxyHandler) {
            instance = ((ObjCOpaqueObject.ProtocolProxyHandler)handler).getHolder();
        }
        if (instance instanceof String) {
            return NatJ.getOrCreateInstanceOfRuntimeClass(ObjCRuntime.class).getStringMapper().toNative(instance, info);
        }
        if (NativeObject.class.isAssignableFrom(instance.getClass())) {
            long peer = ((NativeObject)instance).getPeer().getPeer();
            long opeer = ObjCRuntime.getObjCCastProxyPeer(peer);
            if (opeer != 0L) {
                peer = opeer;
            }
            if (!info.arg && ObjCRuntime.getInitTargetOnCurrentThread() == null) {
                ObjCRuntime.retainObject(peer);
                if (!info.owned) {
                    ObjCRuntime.autoreleaseObject(peer);
                }
            }
            return peer;
        }
        long peer = 0L;
        Map<Object, WeakReference> map = this.proxy2addr;
        synchronized (map) {
            WeakReference reference = this.proxy2addr.get(instance);
            if (reference != null) {
                peer = reference.getNativePeer();
            }
            if (peer == 0L) {
                Long nativeClass;
                java.lang.Class<?> cls = instance.getClass();
                Map<java.lang.Class<?>, Long> map2 = this.class2addr;
                synchronized (map2) {
                    nativeClass = this.class2addr.get(cls);
                    if (nativeClass == null) {
                        nativeClass = List.class.isAssignableFrom(cls) ? Long.valueOf(ObjCRuntime.createProxyClassWithExtension(cls, "NSMutableArray", ListExtension.class)) : (Map.class.isAssignableFrom(cls) ? Long.valueOf(ObjCRuntime.createProxyClassWithExtension(cls, "NSMutableDictionary", MapExtension.class)) : (Set.class.isAssignableFrom(cls) ? Long.valueOf(ObjCRuntime.createProxyClassWithExtension(cls, "NSMutableSet", SetExtension.class)) : (Iterator.class.isAssignableFrom(cls) ? Long.valueOf(ObjCRuntime.createProxyClassWithExtension(cls, "NSEnumerator", IteratorExtension.class)) : Long.valueOf(ObjCRuntime.createProxyClass(cls)))));
                        this.class2addr.put(cls, nativeClass);
                    }
                }
                peer = ObjCRuntime.createProxyInstance(nativeClass, instance);
                this.proxy2addr.put(instance, ObjCRuntime.createWeakReference(peer));
            }
        }
        if (!info.owned) {
            ObjCRuntime.autoreleaseObject(peer);
        }
        return peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getOrCreateProtocolProxy(ObjCOpaqueObject oi, java.lang.Class<?> type) {
        Proxy proxy = oi.proxies.get(type);
        if (proxy == null) {
            NativeProtocolInfo protocolInfo;
            Map<java.lang.Class<?>, NativeProtocolInfo> map = this.type2ProtocolInfo;
            synchronized (map) {
                protocolInfo = this.type2ProtocolInfo.get(type);
                if (protocolInfo == null) {
                    protocolInfo = new NativeProtocolInfo();
                    Object[] dataArray = ObjCRuntime.createDataForNativeProtocolProxy(type);
                    protocolInfo.data = new HashMap();
                    int n = dataArray.length / 2;
                    for (int i = 0; i < n; ++i) {
                        Method method = (Method)dataArray[i * 2];
                        Long data = (Long)dataArray[i * 2 + 1];
                        if (method == null || data == null) continue;
                        protocolInfo.data.put(method, data);
                    }
                    try {
                        protocolInfo.proxyConstructor = Proxy.getProxyClass(type.getClassLoader(), type).getConstructor(InvocationHandler.class);
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException("Could not find proxy for native protocol!", e);
                    }
                    this.type2ProtocolInfo.put(type, protocolInfo);
                }
            }
            try {
                proxy = (Proxy)protocolInfo.proxyConstructor.newInstance(oi.createProtocolProxyHandler(protocolInfo.data));
            }
            catch (Exception e) {
                throw new RuntimeException("Java object construction error!", e);
            }
            oi.proxies.put(type, proxy);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object objectToJava(long peer, NatJ.JavaObjectConstructionInfo info) {
        Object instance;
        block38: {
            boolean isRefSettingNeeded;
            boolean isInherited = ObjCRuntime.isKindOfInheritedClass(peer);
            boolean isProxy = !isInherited && ObjCRuntime.isKindOfProxyClass(peer);
            boolean isHybrid = !isInherited && !isProxy && ObjCRuntime.isKindOfHybridClass(peer);
            boolean isBinding = !isInherited && !isProxy && !isHybrid;
            boolean isLockNeeded = !isProxy && !isInherited;
            boolean isInitHandlingNeeded = !isProxy;
            boolean bl = isRefSettingNeeded = !isInherited;
            if (isLockNeeded) {
                ObjCRuntime.lockObject(peer);
            }
            try {
                Object object = instance = isBinding ? ObjCRuntime.getJavaReferenceOfBindingObject(peer) : ObjCRuntime.getJavaReferenceOfCustomObject(peer);
                if (instance == null || NativeObject.class.isAssignableFrom(instance.getClass()) && ((NativeObject)instance).getPeer().getPeer() == 0L) {
                    java.lang.Class<Object> cls;
                    Object target = null;
                    if (isInitHandlingNeeded && (target = ObjCRuntime.getInitTargetOnCurrentThread()) != null && !info.arg && target instanceof NativeObject) {
                        Pointer pointer = ((NativeObject)target).getPeer();
                        pointer.setPeer(0L);
                    }
                    if (instance != null) {
                        cls = instance.getClass();
                    } else if (isHybrid) {
                        cls = ObjCRuntime.getJavaTypeForHybridClass(ObjCRuntime.getObjectClass(peer));
                    } else if (isInherited) {
                        cls = info.type;
                    } else {
                        Long typeCls = null;
                        NatJ.JavaObjectConstructionInfo javaObjectConstructionInfo = info;
                        synchronized (javaObjectConstructionInfo) {
                            Object[] cache;
                            if (info.data == null) {
                                cache = new Object[]{null, null, null};
                                info.data = cache;
                            } else {
                                cache = (Object[])info.data;
                                typeCls = (Long)cache[1];
                            }
                            if (typeCls == null) {
                                if (ObjCObject.class.isAssignableFrom(info.type)) {
                                    java.lang.Class<?> casted = info.type;
                                    typeCls = Class.fromJavaClass(casted).getPeer().getPeer();
                                    cache[1] = typeCls;
                                } else {
                                    typeCls = 0L;
                                    cache[1] = typeCls;
                                }
                            }
                        }
                        if (typeCls != 0L && typeCls == ObjCRuntime.getObjectClass(peer)) {
                            cls = info.type;
                        } else {
                            cls = ((ObjCRuntime)NatJ.getOrCreateInstanceOfRuntimeClass(ObjCRuntime.class)).resolveObjCClass(ObjCRuntime.getObjectClass(peer));
                            if (!info.type.isAssignableFrom(cls)) {
                                cls = info.type.isInterface() && info.type.isAnnotationPresent(ObjCProtocolName.class) ? ObjCOpaqueObject.class : info.type;
                            }
                        }
                    }
                    Pointer pointer = isBinding ? ObjCObjectMapper.createStrongBindingPointer(peer, info.arg ? false : target != null || info.owned) : ObjCRuntime.createStrongPointer(peer, info.arg ? false : target != null || info.owned);
                    try {
                        Constructor<?> constructor = cls.getDeclaredConstructor(Pointer.class);
                        constructor.setAccessible(true);
                        instance = constructor.newInstance(pointer);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Java object construction error!", ex);
                    }
                    if (isRefSettingNeeded) {
                        if (isBinding) {
                            ObjCRuntime.setJavaReferenceOfBindingObject(peer, instance);
                        } else {
                            ObjCRuntime.setJavaReferenceOfCustomObject(peer, instance);
                        }
                    }
                    if (instance.getClass() == ObjCOpaqueObject.class) {
                        instance = this.getOrCreateProtocolProxy((ObjCOpaqueObject)instance, info.type);
                    }
                    break block38;
                }
                Object target = null;
                if (isInitHandlingNeeded) {
                    target = ObjCRuntime.getInitTargetOnCurrentThread();
                }
                if (!info.arg) {
                    if (target != null) {
                        if (instance != target) {
                            if (target instanceof NativeObject) {
                                ((NativeObject)target).getPeer().setPeer(0L);
                            }
                            ObjCRuntime.releaseObject(peer);
                        }
                    } else if (info.owned) {
                        ObjCRuntime.releaseObject(peer);
                    }
                }
                if (instance.getClass() == ObjCOpaqueObject.class) {
                    instance = this.getOrCreateProtocolProxy((ObjCOpaqueObject)instance, info.type);
                }
            }
            finally {
                if (isLockNeeded) {
                    ObjCRuntime.unlockObject(peer);
                }
            }
        }
        return instance;
    }

    @Override
    public Object toJava(long peer, NatJ.JavaObjectConstructionInfo info) {
        if (peer == 0L) {
            Object target = ObjCRuntime.getInitTargetOnCurrentThread();
            if (target != null && !info.arg && target instanceof NativeObject) {
                Pointer pointer = ((NativeObject)target).getPeer();
                pointer.setPeer(0L);
            }
            return null;
        }
        if (!NativeObject.class.isAssignableFrom(info.type) && ObjCRuntime.isObjectString(peer)) {
            return NatJ.getOrCreateInstanceOfRuntimeClass(ObjCRuntime.class).getStringMapper().toJava(peer, info);
        }
        if (ObjCRuntime.isObjectBlock(peer)) {
            return NatJ.getOrCreateInstanceOfRuntimeClass(ObjCRuntime.class).getCallbackMapper().toJava(peer, info);
        }
        return this.objectToJava(peer, info);
    }

    private static class IteratorExtension
    extends ObjCRuntime.ProxyExtensionBase<Iterator> {
        public IteratorExtension(Object target) {
            super(target);
        }

        @Selector(value="allObjects")
        public Object allObjects() {
            ArrayList ret = new ArrayList();
            while (((Iterator)this.target).hasNext()) {
                Object object = ((Iterator)this.target).next();
                if (object == null) {
                    throw new RuntimeException("Objective-C collections can not hold null values!");
                }
                ret.add(object);
            }
            return ret;
        }

        @Selector(value="nextObject")
        public Object nextObject() {
            if (((Iterator)this.target).hasNext()) {
                Object object = ((Iterator)this.target).next();
                if (object == null) {
                    throw new RuntimeException("Objective-C collections can not hold null values!");
                }
                return object;
            }
            return null;
        }
    }

    private static class SetExtension
    extends ObjCRuntime.ProxyExtensionBase<Set> {
        public SetExtension(Object target) {
            super(target);
        }

        @Selector(value="count")
        @NUInt
        public long count() {
            return ((Set)this.target).size();
        }

        @Selector(value="member:")
        public Object member(Object object) {
            if (object == null) {
                throw new RuntimeException("NSSet can not hold null keys!");
            }
            if (((Set)this.target).contains(object)) {
                return object;
            }
            return null;
        }

        @Selector(value="objectEnumerator")
        public Object objectEnumerator() {
            return ((Set)this.target).iterator();
        }

        @Selector(value="addObject:")
        public void addObject(Object object) {
            if (object == null) {
                throw new RuntimeException("NSSet can not hold null values!");
            }
            ((Set)this.target).add(object);
        }

        @Selector(value="removeObject:")
        public void removeObject(Object object) {
            if (object == null) {
                throw new RuntimeException("NSSet can not hold null values!");
            }
            ((Set)this.target).remove(object);
        }
    }

    private static class MapExtension
    extends ObjCRuntime.ProxyExtensionBase<Map> {
        public MapExtension(Object target) {
            super(target);
        }

        @Selector(value="count")
        @NUInt
        public long count() {
            return ((Map)this.target).size();
        }

        @Selector(value="objectForKey:")
        public Object objectForKey(Object object) {
            if (object == null) {
                throw new RuntimeException("NSDictionary can not hold null keys!");
            }
            Object ret = ((Map)this.target).get(object);
            if (ret == null) {
                throw new RuntimeException("NSDictionary can not hold null values!");
            }
            return ret;
        }

        @Selector(value="keyEnumerator")
        public Object keyEnumerator() {
            return ((Map)this.target).keySet().iterator();
        }

        @Selector(value="setObject:forKey:")
        public void setObjectForKey(Object object, Object key) {
            if (object == null) {
                throw new RuntimeException("NSDictionary can not hold null values!");
            }
            if (key == null) {
                throw new RuntimeException("NSDictionary can not hold null keys!");
            }
            ((Map)this.target).put(key, object);
        }

        @Selector(value="removeObjectForKey:")
        public void removeObjectForKey(Object key) {
            if (key == null) {
                throw new RuntimeException("NSDictionary can not hold null keys!");
            }
            ((Map)this.target).remove(key);
        }
    }

    private static class ListExtension
    extends ObjCRuntime.ProxyExtensionBase<List> {
        public ListExtension(Object target) {
            super(target);
        }

        @Selector(value="count")
        @NUInt
        public long count() {
            return ((List)this.target).size();
        }

        @Selector(value="objectAtIndex:")
        public Object objectAtIndex(@NUInt long index) {
            Object ret = ((List)this.target).get((int)index);
            if (ret == null) {
                throw new RuntimeException("NSArray can not hold null values!");
            }
            return ret;
        }

        @Selector(value="insertObject:atIndex:")
        public void insertObjectAtIndex(Object object, @NUInt long index) {
            if (object == null) {
                throw new RuntimeException("NSArray can not hold null values!");
            }
            ((List)this.target).add((int)index, object);
        }

        @Selector(value="removeObjectAtIndex:")
        public void removeObjectAtIndex(@NUInt long index) {
            ((List)this.target).remove((int)index);
        }

        @Selector(value="addObject:")
        public void addObject(Object object) {
            if (object == null) {
                throw new RuntimeException("NSArray can not hold null values!");
            }
            ((List)this.target).add(object);
        }

        @Selector(value="removeLastObject")
        public void removeLastObject() {
            int last = ((List)this.target).size();
            if (last == 0) {
                throw new RuntimeException("Can not remove element from empty NSArray!");
            }
            ((List)this.target).remove(--last);
        }

        @Selector(value="replaceObjectAtIndex:withObject:")
        public void replaceObjectAtIndexWithObject(@NUInt long index, Object object) {
            if (object == null) {
                throw new RuntimeException("NSArray can not hold null values!");
            }
            ((List)this.target).set((int)index, object);
        }
    }

    private static class NativeProtocolInfo {
        public Constructor<?> proxyConstructor;
        public HashMap<Method, Long> data;

        private NativeProtocolInfo() {
        }
    }
}

