package com.example.myapplication

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material.BottomNavigation
import androidx.compose.material.BottomNavigationItem
import androidx.compose.material.Icon
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Scaffold
import androidx.compose.material.Surface
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.remember
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.tooling.preview.Preview
import androidx.hilt.navigation.compose.hiltViewModel
import androidx.lifecycle.ViewModel
import androidx.navigation.compose.NavHost
import androidx.navigation.compose.composable
import androidx.navigation.compose.currentBackStackEntryAsState
import androidx.navigation.compose.rememberNavController
import com.example.myapplication.ui.theme.MyApplicationTheme
import dagger.hilt.android.AndroidEntryPoint
import dagger.hilt.android.lifecycle.HiltViewModel
import javax.inject.Inject

@AndroidEntryPoint
class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            MyApplicationTheme {
                // A surface container using the 'background' color from the theme
                Surface(
                    modifier = Modifier.fillMaxSize(),
                    color = MaterialTheme.colors.background
                ) {
                    Column(Modifier.fillMaxSize()) {
                        val navController = rememberNavController()
                        Box(
                            Modifier
                                .fillMaxWidth()
                                .weight(1f)) {
                            NavHost(
                                navController = navController,
                                startDestination = "ok",
                                modifier = Modifier.fillMaxSize(),
                            ) {
                                composable("ok") {
                                    Box(Modifier.fillMaxSize(), Alignment.Center) {
                                        Text(text = "ok")
                                    }
                                }
                                composable("hello") {
                                    val navController1 = rememberNavController()

                                    Scaffold {
                                        Box(
                                            Modifier
                                                .fillMaxSize()
                                                .padding(it)) {

                                            NavHost(navController1, startDestination = "ExampleRoute") {
                                                composable("ExampleRoute") {
                                                    val viewModel = hiltViewModel<ExampleViewModel>()
                                                    Box(Modifier.fillMaxSize(), Alignment.Center) {
                                                        Text(text = "hello")
                                                    }
                                                }
                                            }
                                        }

                                    }
                                }
                                composable("world") {
                                    Box(Modifier.fillMaxSize(), Alignment.Center) {
                                        Text(text = "world")
                                    }
                                }
                            }
                        }
                        BottomNavigation(Modifier.fillMaxWidth()) {
                            val navBackStackEntry by navController.currentBackStackEntryAsState()
                            val list = remember { listOf("ok", "hello", "world") }

                            list.forEach { route ->
                                val isSelected = navBackStackEntry?.destination?.route == route
                                BottomNavigationItem(
                                    selected = isSelected,
                                    onClick = {
                                        if (!isSelected) {
                                            navController.navigate(route) {
                                                popUpTo(navController.graph.startDestinationId) {
                                                    saveState = true
                                                }
                                                launchSingleTop = true
                                                restoreState = true

                                            }
                                        }
                                    },
                                    label = {
                                        Text(text = route)
                                    },
                                    icon = {
                                        Icon(
                                            painter = painterResource(android.R.drawable.ic_delete),
                                            contentDescription = null
                                        )
                                    },
                                )
                            }

                        }
                    }
                }
            }
        }
    }
}

@Composable
fun Greeting(name: String) {
    Text(text = "Hello $name!")
}

@Preview(showBackground = true)
@Composable
fun DefaultPreview() {
    MyApplicationTheme {
        Greeting("Android")
    }
}

@HiltViewModel
class ExampleViewModel @Inject constructor() : ViewModel()