package com.example.menuprov;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.core.view.MenuProvider;
import androidx.fragment.app.Fragment;

public class BlankFragment extends Fragment {

    private static final String TAG = "BlankFragment";

    private int fragCount;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_blank, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        final Toolbar toolbar = getActivity().findViewById(R.id.toolbar);

        toolbar.addMenuProvider(new MenuProvider() {
            @Override
            public void onCreateMenu(@NonNull Menu menu, @NonNull MenuInflater menuInflater) {
                Log.d(TAG, "onCreateMenu");

                menu.add(Menu.NONE, R.id.FRAGMENU, 0, R.string.fragmentLabel);
            }

            @Override
            public void onPrepareMenu(@NonNull Menu menu) {
                Log.d(TAG, "onPrepareMenu, fragCount should be=1, but is=" + fragCount);
            }

            @Override
            public void onMenuClosed(@NonNull Menu menu) {
                Log.d(TAG, "onMenuClosed");
            }

            @Override
            public boolean onMenuItemSelected(@NonNull MenuItem menuItem) {
                Log.d(TAG, "onMenuItemSelected, fragCount=" + fragCount);
                return false;
            }
        }, getViewLifecycleOwner());

        fragCount++;
        Log.d(TAG,"onViewCreated is done, fragCount=" + fragCount);
        // and NOW the user opens the menu... hence onPrepareMenu should see count==1
    }
}