package com.example.menuprov;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.view.MenuProvider;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;

import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.Button;

public class MainActivity extends AppCompatActivity {

    private static final String TAG = "MainActivity";

    private int count;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        final Toolbar toolbar = findViewById(R.id.toolbar);
        toolbar.addMenuProvider(new MenuProvider() {
            @Override
            public void onCreateMenu(@NonNull Menu menu, @NonNull MenuInflater menuInflater) {
                Log.d(TAG,"onCreateMenu");

                menu.add(Menu.NONE, R.id.MYMENU, 0, R.string.label);
            }

            @Override
            public void onPrepareMenu(@NonNull Menu menu) {
                Log.d(TAG,"onPrepareMenu, count should be=1, but is=" + count);
            }

            @Override
            public void onMenuClosed(@NonNull Menu menu) {
                Log.d(TAG,"onMenuClosed");
            }

            @Override
            public boolean onMenuItemSelected(@NonNull MenuItem menuItem) {
                Log.d(TAG,"onMenuItemSelected, count=" + count);
                return false;
            }
        },this);

        final Button btn = findViewById(R.id.btn);
        btn.setOnClickListener(view -> {
            final FragmentManager fm = getSupportFragmentManager();
            if (fm.findFragmentByTag("fragmentTag") == null) {
                final Fragment fragment = new BlankFragment();
                fm.beginTransaction()
                        .setReorderingAllowed(true)
                        .add(R.id.container, fragment, "fragmentTag")
                        .commit();
            }

        });

        count++;
        Log.d(TAG,"onCreate is done, count=" + count);
        // and NOW the user opens the menu... hence onPrepareMenu should see count==1
    }
}