package com.example.composelazylistlag

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.text.BasicText
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color

@Composable
fun ContentItem(
    index: Int,
    modifier: Modifier = Modifier,
) {
    Box(
        modifier = Modifier
            .background(color = Color(colorList[index % 4]))
            .then(modifier),
        contentAlignment = Alignment.Center
    ) {
        BasicText(
            text = "#$index",
            style = Config.ContentItemTextStyle
        )
    }
}