package com.example.composelazylistlag

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.ExperimentalFoundationApi
import androidx.compose.foundation.gestures.LocalOverScrollConfiguration
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.heightIn
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.runtime.Composable
import androidx.compose.runtime.CompositionLocalProvider
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp

object Config {

    /**
     * Switch to true to disable the overscroll bug
     */
    const val DisableOverscroll = false

    val ContentItemHeight = 80.dp
    val ContentItemTextStyle = TextStyle.Default.copy(
        fontWeight = FontWeight.Bold,
        color = Color.White,
        fontSize = 28.sp
    )
}

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent { Content() }
    }
}

@Composable
fun Content() {
    OverscrollController {
        LazyColumn {
            items(100) { index ->
                ContentItem(
                    index,
                    modifier = Modifier
                        .fillMaxWidth()
                        .height(Config.ContentItemHeight)
                )
            }
        }
    }
}

@OptIn(ExperimentalFoundationApi::class)
@Composable
private fun OverscrollController(content: @Composable () -> Unit) =
    if (Config.DisableOverscroll) CompositionLocalProvider(
        LocalOverScrollConfiguration provides null,
        content = content
    ) else content()

