// Copyright 2022 Yandex LLC. All rights reserved.

package foo.bar.baz.package1;

import android.os.Handler;
import android.util.Log;

import androidx.annotation.Keep;

import java.lang.ref.WeakReference;

public class Bar {
    @SuppressWarnings("FieldCanBeLocal")
    private final Runnable runnable;

    public Bar(Post post) {
        runnable = new Runnable() {
            @Override
            public void run() {
                Log.e("Bar", "message");
            }
        };
        post.post(runnable);
    }

    public static class Post {
        private final Handler handler = new Handler();

        @Keep
        public void post(Runnable runnable) {
            WeakReference<Runnable> reference = new WeakReference<>(runnable);
            System.gc();
            handler.post(new Runnable() {
                @Override
                public void run() {
                    Runnable runnable = reference.get();
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            });
        }


    }

}
