package com.bestitguys.glancetest.work

import android.app.Notification
import android.content.Context
import android.content.pm.ServiceInfo
import android.os.Build
import androidx.core.app.NotificationCompat
import androidx.work.CoroutineWorker
import androidx.work.ForegroundInfo
import androidx.work.WorkerParameters
import com.bestitguys.glancetest.App
import com.bestitguys.glancetest.R

abstract class CoroutineWorkerCompat(
    appContext: Context,
    workerParams: WorkerParameters
): CoroutineWorker(appContext, workerParams) {

    companion object{
        const val ID = 34653464
        const val CHANNEL_ID_SERVICE = "service"

        fun foregroundService(msg: String): Notification {
            val mBuilder = NotificationCompat.Builder(App.context, CHANNEL_ID_SERVICE)
                .setSmallIcon(R.drawable.ic_notification)
                .setTicker(msg)
                .setContentTitle(msg)
                .setContentText(msg)
                .setOngoing(true)

            return mBuilder.build()
        }
    }

    val workDescription = "Running background tasks..."

    override suspend fun getForegroundInfo(): ForegroundInfo {
        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            ForegroundInfo(
                ID,
                foregroundService(workDescription),
                ServiceInfo.FOREGROUND_SERVICE_TYPE_DATA_SYNC
            )
        } else {
            ForegroundInfo(
                ID,
                foregroundService(workDescription)
            )
        }
    }
}