package com.example.myapplication

import android.app.Dialog
import android.content.*
import android.os.Bundle
import android.util.Log
import android.view.*
import androidx.appcompat.widget.SearchView
import androidx.core.view.MenuProvider
import androidx.fragment.app.*
import androidx.fragment.app.FragmentManager.FragmentLifecycleCallbacks
import androidx.navigation.fragment.findNavController
import com.example.myapplication.databinding.FragmentFirstBinding
import com.google.android.material.dialog.MaterialAlertDialogBuilder

/**
 * A simple [Fragment] subclass as the default destination in the navigation.
 */
class FirstFragment : Fragment() {
    private lateinit var searchHolder: SearchHolder
    private var _binding: FragmentFirstBinding? = null

    private val binding get() = _binding!!

    override fun onAttach(context: Context) {
        super.onAttach(context)
        searchHolder = SearchHolder(requireActivity())
        childFragmentManager.registerFragmentLifecycleCallbacks(object :
            FragmentLifecycleCallbacks() {
            override fun onFragmentViewDestroyed(fm: FragmentManager, f: Fragment) {
                super.onFragmentViewDestroyed(fm, f)
                if (f is DialogFragment) {
                    (activity as? MainActivity?)?.temporaryIgnoreInvalidationOfMenu = true
                }
            }
        }, false)
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        _binding = FragmentFirstBinding.inflate(inflater, container, false)
        requireActivity().addMenuProvider(getMenuProvider(), viewLifecycleOwner)
        return binding.root
    }

    private fun getMenuProvider(): MenuProvider {
        return object : MenuProvider {
            override fun onCreateMenu(menu: Menu, inflater: MenuInflater) {
//                menu.clear()
                inflater.inflate(R.menu.menu_main, menu)
                val onQueryTextListener = object : SearchView.OnQueryTextListener {
                    var lastQuery: String? = null
                    override fun onQueryTextChange(newText: String): Boolean {
                        if (newText.equals(
                                lastQuery,
                                true
                            ) || isNotAddedOrActivityFinishingOrDestroyed()
                        ) return true
                        lastQuery = newText
                        Log.d("AppLog", "new query:$newText")
                        return true
                    }

                    override fun onQueryTextSubmit(query: String): Boolean {
                        return false
                    }
                }
                val onActionExpandListener = object : MenuItem.OnActionExpandListener {
                    override fun onMenuItemActionCollapse(item: MenuItem): Boolean = true

                    override fun onMenuItemActionExpand(item: MenuItem): Boolean = true
                }
                searchHolder.init(
                    menu.findItem(R.id.menuItem_search),
                    R.string.search,
                    onQueryTextListener,
                    onActionExpandListener
                )
            }

            override fun onMenuItemSelected(item: MenuItem): Boolean {
                when (item.itemId) {
                    R.id.menuItem_openDialog -> {
                        MaterialAlertDialogBuilder(activity!!).setTitle("press OK to invalidate options")
                            .setPositiveButton(
                                android.R.string.ok
                            ) { dialog, which ->
                                activity!!.invalidateOptionsMenu()
                            }
                            .show()
                    }
                    R.id.menuItem_openDialogFragment -> {
                        SomeDialogFragment().showAllowStateLoss(this@FirstFragment)
                        return true
                    }
                }
                return false
            }
        }
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        binding.buttonFirst.setOnClickListener {
            findNavController().navigate(R.id.action_FirstFragment_to_SecondFragment)
        }
    }

    override fun onDestroyView() {
        super.onDestroyView()
        _binding = null
    }

    class SomeDialogFragment : DialogFragment() {
        override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
            return MaterialAlertDialogBuilder(requireActivity()).setTitle("test")
                .setMessage("if you close the dialog, the searchView is reset, but if you use a normal dialog instead of a dialog fragment, it is fine...")
                .setPositiveButton(
                    android.R.string.ok
                ) { dialog, which ->
                }
                .create()
        }
    }
}
